/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.locking;

import javax.transaction.Transaction;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.tx.locking.AbstractClusteredTxTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.locking.OptimisticReplTxTest")
public class OptimisticReplTxTest
extends AbstractClusteredTxTest {
    CacheMode cacheMode = CacheMode.REPL_SYNC;

    public void testTxProgress() throws Exception {
        this.tm(0).begin();
        this.cache(0).put(this.k, (Object)"v1");
        Transaction tx1 = this.tm(0).suspend();
        this.tm(0).begin();
        this.cache(0).put(this.k, (Object)"v2");
        this.tm(0).commit();
        assert (this.cache(0).get(this.k).equals("v2"));
        assert (this.cache(1).get(this.k).equals("v2"));
        this.tm(0).resume(tx1);
        this.tm(0).commit();
        assert (this.cache(0).get(this.k).equals("v1"));
        assert (this.cache(1).get(this.k).equals("v1"));
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.k = "k";
        ConfigurationBuilder conf = OptimisticReplTxTest.getDefaultClusteredCacheConfig(this.cacheMode, true);
        conf.transaction().lockingMode(LockingMode.OPTIMISTIC).transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        this.createCluster(conf, 2);
        this.waitForClusterToForm();
    }

    @Override
    protected void assertLocking() {
        Assert.assertFalse((boolean)this.lockManager(0).isLocked(this.k));
        Assert.assertFalse((boolean)this.lockManager(1).isLocked(this.k));
        this.prepare();
        Assert.assertTrue((boolean)this.lockManager(0).isLocked(this.k));
        Assert.assertFalse((boolean)this.lockManager(1).isLocked(this.k));
        this.commit();
        Assert.assertFalse((boolean)this.lockManager(0).isLocked(this.k));
        Assert.assertFalse((boolean)this.lockManager(1).isLocked(this.k));
    }

    @Override
    protected void assertLockingNoChanges() {
        Assert.assertFalse((boolean)this.lockManager(0).isLocked(this.k));
        Assert.assertFalse((boolean)this.lockManager(1).isLocked(this.k));
        this.prepare();
        Assert.assertFalse((boolean)this.lockManager(0).isLocked(this.k));
        Assert.assertFalse((boolean)this.lockManager(1).isLocked(this.k));
        this.commit();
        Assert.assertFalse((boolean)this.lockManager(0).isLocked(this.k));
        Assert.assertFalse((boolean)this.lockManager(1).isLocked(this.k));
    }
}

