/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.recovery;

import javax.transaction.xa.Xid;
import junit.framework.Assert;
import org.infinispan.config.Configuration;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.tm.DummyTransaction;
import org.infinispan.tx.recovery.RecoveryDummyTransactionManagerLookup;
import org.infinispan.tx.recovery.RecoveryTestUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.recovery.InDoubtXidReturnedOnceTest")
public class InDoubtXidReturnedOnceTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration configuration = InDoubtXidReturnedOnceTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, true);
        configuration.fluent().locking().useLockStriping(Boolean.valueOf(false));
        configuration.fluent().transaction().transactionManagerLookupClass(RecoveryDummyTransactionManagerLookup.class).recovery();
        configuration.fluent().clustering().hash().rehashEnabled(Boolean.valueOf(false));
        configuration.fluent().hash().numOwners(Integer.valueOf(3));
        configuration.fluent().transaction().recovery();
        this.createCluster(configuration, 4);
        this.waitForClusterToForm();
    }

    public void testXidReturnedOnlyOnce() throws Throwable {
        DummyTransaction dummyTransaction1 = RecoveryTestUtil.beginAndSuspendTx(this.cache(3));
        RecoveryTestUtil.prepareTransaction(dummyTransaction1);
        this.manager(3).stop();
        TestingUtil.blockUntilViewsReceived(60000L, false, this.cache(0), this.cache(1), this.cache(2));
        DummyTransaction dummyTransaction = RecoveryTestUtil.beginAndSuspendTx(this.cache(0));
        Xid[] recover = dummyTransaction.firstEnlistedResource().recover(0x1800000);
        Assert.assertEquals((int)recover.length, (int)1);
        Assert.assertEquals((Object)dummyTransaction1.getXid(), (Object)recover[0]);
    }
}

