/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.mocks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.Xid;
import org.infinispan.Cache;
import org.infinispan.atomic.Delta;
import org.infinispan.commands.CancelCommand;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.CreateCacheCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.DistributedExecuteCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.MapCombineCommand;
import org.infinispan.commands.read.ReduceCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.read.ValuesCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.remote.recovery.CompleteTransactionCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTxInfoCommand;
import org.infinispan.commands.remote.recovery.TxCompletionNotificationCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.tx.VersionedCommitCommand;
import org.infinispan.commands.tx.VersionedPrepareCommand;
import org.infinispan.commands.write.ApplyDeltaCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.VersionedPutKeyValueCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.context.Flag;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateChunk;
import org.infinispan.statetransfer.StateRequestCommand;
import org.infinispan.statetransfer.StateResponseCommand;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.concurrent.ReclosableLatch;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ControlledCommandFactory
implements CommandsFactory {
    private static Log log = LogFactory.getLog(ControlledCommandFactory.class);
    public final CommandsFactory actual;
    public final ReclosableLatch gate = new ReclosableLatch(true);
    public final AtomicInteger remoteCommandsReceived = new AtomicInteger(0);
    public final AtomicInteger blockTypeCommandsReceived = new AtomicInteger(0);
    public final List<ReplicableCommand> receivedCommands = new ArrayList<ReplicableCommand>();
    public final Class<? extends ReplicableCommand> toBlock;

    public ControlledCommandFactory(CommandsFactory actual, Class<? extends ReplicableCommand> toBlock) {
        this.actual = actual;
        this.toBlock = toBlock;
    }

    public int received(Class<? extends ReplicableCommand> command) {
        int result = 0;
        for (ReplicableCommand r : this.receivedCommands) {
            if (r.getClass() != command) continue;
            ++result;
        }
        return result;
    }

    public void initializeReplicableCommand(ReplicableCommand command, boolean isRemote) {
        log.tracef("Received command %s", (Object)command);
        this.receivedCommands.add(command);
        if (isRemote) {
            this.remoteCommandsReceived.incrementAndGet();
            if (this.toBlock != null && command.getClass().isAssignableFrom(this.toBlock)) {
                this.blockTypeCommandsReceived.incrementAndGet();
                try {
                    this.gate.await();
                    log.tracef("gate is opened, processing the lock cleanup:  %s", (Object)command);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.actual.initializeReplicableCommand(command, isRemote);
    }

    public static ControlledCommandFactory registerControlledCommandFactory(Cache cache, Class<? extends ReplicableCommand> toBlock) {
        ComponentRegistry componentRegistry = cache.getAdvancedCache().getComponentRegistry();
        ControlledCommandFactory ccf = new ControlledCommandFactory(componentRegistry.getCommandsFactory(), toBlock);
        TestingUtil.replaceField(ccf, "commandsFactory", componentRegistry, ComponentRegistry.class);
        componentRegistry.registerComponent((Object)ccf, CommandsFactory.class);
        componentRegistry.getGlobalComponentRegistry().registerNamedComponentRegistry(componentRegistry, "___defaultcache");
        return ccf;
    }

    public PutKeyValueCommand buildPutKeyValueCommand(Object key, Object value, long lifespanMillis, long maxIdleTimeMillis, Set<Flag> flags) {
        return this.actual.buildPutKeyValueCommand(key, value, lifespanMillis, maxIdleTimeMillis, flags);
    }

    public VersionedPutKeyValueCommand buildVersionedPutKeyValueCommand(Object key, Object value, long lifespanMillis, long maxIdleTimeMillis, EntryVersion version, Set<Flag> flags) {
        return this.actual.buildVersionedPutKeyValueCommand(key, value, lifespanMillis, maxIdleTimeMillis, version, flags);
    }

    public RemoveCommand buildRemoveCommand(Object key, Object value, Set<Flag> flags) {
        return this.actual.buildRemoveCommand(key, value, flags);
    }

    public InvalidateCommand buildInvalidateCommand(Set<Flag> flags, Object ... keys) {
        return this.actual.buildInvalidateCommand(flags, keys);
    }

    public InvalidateCommand buildInvalidateFromL1Command(boolean forRehash, Set<Flag> flags, Object ... keys) {
        return this.actual.buildInvalidateFromL1Command(forRehash, flags, keys);
    }

    public InvalidateCommand buildInvalidateFromL1Command(boolean forRehash, Set<Flag> flags, Collection<Object> keys) {
        return this.actual.buildInvalidateFromL1Command(forRehash, flags, keys);
    }

    public InvalidateCommand buildInvalidateFromL1Command(Address origin, boolean forRehash, Set<Flag> flags, Collection<Object> keys) {
        return this.actual.buildInvalidateFromL1Command(origin, forRehash, flags, keys);
    }

    public ReplaceCommand buildReplaceCommand(Object key, Object oldValue, Object newValue, long lifespanMillis, long maxIdleTimeMillis, Set<Flag> flags) {
        return this.actual.buildReplaceCommand(key, oldValue, newValue, lifespanMillis, maxIdleTimeMillis, flags);
    }

    public SizeCommand buildSizeCommand() {
        return this.actual.buildSizeCommand();
    }

    public GetKeyValueCommand buildGetKeyValueCommand(Object key, Set<Flag> flags) {
        return this.actual.buildGetKeyValueCommand(key, flags);
    }

    public GetCacheEntryCommand buildGetCacheEntryCommand(Object key, Set<Flag> flags) {
        return this.actual.buildGetCacheEntryCommand(key, flags);
    }

    public KeySetCommand buildKeySetCommand() {
        return this.actual.buildKeySetCommand();
    }

    public ValuesCommand buildValuesCommand() {
        return this.actual.buildValuesCommand();
    }

    public EntrySetCommand buildEntrySetCommand() {
        return this.actual.buildEntrySetCommand();
    }

    public PutMapCommand buildPutMapCommand(Map<?, ?> map, long lifespanMillis, long maxIdleTimeMillis, Set<Flag> flags) {
        return this.actual.buildPutMapCommand(map, lifespanMillis, maxIdleTimeMillis, flags);
    }

    public ClearCommand buildClearCommand(Set<Flag> flags) {
        return this.actual.buildClearCommand(flags);
    }

    public EvictCommand buildEvictCommand(Object key, Set<Flag> flags) {
        return this.actual.buildEvictCommand(key, flags);
    }

    public PrepareCommand buildPrepareCommand(GlobalTransaction gtx, List<WriteCommand> modifications, boolean onePhaseCommit) {
        return this.actual.buildPrepareCommand(gtx, modifications, onePhaseCommit);
    }

    public VersionedPrepareCommand buildVersionedPrepareCommand(GlobalTransaction gtx, List<WriteCommand> modifications, boolean onePhase) {
        return this.actual.buildVersionedPrepareCommand(gtx, modifications, onePhase);
    }

    public CommitCommand buildCommitCommand(GlobalTransaction gtx) {
        return this.actual.buildCommitCommand(gtx);
    }

    public VersionedCommitCommand buildVersionedCommitCommand(GlobalTransaction gtx) {
        return this.actual.buildVersionedCommitCommand(gtx);
    }

    public RollbackCommand buildRollbackCommand(GlobalTransaction gtx) {
        return this.actual.buildRollbackCommand(gtx);
    }

    public MultipleRpcCommand buildReplicateCommand(List<ReplicableCommand> toReplicate) {
        return this.actual.buildReplicateCommand(toReplicate);
    }

    public SingleRpcCommand buildSingleRpcCommand(ReplicableCommand call) {
        return this.actual.buildSingleRpcCommand(call);
    }

    public ClusteredGetCommand buildClusteredGetCommand(Object key, Set<Flag> flags, boolean acquireRemoteLock, GlobalTransaction gtx) {
        return this.actual.buildClusteredGetCommand(key, flags, acquireRemoteLock, gtx);
    }

    public LockControlCommand buildLockControlCommand(Collection<Object> keys, Set<Flag> flags, GlobalTransaction gtx) {
        return this.actual.buildLockControlCommand(keys, flags, gtx);
    }

    public LockControlCommand buildLockControlCommand(Object key, Set<Flag> flags, GlobalTransaction gtx) {
        return this.actual.buildLockControlCommand(key, flags, gtx);
    }

    public LockControlCommand buildLockControlCommand(Collection<Object> keys, Set<Flag> flags) {
        return this.actual.buildLockControlCommand(keys, flags);
    }

    public StateRequestCommand buildStateRequestCommand(StateRequestCommand.Type subtype, Address sender, int viewId, Set<Integer> segments) {
        return this.actual.buildStateRequestCommand(subtype, sender, viewId, segments);
    }

    public StateResponseCommand buildStateResponseCommand(Address sender, int viewId, Collection<StateChunk> stateChunks) {
        return this.actual.buildStateResponseCommand(sender, viewId, stateChunks);
    }

    public String getCacheName() {
        return this.actual.getCacheName();
    }

    public GetInDoubtTransactionsCommand buildGetInDoubtTransactionsCommand() {
        return this.actual.buildGetInDoubtTransactionsCommand();
    }

    public TxCompletionNotificationCommand buildTxCompletionNotificationCommand(Xid xid, GlobalTransaction globalTransaction) {
        return this.actual.buildTxCompletionNotificationCommand(xid, globalTransaction);
    }

    public <T> DistributedExecuteCommand<T> buildDistributedExecuteCommand(Callable<T> callable, Address sender, Collection keys) {
        return this.actual.buildDistributedExecuteCommand(callable, sender, keys);
    }

    public <KIn, VIn, KOut, VOut> MapCombineCommand<KIn, VIn, KOut, VOut> buildMapCombineCommand(String taskId, Mapper<KIn, VIn, KOut, VOut> m, Reducer<KOut, VOut> r, Collection<KIn> keys) {
        return this.actual.buildMapCombineCommand(taskId, m, r, keys);
    }

    public <KOut, VOut> ReduceCommand<KOut, VOut> buildReduceCommand(String taskId, String destinationCache, Reducer<KOut, VOut> r, Collection<KOut> keys) {
        return this.actual.buildReduceCommand(taskId, destinationCache, r, keys);
    }

    public GetInDoubtTxInfoCommand buildGetInDoubtTxInfoCommand() {
        return this.actual.buildGetInDoubtTxInfoCommand();
    }

    public CompleteTransactionCommand buildCompleteTransactionCommand(Xid xid, boolean commit) {
        return this.actual.buildCompleteTransactionCommand(xid, commit);
    }

    public TxCompletionNotificationCommand buildTxCompletionNotificationCommand(long internalId) {
        return this.actual.buildTxCompletionNotificationCommand(internalId);
    }

    public ApplyDeltaCommand buildApplyDeltaCommand(Object deltaAwareValueKey, Delta delta, Collection keys) {
        return this.actual.buildApplyDeltaCommand(deltaAwareValueKey, delta, keys);
    }

    public CreateCacheCommand buildCreateCacheCommand(String cacheName, String cacheConfigurationName) {
        return this.actual.buildCreateCacheCommand(cacheName, cacheConfigurationName);
    }

    public CancelCommand buildCancelCommandCommand(UUID commandUUID) {
        return this.actual.buildCancelCommandCommand(commandUUID);
    }

    public CreateCacheCommand buildCreateCacheCommand(String tmpCacheName, String defaultTmpCacheConfigurationName, boolean start, int size) {
        return this.actual.buildCreateCacheCommand(tmpCacheName, defaultTmpCacheConfigurationName, start, size);
    }
}

