/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.offline;

import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.xsite.BackupSender;
import org.infinispan.xsite.BackupSenderImpl;
import org.infinispan.xsite.BaseSiteUnreachableTest;
import org.infinispan.xsite.OfflineStatus;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.offline.NonTxOfflineTest")
public class NonTxOfflineTest
extends BaseSiteUnreachableTest {
    private static final int FAILURES = 8;
    protected int nrRpcPerPut = 1;

    public NonTxOfflineTest() {
        this.failures = 8;
        this.lonBackupFailurePolicy = BackupFailurePolicy.FAIL;
    }

    public void testPutWithFailures() {
        int i;
        BackupSenderImpl bs = (BackupSenderImpl)this.cache("LON", 0).getAdvancedCache().getComponentRegistry().getComponent(BackupSender.class);
        OfflineStatus nycStatus = bs.getOfflineStatus("NYC");
        for (i = 0; i < 8 / this.nrRpcPerPut; ++i) {
            try {
                junit.framework.Assert.assertEquals((Object)BackupSender.BringSiteOnlineResponse.ALREADY_ONLINE, (Object)bs.bringSiteOnline("NYC"));
                this.cache("LON", 0).put((Object)("k" + i), (Object)("v" + i));
                Assert.fail((String)"This should have failed");
                continue;
            }
            catch (Exception e) {
                Assert.assertEquals((long)(i + 1), (long)nycStatus.getFailureCount());
            }
        }
        assert (nycStatus.isOffline());
        for (i = 0; i < 8; ++i) {
            this.cache("LON", 0).put((Object)("k" + i), (Object)("v" + i));
        }
        for (i = 0; i < 8; ++i) {
            junit.framework.Assert.assertEquals((Object)("v" + i), (Object)this.cache("LON", 0).get((Object)("k" + i)));
        }
        junit.framework.Assert.assertEquals((Object)BackupSender.BringSiteOnlineResponse.NO_SUCH_SITE, (Object)bs.bringSiteOnline("NO_SITE"));
        junit.framework.Assert.assertEquals((Object)BackupSender.BringSiteOnlineResponse.BROUGHT_ONLINE, (Object)bs.bringSiteOnline("NYC"));
        for (i = 0; i < 8 / this.nrRpcPerPut; ++i) {
            try {
                this.cache("LON", 0).put((Object)("k" + i), (Object)("v" + i));
                Assert.fail((String)"This should have failed");
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        return NonTxOfflineTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, false);
    }
}

