/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.common.util.CheckArg;
import org.modeshape.sequencer.ddl.DdlParser;
import org.modeshape.sequencer.ddl.DdlParserScorer;
import org.modeshape.sequencer.ddl.DdlSequencerI18n;
import org.modeshape.sequencer.ddl.StandardDdlParser;
import org.modeshape.sequencer.ddl.dialect.derby.DerbyDdlParser;
import org.modeshape.sequencer.ddl.dialect.oracle.OracleDdlParser;
import org.modeshape.sequencer.ddl.dialect.postgres.PostgresDdlParser;
import org.modeshape.sequencer.ddl.dialect.teiid.TeiidDdlParser;
import org.modeshape.sequencer.ddl.node.AstNode;
import org.modeshape.sequencer.ddl.node.AstNodeFactory;

@Immutable
public class DdlParsers {
    private static final Comparator<Map.Entry<DdlParser, Integer>> SORTER = new Comparator<Map.Entry<DdlParser, Integer>>(){

        @Override
        public int compare(Map.Entry<DdlParser, Integer> thisEntry, Map.Entry<DdlParser, Integer> thatEntry) {
            int result = thisEntry.getValue().compareTo(thatEntry.getValue()) * -1;
            if (result == 0) {
                if ("SQL92".equals(thisEntry.getKey().getId()) && !"SQL92".equals(thatEntry.getKey().getId())) {
                    return -1;
                }
                if ("SQL92".equals(thatEntry.getKey().getId()) && !"SQL92".equals(thisEntry.getKey().getId())) {
                    return 1;
                }
            }
            return result;
        }
    };
    public static final List<DdlParser> BUILTIN_PARSERS;
    private List<DdlParser> parsers;
    private AstNodeFactory nodeFactory = new AstNodeFactory();

    public DdlParsers() {
        this.parsers = BUILTIN_PARSERS;
    }

    public DdlParsers(List<DdlParser> parsers) {
        this.parsers = parsers != null && !parsers.isEmpty() ? parsers : BUILTIN_PARSERS;
    }

    public AstNode parseUsing(String ddl, String parserId) throws ParsingException {
        CheckArg.isNotEmpty((String)ddl, (String)"ddl");
        CheckArg.isNotEmpty((String)parserId, (String)"parserId");
        DdlParser parser = null;
        for (DdlParser ddlParser : this.parsers) {
            if (!parserId.equals(ddlParser.getId())) continue;
            parser = ddlParser;
            break;
        }
        if (parser == null) {
            throw new ParsingException(Position.EMPTY_CONTENT_POSITION, DdlSequencerI18n.unknownParser.text(new Object[]{parserId}));
        }
        AstNode astRoot = this.nodeFactory.node("ddl:statements");
        astRoot.setProperty("jcr:primaryType", (Object)"nt:unstructured");
        astRoot.setProperty("ddl:parserId", (Object)parserId);
        parser.parse(ddl, astRoot, null);
        return astRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AstNode parse(String ddl, String fileName) throws ParsingException {
        CheckArg.isNotEmpty((String)ddl, (String)"ddl");
        RuntimeException firstException = null;
        HashMap<DdlParser, Integer> scoreMap = new HashMap<DdlParser, Integer>(this.parsers.size());
        DdlParserScorer scorer = new DdlParserScorer();
        for (DdlParser parser : this.parsers) {
            try {
                parser.score(ddl, fileName, scorer);
                scoreMap.put(parser, scorer.getScore());
            }
            catch (RuntimeException e) {
                if (firstException != null) continue;
                firstException = e;
            }
            finally {
                scorer.reset();
            }
        }
        if (scoreMap.isEmpty()) {
            if (firstException == null) {
                throw new ParsingException(Position.EMPTY_CONTENT_POSITION, DdlSequencerI18n.errorParsingDdlContent.text(new Object[]{this.parsers.size()}));
            }
            throw firstException;
        }
        ArrayList scoredParsers = new ArrayList(scoreMap.entrySet());
        Collections.sort(scoredParsers, SORTER);
        firstException = null;
        AstNode astRoot = null;
        for (Map.Entry entry : scoredParsers) {
            try {
                DdlParser parser = (DdlParser)entry.getKey();
                astRoot = this.nodeFactory.node("ddl:statements");
                astRoot.setProperty("jcr:primaryType", (Object)"nt:unstructured");
                astRoot.setProperty("ddl:parserId", (Object)parser.getId());
                parser.parse(ddl, astRoot, null);
                return astRoot;
            }
            catch (RuntimeException e) {
                if (astRoot != null) {
                    astRoot.removeFromParent();
                }
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException == null) {
            throw new ParsingException(Position.EMPTY_CONTENT_POSITION, DdlSequencerI18n.errorParsingDdlContent.text(new Object[0]));
        }
        throw firstException;
    }

    static {
        ArrayList<StandardDdlParser> parsers = new ArrayList<StandardDdlParser>();
        parsers.add(new StandardDdlParser());
        parsers.add(new OracleDdlParser());
        parsers.add(new DerbyDdlParser());
        parsers.add(new PostgresDdlParser());
        parsers.add(new TeiidDdlParser());
        BUILTIN_PARSERS = Collections.unmodifiableList(parsers);
    }
}

