/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.IoUtil;
import org.modeshape.jcr.api.nodetype.NodeTypeManager;
import org.modeshape.jcr.api.sequencer.Sequencer;
import org.modeshape.sequencer.ddl.DdlParser;
import org.modeshape.sequencer.ddl.DdlParsers;
import org.modeshape.sequencer.ddl.DdlSequencerI18n;
import org.modeshape.sequencer.ddl.node.AstNode;

@NotThreadSafe
public class DdlSequencer
extends Sequencer {
    private static final Logger LOGGER = Logger.getLogger(DdlSequencer.class);
    protected static final URL[] DEFAULT_CLASSPATH = new URL[0];
    protected static final List<String> DEFAULT_GRAMMARS;
    protected static final Map<String, DdlParser> STANDARD_PARSERS_BY_NAME;
    private String[] parserGrammars = DEFAULT_GRAMMARS.toArray(new String[DEFAULT_GRAMMARS.size()]);
    private URL[] classpath = DEFAULT_CLASSPATH;
    private final Map<AstNode, Node> nodeMap = new HashMap<AstNode, Node>();

    public String[] getGrammars() {
        return this.parserGrammars;
    }

    public void setGrammars(String[] grammarNamesOrClasses) {
        this.parserGrammars = grammarNamesOrClasses != null && grammarNamesOrClasses.length != 0 ? grammarNamesOrClasses : DEFAULT_GRAMMARS.toArray(new String[DEFAULT_GRAMMARS.size()]);
    }

    public URL[] getClasspath() {
        return this.classpath;
    }

    public void setClasspath(URL[] classpath) {
        this.classpath = classpath != null ? classpath : DEFAULT_CLASSPATH;
    }

    protected DdlParsers createParsers(List<DdlParser> parsers) {
        return new DdlParsers(parsers);
    }

    protected List<DdlParser> getParserList() {
        LinkedList<DdlParser> parserList = new LinkedList<DdlParser>();
        for (String grammar : this.getGrammars()) {
            if (grammar == null) continue;
            String lowercaseGrammar = grammar.toLowerCase();
            DdlParser parser = STANDARD_PARSERS_BY_NAME.get(lowercaseGrammar);
            if (parser == null) {
                try {
                    URLClassLoader classloader = new URLClassLoader(this.getClasspath(), Thread.currentThread().getContextClassLoader());
                    Class<?> componentClass = Class.forName(grammar, true, classloader);
                    parser = (DdlParser)componentClass.newInstance();
                }
                catch (Throwable e) {
                    if (this.classpath == null || this.classpath.length == 0) {
                        LOGGER.error(e, (I18nResource)DdlSequencerI18n.errorInstantiatingParserForGrammarUsingDefaultClasspath, new Object[]{grammar, e.getLocalizedMessage()});
                    }
                    LOGGER.error(e, (I18nResource)DdlSequencerI18n.errorInstantiatingParserForGrammarClasspath, new Object[]{grammar, this.classpath, e.getLocalizedMessage()});
                }
            }
            if (parser == null) continue;
            parserList.add(parser);
        }
        return parserList;
    }

    public void initialize(NamespaceRegistry registry, NodeTypeManager nodeTypeManager) throws RepositoryException, IOException {
        this.registerNodeTypes("StandardDdl.cnd", nodeTypeManager, true);
        this.registerNodeTypes("dialect/derby/DerbyDdl.cnd", nodeTypeManager, true);
        this.registerNodeTypes("dialect/oracle/OracleDdl.cnd", nodeTypeManager, true);
        this.registerNodeTypes("dialect/postgres/PostgresDdl.cnd", nodeTypeManager, true);
        this.registerNodeTypes("dialect/teiid/TeiidDdl.cnd", nodeTypeManager, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Property inputProperty, Node outputNode, Sequencer.Context context) throws Exception {
        AstNode rootNode;
        Binary ddlContent = inputProperty.getBinary();
        CheckArg.isNotNull((Object)ddlContent, (String)"ddl content binary value");
        this.nodeMap.clear();
        String fileName = this.getNameOfDdlContent(inputProperty);
        DdlParsers parsers = this.createParsers(this.getParserList());
        InputStream stream = ddlContent.getStream();
        try {
            rootNode = parsers.parse(IoUtil.read((InputStream)stream), fileName);
        }
        catch (ParsingException e) {
            LOGGER.error((Throwable)e, (I18nResource)DdlSequencerI18n.errorParsingDdlContent, new Object[]{e.getLocalizedMessage()});
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e, (I18nResource)DdlSequencerI18n.errorSequencingDdlContent, new Object[]{e.getLocalizedMessage()});
            boolean bl = false;
            return bl;
        }
        finally {
            stream.close();
        }
        LinkedList<AstNode> queue = new LinkedList<AstNode>();
        queue.add(rootNode);
        while (queue.peek() != null) {
            AstNode astNode = (AstNode)queue.poll();
            Node sequenceNode = this.createFromAstNode(outputNode, astNode);
            this.appendNodeProperties(astNode, sequenceNode);
            for (AstNode child : astNode.getChildren()) {
                queue.add(child);
            }
        }
        return true;
    }

    private void appendNodeProperties(AstNode astNode, Node sequenceNode) throws RepositoryException {
        ValueFactory valueFactory = sequenceNode.getSession().getValueFactory();
        for (String propertyName : astNode.getPropertyNames()) {
            Object astNodePropertyValue = astNode.getProperty(propertyName);
            List<Value> valuesList = this.convertToPropertyValues(astNodePropertyValue, valueFactory);
            if (valuesList.size() == 1) {
                sequenceNode.setProperty(propertyName, valuesList.get(0));
                continue;
            }
            sequenceNode.setProperty(propertyName, valuesList.toArray(new Value[0]));
        }
    }

    private Node createFromAstNode(Node parent, AstNode astNode) throws RepositoryException {
        String relativePath = astNode.getAbsolutePath().substring(1);
        Node sequenceNode = null;
        Node parentNode = this.getNode(astNode.getParent());
        sequenceNode = parentNode == null ? parent.addNode(relativePath, astNode.getPrimaryType()) : parentNode.addNode(astNode.getJcrSafeName(), astNode.getPrimaryType());
        this.nodeMap.put(astNode, sequenceNode);
        for (String mixin : astNode.getMixins()) {
            sequenceNode.addMixin(mixin);
        }
        astNode.removeProperty("jcr:mixinTypes");
        astNode.removeProperty("jcr:primaryType");
        return sequenceNode;
    }

    private List<Value> convertToPropertyValues(Object objectValue, ValueFactory valueFactory) throws RepositoryException {
        ArrayList<Value> result = new ArrayList<Value>();
        if (objectValue instanceof Collection) {
            Collection objects = (Collection)objectValue;
            for (Object childObjectValue : objects) {
                List<Value> childValues = this.convertToPropertyValues(childObjectValue, valueFactory);
                result.addAll(childValues);
            }
        } else if (objectValue instanceof Boolean) {
            result.add(valueFactory.createValue(((Boolean)objectValue).booleanValue()));
        } else if (objectValue instanceof Integer) {
            result.add(valueFactory.createValue((long)((Integer)objectValue).intValue()));
        } else if (objectValue instanceof Long) {
            result.add(valueFactory.createValue(((Long)objectValue).longValue()));
        } else if (objectValue instanceof Double) {
            result.add(valueFactory.createValue(((Double)objectValue).doubleValue()));
        } else if (objectValue instanceof Float) {
            result.add(valueFactory.createValue((double)((Float)objectValue).floatValue()));
        } else if (objectValue instanceof AstNode) {
            result.add(valueFactory.createValue(this.getNode((AstNode)objectValue)));
        } else {
            result.add(valueFactory.createValue(objectValue.toString()));
        }
        return result;
    }

    private Node getNode(AstNode node) {
        return this.nodeMap.get(node);
    }

    private String getNameOfDdlContent(Property inputProperty) throws RepositoryException {
        Node parentNode = inputProperty.getParent();
        if ("jcr:content".equalsIgnoreCase(parentNode.getName())) {
            parentNode = parentNode.getParent();
        }
        return parentNode.getName();
    }

    static {
        ArrayList<String> grammarNames = new ArrayList<String>();
        HashMap<String, DdlParser> parsersByName = new HashMap<String, DdlParser>();
        for (DdlParser parser : DdlParsers.BUILTIN_PARSERS) {
            String grammarName = parser.getId().toLowerCase();
            grammarNames.add(grammarName);
            parsersByName.put(grammarName, parser);
        }
        DEFAULT_GRAMMARS = Collections.unmodifiableList(grammarNames);
        STANDARD_PARSERS_BY_NAME = Collections.unmodifiableMap(parsersByName);
    }
}

