/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.webdav.methods;

import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jmock.Expectations;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.modeshape.webdav.AbstractWebDAVTest;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.locking.LockedObject;
import org.modeshape.webdav.locking.ResourceLocks;
import org.modeshape.webdav.methods.DoCopy;
import org.modeshape.webdav.methods.DoDelete;
import org.springframework.mock.web.DelegatingServletInputStream;

public class DoCopyTest
extends AbstractWebDAVTest {
    @Test
    public void testDoCopyIfReadOnly() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(1.returnValue(null));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(1.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletResponse)this.one(DoCopyTest.this.mockRes)).sendError(403);
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, true);
        DoCopy doCopy = new DoCopy(this.mockStore, resLocks, doDelete, true);
        doCopy.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoCopyOfLockNullResource() throws Exception {
        String parentPath = "/lockedFolder";
        final String path = "/lockedFolder".concat("/nullFile");
        ResourceLocks resLocks = new ResourceLocks();
        resLocks.lock(this.mockTransaction, "/lockedFolder", "owner", true, 1, 10, false);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(2.returnValue(null));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(2.returnValue((Object)path));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getHeader("Destination");
                this.will(2.returnValue((Object)"/destination"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getServerName();
                this.will(2.returnValue((Object)"myServer"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getContextPath();
                this.will(2.returnValue((Object)""));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(2.returnValue((Object)"/destination"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getServletPath();
                this.will(2.returnValue((Object)"/servletPath"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(2.returnValue(null));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(2.returnValue((Object)path));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getHeader("Overwrite");
                this.will(2.returnValue((Object)"T"));
                StoredObject so = DoCopyTest.this.initLockNullStoredObject();
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, path);
                this.will(2.returnValue((Object)so));
                ((HttpServletResponse)this.one(DoCopyTest.this.mockRes)).addHeader("Allow", "OPTIONS, MKCOL, PUT, PROPFIND, LOCK, UNLOCK");
                ((HttpServletResponse)this.one(DoCopyTest.this.mockRes)).sendError(405);
            }
        });
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, false);
        DoCopy doCopy = new DoCopy(this.mockStore, resLocks, doDelete, false);
        doCopy.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoCopyIfParentIsLockedWithWrongLockToken() throws Exception {
        ResourceLocks resLocks = new ResourceLocks();
        resLocks.lock(this.mockTransaction, "/tmp/tests/destFolder", "owner", true, 1, 10, false);
        LockedObject lo = resLocks.getLockedObjectByPath(this.mockTransaction, "/tmp/tests/destFolder");
        final String wrongLockToken = "(<opaquelocktoken:" + lo.getID() + "WRONG>)";
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(3.returnValue(null));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(3.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getHeader("Destination");
                this.will(3.returnValue((Object)"/tmp/tests/destFolder/destFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getServerName();
                this.will(3.returnValue((Object)"myServer"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getContextPath();
                this.will(3.returnValue((Object)""));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(3.returnValue((Object)"/tmp/tests/destFolder/destFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getServletPath();
                this.will(3.returnValue((Object)"/servletPath"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(3.returnValue(null));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(3.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getHeader("If");
                this.will(3.returnValue((Object)wrongLockToken));
                ((HttpServletResponse)this.one(DoCopyTest.this.mockRes)).setStatus(423);
            }
        });
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, false);
        DoCopy doCopy = new DoCopy(this.mockStore, resLocks, doDelete, false);
        doCopy.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoCopyIfParentIsLockedWithRightLockToken() throws Exception {
        ResourceLocks resLocks = new ResourceLocks();
        resLocks.lock(this.mockTransaction, "/tmp/tests/destFolder", "owner", true, 1, 10, false);
        LockedObject lo = resLocks.getLockedObjectByPath(this.mockTransaction, "/tmp/tests/destFolder");
        final String rightLockToken = "(<opaquelocktoken:" + lo.getID() + ">)";
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(4.returnValue(null));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(4.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getHeader("Destination");
                this.will(4.returnValue((Object)"/tmp/tests/destFolder/destFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getServerName();
                this.will(4.returnValue((Object)"myServer"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getContextPath();
                this.will(4.returnValue((Object)""));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(4.returnValue((Object)"/tmp/tests/destFolder/destFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getServletPath();
                this.will(4.returnValue((Object)"/servletPath"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(4.returnValue(null));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(4.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getHeader("If");
                this.will(4.returnValue((Object)rightLockToken));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getHeader("Overwrite");
                this.will(4.returnValue((Object)"F"));
                StoredObject sourceFileSo = DoCopyTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(4.returnValue((Object)sourceFileSo));
                StoredObject destFileSo = null;
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                this.will(4.returnValue(destFileSo));
                ((HttpServletResponse)this.one(DoCopyTest.this.mockRes)).setStatus(201);
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(4.returnValue((Object)sourceFileSo));
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).createResource(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getResourceContent(DoCopyTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                DelegatingServletInputStream resourceStream = DoCopyTest.this.resourceRequestStream();
                this.will(4.returnValue((Object)resourceStream));
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).setResourceContent(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder/destFile", (InputStream)resourceStream, null, null);
                this.will(4.returnValue((Object)RESOURCE_LENGTH));
                destFileSo = DoCopyTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                this.will(4.returnValue((Object)destFileSo));
            }
        });
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, false);
        DoCopy doCopy = new DoCopy(this.mockStore, resLocks, doDelete, false);
        doCopy.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoCopyIfDestinationPathInvalid() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(5.returnValue(null));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(5.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getHeader("Destination");
                this.will(5.returnValue(null));
                ((HttpServletResponse)this.one(DoCopyTest.this.mockRes)).sendError(400);
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, false);
        DoCopy doCopy = new DoCopy(this.mockStore, resLocks, doDelete, false);
        doCopy.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoCopyIfSourceEqualsDestination() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(6.returnValue(null));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(6.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getHeader("Destination");
                this.will(6.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getServerName();
                this.will(6.returnValue((Object)"serverName"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getContextPath();
                this.will(6.returnValue((Object)""));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(6.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getServletPath();
                this.will(6.returnValue((Object)"/servletPath"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(6.returnValue(null));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(6.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletResponse)this.one(DoCopyTest.this.mockRes)).sendError(403);
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, false);
        DoCopy doCopy = new DoCopy(this.mockStore, resLocks, doDelete, false);
        doCopy.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoCopyFolderIfNoLocks() throws Exception {
        final String[] sourceChildren = new String[]{"sourceFile"};
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(7.returnValue(null));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(7.returnValue((Object)"/tmp/tests/sourceFolder"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getHeader("Destination");
                this.will(7.returnValue((Object)"/tmp/tests/destFolder"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getServerName();
                this.will(7.returnValue((Object)"serverName"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getContextPath();
                this.will(7.returnValue((Object)""));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(7.returnValue((Object)"/tmp/tests/destFolder"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getServletPath();
                this.will(7.returnValue((Object)"/servletPath"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(7.returnValue(null));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(7.returnValue((Object)"/tmp/tests/sourceFolder"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getHeader("Overwrite");
                this.will(7.returnValue((Object)"F"));
                StoredObject sourceCollectionSo = DoCopyTest.this.initFolderStoredObject();
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/sourceFolder");
                this.will(7.returnValue((Object)sourceCollectionSo));
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder");
                this.will(7.returnValue(null));
                ((HttpServletResponse)this.one(DoCopyTest.this.mockRes)).setStatus(201);
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/sourceFolder");
                this.will(7.returnValue((Object)sourceCollectionSo));
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).createFolder(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder");
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getHeader("Depth");
                this.will(7.returnValue((Object)"-1"));
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getChildrenNames(DoCopyTest.this.mockTransaction, "/tmp/tests/sourceFolder");
                this.will(7.returnValue((Object)sourceChildren));
                StoredObject sourceFileSo = DoCopyTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(7.returnValue((Object)sourceFileSo));
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).createResource(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder/sourceFile");
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getResourceContent(DoCopyTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                DelegatingServletInputStream stream = DoCopyTest.this.resourceRequestStream();
                this.will(7.returnValue((Object)stream));
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).setResourceContent(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder/sourceFile", (InputStream)stream, null, null);
                StoredObject destFileSo = DoCopyTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder/sourceFile");
                this.will(7.returnValue((Object)destFileSo));
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, false);
        DoCopy doCopy = new DoCopy(this.mockStore, resLocks, doDelete, false);
        doCopy.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoCopyIfSourceDoesntExist() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(8.returnValue(null));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(8.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getHeader("Destination");
                this.will(8.returnValue((Object)"/tmp/tests/destFolder/destFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getServerName();
                this.will(8.returnValue((Object)"serverName"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getContextPath();
                this.will(8.returnValue((Object)""));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(8.returnValue((Object)"/tmp/tests/destFolder/destFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getServletPath();
                this.will(8.returnValue((Object)"/servletPath"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(8.returnValue(null));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(8.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getHeader("Overwrite");
                this.will(8.returnValue((Object)"F"));
                Object notExistSo = null;
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(8.returnValue(notExistSo));
                ((HttpServletResponse)this.one(DoCopyTest.this.mockRes)).sendError(404);
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, false);
        DoCopy doCopy = new DoCopy(this.mockStore, resLocks, doDelete, false);
        doCopy.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoCopyIfDestinationAlreadyExistsAndOverwriteTrue() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(9.returnValue(null));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(9.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                StoredObject sourceSo = DoCopyTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(9.returnValue((Object)sourceSo));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getHeader("Destination");
                this.will(9.returnValue((Object)"/tmp/tests/destFolder/destFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getServerName();
                this.will(9.returnValue((Object)"serverName"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getContextPath();
                this.will(9.returnValue((Object)""));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(9.returnValue((Object)"/folder/destFolder"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getServletPath();
                this.will(9.returnValue((Object)"/servletPath"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(9.returnValue(null));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(9.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                StoredObject existingDestSo = DoCopyTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                this.will(9.returnValue((Object)existingDestSo));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getHeader("Overwrite");
                this.will(9.returnValue((Object)"T"));
                ((HttpServletResponse)this.one(DoCopyTest.this.mockRes)).setStatus(204);
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                this.will(9.returnValue((Object)existingDestSo));
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).removeObject(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(9.returnValue((Object)sourceSo));
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).createResource(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getResourceContent(DoCopyTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                DelegatingServletInputStream resourceStream = DoCopyTest.this.resourceRequestStream();
                this.will(9.returnValue((Object)resourceStream));
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).setResourceContent(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder/destFile", (InputStream)resourceStream, null, null);
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                this.will(9.returnValue((Object)existingDestSo));
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, false);
        DoCopy doCopy = new DoCopy(this.mockStore, resLocks, doDelete, false);
        doCopy.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoCopyIfDestinationAlreadyExistsAndOverwriteFalse() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(10.returnValue(null));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(10.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                StoredObject sourceSo = DoCopyTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(10.returnValue((Object)sourceSo));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getHeader("Destination");
                this.will(10.returnValue((Object)"serverName".concat("/tmp/tests/destFolder/destFile")));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getServerName();
                this.will(10.returnValue((Object)"serverName"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getContextPath();
                this.will(10.returnValue((Object)""));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(10.returnValue((Object)"/tmp/tests/destFolder/destFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getServletPath();
                this.will(10.returnValue((Object)"/servletPath"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(10.returnValue(null));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(10.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                StoredObject existingDestSo = DoCopyTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                this.will(10.returnValue((Object)existingDestSo));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getHeader("Overwrite");
                this.will(10.returnValue((Object)"F"));
                ((HttpServletResponse)this.one(DoCopyTest.this.mockRes)).sendError(412);
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, false);
        DoCopy doCopy = new DoCopy(this.mockStore, resLocks, doDelete, false);
        doCopy.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoCopyIfOverwriteTrue() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(11.returnValue(null));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(11.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                StoredObject sourceSo = DoCopyTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(11.returnValue((Object)sourceSo));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getHeader("Destination");
                this.will(11.returnValue((Object)"http://destination:80".concat("/tmp/tests/destFolder/destFile")));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getContextPath();
                this.will(11.returnValue((Object)"http://destination:80"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(11.returnValue((Object)"/tmp/tests/destFolder"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getServletPath();
                this.will(11.returnValue((Object)"http://destination:80"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(11.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.path_info");
                this.will(11.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getHeader("Overwrite");
                this.will(11.returnValue((Object)"T"));
                StoredObject destFileSo = DoCopyTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                this.will(11.returnValue((Object)destFileSo));
                ((HttpServletResponse)this.one(DoCopyTest.this.mockRes)).setStatus(204);
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                this.will(11.returnValue((Object)destFileSo));
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).removeObject(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(11.returnValue((Object)sourceSo));
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).createResource(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getResourceContent(DoCopyTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                DelegatingServletInputStream resourceStream = DoCopyTest.this.resourceRequestStream();
                this.will(11.returnValue((Object)resourceStream));
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).setResourceContent(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder/destFile", (InputStream)resourceStream, null, null);
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder/destFile");
                this.will(11.returnValue((Object)destFileSo));
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, false);
        DoCopy doCopy = new DoCopy(this.mockStore, resLocks, doDelete, false);
        doCopy.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }

    @Test
    public void testDoCopyIfOverwriteFalse() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(12.returnValue(null));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(12.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                StoredObject sourceSo = DoCopyTest.this.initFileStoredObject(RESOURCE_CONTENT);
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/sourceFolder/sourceFile");
                this.will(12.returnValue((Object)sourceSo));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getHeader("Destination");
                this.will(12.returnValue((Object)"http://destination:80".concat("/tmp/tests/destFolder")));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getContextPath();
                this.will(12.returnValue((Object)"http://destination:80"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getPathInfo();
                this.will(12.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getServletPath();
                this.will(12.returnValue((Object)"http://destination:80"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.request_uri");
                this.will(12.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getAttribute("javax.servlet.include.path_info");
                this.will(12.returnValue((Object)"/tmp/tests/sourceFolder/sourceFile"));
                ((HttpServletRequest)this.one(DoCopyTest.this.mockReq)).getHeader("Overwrite");
                this.will(12.returnValue((Object)"F"));
                StoredObject existingDestSo = DoCopyTest.this.initFolderStoredObject();
                ((IWebdavStore)this.one(DoCopyTest.this.mockStore)).getStoredObject(DoCopyTest.this.mockTransaction, "/tmp/tests/destFolder");
                this.will(12.returnValue((Object)existingDestSo));
                ((HttpServletResponse)this.one(DoCopyTest.this.mockRes)).sendError(412);
            }
        });
        ResourceLocks resLocks = new ResourceLocks();
        DoDelete doDelete = new DoDelete(this.mockStore, resLocks, false);
        DoCopy doCopy = new DoCopy(this.mockStore, resLocks, doDelete, false);
        doCopy.execute(this.mockTransaction, this.mockReq, this.mockRes);
        this.mockery.assertIsSatisfied();
    }
}

