/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.bus;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.bus.BusI18n;
import org.modeshape.jcr.bus.ChangeBus;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.clustering.ChannelProvider;

@ThreadSafe
public final class ClusteredRepositoryChangeBus
implements ChangeBus {
    protected static final Logger LOGGER = Logger.getLogger(ClusteredRepositoryChangeBus.class);
    protected final ChangeBus delegate;
    private final String processId;
    private final Listener listener = new Listener();
    private final Receiver receiver = new Receiver();
    protected final AtomicBoolean isOpen = new AtomicBoolean(false);
    protected final AtomicBoolean multipleAddressesInCluster = new AtomicBoolean(false);
    protected final RepositoryConfiguration.Clustering clusteringConfiguration;
    private Channel channel;

    public ClusteredRepositoryChangeBus(RepositoryConfiguration.Clustering clusteringConfiguration, ChangeBus delegate, String processId) {
        CheckArg.isNotNull((Object)clusteringConfiguration, (String)"clusteringConfiguration");
        CheckArg.isNotNull((Object)delegate, (String)"delegate");
        this.clusteringConfiguration = clusteringConfiguration;
        this.processId = processId;
        assert (clusteringConfiguration.isEnabled());
        this.delegate = delegate;
    }

    @Override
    public synchronized void start() throws Exception {
        String clusterName = this.clusteringConfiguration.getClusterName();
        if (clusterName == null) {
            throw new IllegalStateException(BusI18n.clusterNameRequired.text(new Object[0]));
        }
        if (this.channel != null) {
            this.channel.removeChannelListener((ChannelListener)this.listener);
            this.channel.setReceiver(null);
        }
        this.channel = this.newChannel();
        this.channel.addChannelListener((ChannelListener)this.listener);
        this.channel.setReceiver((org.jgroups.Receiver)this.receiver);
        this.channel.connect(clusterName);
        this.delegate.start();
    }

    private Channel newChannel() throws Exception {
        Channel channel = this.clusteringConfiguration.getChannel();
        if (channel != null) {
            return channel;
        }
        String lookupClassName = this.clusteringConfiguration.getChannelProviderClassName();
        assert (lookupClassName != null);
        Class<?> lookupClass = Class.forName(lookupClassName);
        if (!ChannelProvider.class.isAssignableFrom(lookupClass)) {
            throw new IllegalArgumentException("Invalid channel lookup class configured. Expected a subclass of org.modeshape.jcr.clustering.ChannelProvider. Actual class:" + lookupClass);
        }
        return ((ChannelProvider)lookupClass.newInstance()).getChannel(this.clusteringConfiguration);
    }

    @Override
    public boolean hasObservers() {
        return this.delegate.hasObservers();
    }

    public boolean isStarted() {
        return this.channel != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void shutdown() {
        if (this.channel != null) {
            this.isOpen.set(false);
            try {
                this.channel.removeChannelListener((ChannelListener)this.listener);
                this.channel.setReceiver(null);
                this.channel.close();
            }
            finally {
                this.channel = null;
                this.delegate.shutdown();
            }
        }
    }

    @Override
    public void notify(ChangeSet changeSet) {
        if (changeSet == null) {
            return;
        }
        if (!this.isOpen.get()) {
            return;
        }
        if (!this.multipleAddressesInCluster.get()) {
            if (this.hasObservers()) {
                this.delegate.notify(changeSet);
                this.logReceivedOperation(changeSet);
            }
            return;
        }
        try {
            this.logSendOperation(changeSet);
            byte[] data = this.serialize(changeSet);
            Message message = new Message(null, null, data);
            this.channel.send(message);
        }
        catch (IllegalStateException e) {
            LOGGER.warn((I18nResource)BusI18n.unableToNotifyChanges, new Object[]{this.clusteringConfiguration.getClusterName(), changeSet.size(), changeSet.getWorkspaceName(), changeSet.getUserId(), changeSet.getProcessKey(), changeSet.getTimestamp()});
        }
        catch (Exception e) {
            String msg = BusI18n.errorSerializingChanges.text(new Object[]{this.clusteringConfiguration.getClusterName(), changeSet.size(), changeSet.getWorkspaceName(), changeSet.getUserId(), changeSet.getProcessKey(), changeSet.getTimestamp(), changeSet});
            throw new SystemFailureException(msg, (Throwable)e);
        }
    }

    protected final void logSendOperation(ChangeSet changeSet) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Process {0} sending to cluster '{1}' {2} changes on workspace {3} made by {4} from process '{5}' at {6}", new Object[]{this.processId, this.clusteringConfiguration.getClusterName(), changeSet.size(), changeSet.getWorkspaceName(), changeSet.getUserData(), changeSet.getProcessKey(), changeSet.getTimestamp()});
        }
    }

    protected final void logReceivedOperation(ChangeSet changeSet) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Process {0} received on cluster '{1}' {2} changes on workspace {3} made by {4} from process '{5}' at {6}", new Object[]{this.processId, this.clusteringConfiguration.getClusterName(), changeSet.size(), changeSet.getWorkspaceName(), changeSet.getUserId(), changeSet.getProcessKey(), changeSet.getTimestamp()});
        }
    }

    @Override
    public boolean register(ChangeSetListener observer) {
        return this.delegate.register(observer);
    }

    @Override
    public boolean unregister(ChangeSetListener observer) {
        return this.delegate.unregister(observer);
    }

    protected byte[] serialize(ChangeSet changes) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ObjectOutputStream stream = new ObjectOutputStream(output);
        stream.writeObject(changes);
        stream.close();
        return output.toByteArray();
    }

    protected ChangeSet deserialize(byte[] data) throws Exception {
        ObjectInputStreamWithClassLoader input = new ObjectInputStreamWithClassLoader(new ByteArrayInputStream(data), this.getClass().getClassLoader());
        ChangeSet toReturn = (ChangeSet)input.readObject();
        input.close();
        return toReturn;
    }

    protected final class ObjectInputStreamWithClassLoader
    extends ObjectInputStream {
        private final ClassLoader cl;

        public ObjectInputStreamWithClassLoader(InputStream in, ClassLoader cl) throws IOException {
            super(in);
            this.cl = cl;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (this.cl == null) {
                return super.resolveClass(desc);
            }
            try {
                return Class.forName(desc.getName(), false, this.cl);
            }
            catch (ClassNotFoundException ex) {
                return super.resolveClass(desc);
            }
        }
    }

    protected final class Listener
    implements ChannelListener {
        protected Listener() {
        }

        public void channelClosed(Channel channel) {
            ClusteredRepositoryChangeBus.this.isOpen.set(false);
        }

        public void channelConnected(Channel channel) {
            ClusteredRepositoryChangeBus.this.isOpen.set(true);
        }

        public void channelDisconnected(Channel channel) {
            ClusteredRepositoryChangeBus.this.isOpen.set(false);
        }
    }

    protected final class Receiver
    extends ReceiverAdapter {
        protected Receiver() {
        }

        public void block() {
            ClusteredRepositoryChangeBus.this.isOpen.set(false);
        }

        public void receive(Message message) {
            if (!ClusteredRepositoryChangeBus.this.hasObservers()) {
                return;
            }
            try {
                ChangeSet changes = ClusteredRepositoryChangeBus.this.deserialize(message.getBuffer());
                ClusteredRepositoryChangeBus.this.delegate.notify(changes);
                ClusteredRepositoryChangeBus.this.logReceivedOperation(changes);
            }
            catch (Exception e) {
                String msg = BusI18n.errorDeserializingChanges.text(new Object[]{ClusteredRepositoryChangeBus.this.clusteringConfiguration.getClusterName()});
                throw new SystemFailureException(msg, (Throwable)e);
            }
        }

        public void suspect(Address suspectedMbr) {
            LOGGER.error((I18nResource)BusI18n.memberOfClusterIsSuspect, new Object[]{ClusteredRepositoryChangeBus.this.clusteringConfiguration.getClusterName(), suspectedMbr});
        }

        public void viewAccepted(View newView) {
            LOGGER.trace("Members of '{0}' cluster have changed: {1}", new Object[]{ClusteredRepositoryChangeBus.this.clusteringConfiguration.getClusterName(), newView});
            if (newView.getMembers().size() > 1) {
                if (ClusteredRepositoryChangeBus.this.multipleAddressesInCluster.compareAndSet(false, true)) {
                    LOGGER.debug("There are now multiple members of cluster '{0}'; changes will be propagated throughout the cluster", new Object[]{ClusteredRepositoryChangeBus.this.clusteringConfiguration.getClusterName()});
                }
            } else if (ClusteredRepositoryChangeBus.this.multipleAddressesInCluster.compareAndSet(true, false)) {
                LOGGER.debug("There is only one member of cluster '{0}'; changes will be propagated locally only", new Object[]{ClusteredRepositoryChangeBus.this.clusteringConfiguration.getClusterName()});
            }
        }
    }
}

