/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.SchematicEntry;
import org.infinispan.schematic.document.Document;
import org.infinispan.schematic.document.EditableDocument;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.collection.Collections;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.ConfigurationException;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.ModeShape;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.RepositoryConfiguration;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.bus.ChangeBus;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.SessionEnvironment;
import org.modeshape.jcr.cache.WorkspaceNotFoundException;
import org.modeshape.jcr.cache.change.AbstractNodeChange;
import org.modeshape.jcr.cache.change.AbstractPropertyChange;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.change.NodeAdded;
import org.modeshape.jcr.cache.change.NodeChanged;
import org.modeshape.jcr.cache.change.NodeMoved;
import org.modeshape.jcr.cache.change.NodeRemoved;
import org.modeshape.jcr.cache.change.NodeRenamed;
import org.modeshape.jcr.cache.change.NodeReordered;
import org.modeshape.jcr.cache.change.Observable;
import org.modeshape.jcr.cache.change.RecordingChanges;
import org.modeshape.jcr.cache.change.WorkspaceAdded;
import org.modeshape.jcr.cache.change.WorkspaceRemoved;
import org.modeshape.jcr.cache.document.DocumentStore;
import org.modeshape.jcr.cache.document.DocumentTranslator;
import org.modeshape.jcr.cache.document.LocalDocumentStore;
import org.modeshape.jcr.cache.document.ReadOnlySessionCache;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.cache.document.WritableSessionCache;
import org.modeshape.jcr.txn.Transactions;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyFactory;
import org.modeshape.jcr.value.StringFactory;

public class RepositoryCache
implements Observable {
    private static final long MAX_NUMBER_OF_MINUTES_TO_WAIT_FOR_REPOSITORY_INITIALIZATION = 10L;
    private static final Logger LOGGER = Logger.getLogger(RepositoryCache.class);
    private static final String SYSTEM_METADATA_IDENTIFIER = "jcr:system/mode:metadata";
    private static final String REPOSITORY_INFO_KEY = "repository:info";
    private static final String REPOSITORY_NAME_FIELD_NAME = "repositoryName";
    private static final String REPOSITORY_KEY_FIELD_NAME = "repositoryKey";
    private static final String REPOSITORY_SOURCE_NAME_FIELD_NAME = "sourceName";
    private static final String REPOSITORY_SOURCE_KEY_FIELD_NAME = "sourceKey";
    private static final String REPOSITORY_CREATED_AT_FIELD_NAME = "createdAt";
    private static final String REPOSITORY_INITIALIZED_AT_FIELD_NAME = "intializedAt";
    private static final String REPOSITORY_INITIALIZER_FIELD_NAME = "intializer";
    private static final String REPOSITORY_CREATED_WITH_MODESHAPE_VERSION_FIELD_NAME = "createdWithModeShapeVersion";
    private final ExecutionContext context;
    private final RepositoryConfiguration configuration;
    private final DocumentStore documentStore;
    private final DocumentTranslator translator;
    private final ConcurrentHashMap<String, WorkspaceCache> workspaceCachesByName;
    private final AtomicLong minimumStringLengthForBinaryStorage = new AtomicLong();
    private final String name;
    private final String repoKey;
    private final String sourceKey;
    private final String rootNodeId;
    private final ChangeBus changeBus;
    private final NodeKey systemMetadataKey;
    private final NodeKey systemKey;
    private final Set<String> workspaceNames;
    private final String systemWorkspaceName;
    protected final Logger logger;
    private final SessionEnvironment sessionContext;
    private final String processKey;
    private final CacheContainer workspaceCacheManager;
    private volatile boolean initializingRepository = false;
    public static final ContentInitializer NO_OP_INITIALIZER = new ContentInitializer(){

        @Override
        public void initialize(SessionCache session, MutableCachedNode parent) {
        }
    };

    public RepositoryCache(ExecutionContext context, DocumentStore documentStore, RepositoryConfiguration configuration, ContentInitializer initializer, SessionEnvironment sessionContext, ChangeBus changeBus, CacheContainer workspaceCacheContainer) {
        this.context = context;
        this.configuration = configuration;
        this.documentStore = documentStore;
        this.minimumStringLengthForBinaryStorage.set(configuration.getBinaryStorage().getMinimumStringSize());
        this.translator = new DocumentTranslator(this.context, this.documentStore, this.minimumStringLengthForBinaryStorage.get());
        this.sessionContext = sessionContext;
        this.processKey = context.getProcessId();
        this.workspaceCacheManager = workspaceCacheContainer;
        this.logger = Logger.getLogger(this.getClass());
        this.rootNodeId = "/";
        this.name = configuration.getName();
        this.workspaceCachesByName = new ConcurrentHashMap();
        this.workspaceNames = new CopyOnWriteArraySet<String>(configuration.getAllWorkspaceNames());
        SchematicEntry repositoryInfo = this.documentStore.localStore().get(REPOSITORY_INFO_KEY);
        if (repositoryInfo == null) {
            String initializerId = UUID.randomUUID().toString();
            this.repoKey = NodeKey.keyForSourceName(this.name);
            this.sourceKey = NodeKey.keyForSourceName(configuration.getStoreName());
            DateTime now = context.getValueFactories().getDateFactory().create();
            EditableDocument doc = Schematic.newDocument();
            doc.setString(REPOSITORY_NAME_FIELD_NAME, this.name);
            doc.setString(REPOSITORY_KEY_FIELD_NAME, this.repoKey);
            doc.setString(REPOSITORY_SOURCE_NAME_FIELD_NAME, configuration.getStoreName());
            doc.setString(REPOSITORY_SOURCE_KEY_FIELD_NAME, this.sourceKey);
            doc.setDate(REPOSITORY_CREATED_AT_FIELD_NAME, now.toDate());
            doc.setString(REPOSITORY_INITIALIZER_FIELD_NAME, initializerId);
            doc.setString(REPOSITORY_CREATED_WITH_MODESHAPE_VERSION_FIELD_NAME, ModeShape.getVersion());
            this.documentStore.localStore().putIfAbsent(REPOSITORY_INFO_KEY, (Document)doc);
            repositoryInfo = this.documentStore.get(REPOSITORY_INFO_KEY);
            if (repositoryInfo.getContentAsDocument().getString(REPOSITORY_INITIALIZER_FIELD_NAME).equals(initializerId)) {
                this.initializingRepository = true;
                LOGGER.debug("Initializing the '{0}' repository", new Object[]{this.name});
            }
        } else {
            Document info = repositoryInfo.getContentAsDocument();
            String repoName = info.getString(REPOSITORY_NAME_FIELD_NAME, this.name);
            String sourceName = info.getString(REPOSITORY_SOURCE_NAME_FIELD_NAME, configuration.getStoreName());
            this.repoKey = info.getString(REPOSITORY_KEY_FIELD_NAME, NodeKey.keyForSourceName(repoName));
            this.sourceKey = info.getString(REPOSITORY_SOURCE_KEY_FIELD_NAME, NodeKey.keyForSourceName(sourceName));
        }
        if (!this.initializingRepository) {
            long numMinutesToWait = 10L;
            long startTime = System.currentTimeMillis();
            long quitTime = startTime + TimeUnit.MILLISECONDS.convert(10L, TimeUnit.MINUTES);
            boolean initialized = false;
            while (System.currentTimeMillis() < quitTime) {
                LOGGER.debug("Waiting for repository '{0}' to be fully initialized by another process in the cluster", new Object[]{this.name});
                Document info = repositoryInfo.getContentAsDocument();
                if (info.get(REPOSITORY_INITIALIZED_AT_FIELD_NAME) != null) {
                    initialized = true;
                    break;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    break;
                }
            }
            if (!initialized) {
                LOGGER.error((I18nResource)JcrI18n.repositoryWasNeverInitializedAfterMinutes, new Object[]{this.name, 10L});
                String msg = JcrI18n.repositoryWasNeverInitializedAfterMinutes.text(new Object[]{this.name, 10L});
                throw new SystemFailureException(msg);
            }
            LOGGER.debug("Found repository '{0}' to be fully initialized", new Object[]{this.name});
        }
        this.systemWorkspaceName = "system";
        String systemWorkspaceKey = NodeKey.keyForWorkspaceName(this.systemWorkspaceName);
        this.systemMetadataKey = new NodeKey(this.sourceKey, systemWorkspaceKey, SYSTEM_METADATA_IDENTIFIER);
        this.refreshWorkspaces(false);
        this.changeBus = changeBus;
        this.changeBus.register(new LocalChangeListener());
        SessionCache systemSession = this.createSession(context, this.systemWorkspaceName, false);
        NodeKey systemRootKey = systemSession.getRootKey();
        CachedNode systemRoot = systemSession.getNode(systemRootKey);
        this.logger.debug("System root: {0}", new Object[]{systemRoot});
        ChildReference systemRef = systemRoot.getChildReferences(systemSession).getChild(JcrLexicon.SYSTEM);
        this.logger.debug("jcr:system child reference: {0}", new Object[]{systemRef});
        CachedNode systemNode = systemRef != null ? systemSession.getNode(systemRef) : null;
        this.logger.debug("System node: {0}", new Object[]{systemNode});
        if (systemRef == null || systemNode == null) {
            this.logger.debug("Creating the '{0}' workspace in repository '{1}'", new Object[]{this.systemWorkspaceName, this.name});
            MutableCachedNode root = systemSession.mutable(systemRootKey);
            if (initializer == null) {
                initializer = NO_OP_INITIALIZER;
            }
            initializer.initialize(systemSession, root);
            systemSession.save();
            this.refreshWorkspace(this.systemWorkspaceName);
            systemSession = this.createSession(context, this.systemWorkspaceName, false);
            systemRoot = systemSession.getNode(systemRootKey);
            systemRef = systemRoot.getChildReferences(systemSession).getChild(JcrLexicon.SYSTEM);
            if (systemRef == null) {
                throw new SystemFailureException(JcrI18n.unableToInitializeSystemWorkspace.text(new Object[]{this.name}));
            }
        } else {
            this.logger.debug("Found existing '{0}' workspace in repository '{1}'", new Object[]{this.systemWorkspaceName, this.name});
        }
        this.systemKey = systemRef.getKey();
        this.documentStore.setLocalSourceKey(this.sourceKey);
    }

    public final void rollbackRepositoryInfo() {
        Document repoInfoDoc;
        SchematicEntry repositoryInfoEntry = this.documentStore.localStore().get(REPOSITORY_INFO_KEY);
        if (repositoryInfoEntry != null && !(repoInfoDoc = repositoryInfoEntry.getContentAsDocument()).containsField(REPOSITORY_INITIALIZED_AT_FIELD_NAME)) {
            this.documentStore.localStore().remove(REPOSITORY_INFO_KEY);
        }
    }

    protected final SessionEnvironment sessionContext() {
        return this.sessionContext;
    }

    protected final String processKey() {
        return this.processKey;
    }

    protected Name name(String name) {
        return (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    public final boolean isInitializingRepository() {
        return this.initializingRepository;
    }

    protected final DocumentStore documentStore() {
        return this.documentStore;
    }

    protected final ExecutionContext context() {
        return this.context;
    }

    public void completeInitialization() {
        if (this.initializingRepository) {
            LOGGER.debug("Marking repository '{0}' as fully initialized", new Object[]{this.name});
            this.runInTransaction(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    LocalDocumentStore store = RepositoryCache.this.documentStore().localStore();
                    store.prepareDocumentsForUpdate(Collections.unmodifiableSet((Object[])new String[]{RepositoryCache.REPOSITORY_INFO_KEY}));
                    SchematicEntry repositoryInfo = store.get(RepositoryCache.REPOSITORY_INFO_KEY);
                    EditableDocument editor = repositoryInfo.editDocumentContent();
                    if (editor.get(RepositoryCache.REPOSITORY_INITIALIZED_AT_FIELD_NAME) == null) {
                        DateTime now = RepositoryCache.this.context().getValueFactories().getDateFactory().create();
                        editor.setDate(RepositoryCache.REPOSITORY_INITIALIZED_AT_FIELD_NAME, now.toDate());
                    }
                    return null;
                }
            });
            LOGGER.debug("Repository '{0}' is fully initialized", new Object[]{this.name});
        }
    }

    private <V> V runInTransaction(Callable<V> operation) {
        Transactions txns = this.sessionContext.getTransactions();
        try {
            Transactions.Transaction txn = txns.begin();
            try {
                V result = operation.call();
                txn.commit();
                return result;
            }
            catch (RuntimeException re) {
                txn.rollback();
                throw re;
            }
            catch (Exception e) {
                txn.rollback();
                throw new RuntimeException(e);
            }
        }
        catch (IllegalStateException err) {
            throw new SystemFailureException((Throwable)err);
        }
        catch (SystemException err) {
            throw new SystemFailureException((Throwable)err);
        }
        catch (NotSupportedException e) {
            this.logger.debug((Throwable)e, "unexpected exception while committing transaction", new Object[0]);
            return null;
        }
    }

    public void startShutdown() {
        for (Map.Entry<String, WorkspaceCache> entry : this.workspaceCachesByName.entrySet()) {
            entry.getValue().signalClosing();
        }
    }

    public void completeShutdown() {
        for (Map.Entry<String, WorkspaceCache> entry : this.workspaceCachesByName.entrySet()) {
            EmbeddedCacheManager embeddedCacheManager;
            String workspaceName = entry.getKey();
            entry.getValue().signalClosed();
            if (!(this.workspaceCacheManager instanceof EmbeddedCacheManager) || !(embeddedCacheManager = (EmbeddedCacheManager)this.workspaceCacheManager).getStatus().equals((Object)ComponentStatus.RUNNING)) continue;
            ((EmbeddedCacheManager)this.workspaceCacheManager).removeCache(this.cacheNameForWorkspace(workspaceName));
        }
    }

    public NodeKey getRepositoryMetadataDocumentKey() {
        return this.systemMetadataKey;
    }

    @Override
    public boolean register(ChangeSetListener observer) {
        return this.changeBus.register(observer);
    }

    @Override
    public boolean unregister(ChangeSetListener observer) {
        return this.changeBus.unregister(observer);
    }

    public void setLargeStringLength(long sizeInBytes) {
        assert (sizeInBytes > -1L);
        this.minimumStringLengthForBinaryStorage.set(sizeInBytes);
        for (WorkspaceCache workspaceCache : this.workspaceCachesByName.values()) {
            assert (workspaceCache != null);
            workspaceCache.setMinimumStringLengthForBinaryStorage(this.minimumStringLengthForBinaryStorage.get());
        }
    }

    public long largeValueSizeInBytes() {
        return this.minimumStringLengthForBinaryStorage.get();
    }

    protected void refreshWorkspaces(boolean update) {
        DocumentTranslator translator = new DocumentTranslator(this.context, this.documentStore, this.minimumStringLengthForBinaryStorage.get());
        HashSet<String> workspaceNames = new HashSet<String>(this.workspaceNames);
        String systemMetadataKeyStr = this.systemMetadataKey.toString();
        SchematicEntry entry = this.documentStore.get(systemMetadataKeyStr);
        if (entry == null) {
            PropertyFactory propFactory = this.context.getPropertyFactory();
            EditableDocument doc = Schematic.newDocument();
            translator.setKey(doc, this.systemMetadataKey);
            translator.setProperty(doc, propFactory.create(this.name("workspaces"), workspaceNames), null);
            entry = this.documentStore.localStore().putIfAbsent(systemMetadataKeyStr, (Document)doc);
        }
        if (entry != null) {
            Document doc = entry.getContentAsDocument();
            Property prop = translator.getProperty(doc, this.name("workspaces"));
            if (prop != null && !prop.isEmpty() && !update) {
                workspaceNames.clear();
                StringFactory strings = this.context.getValueFactories().getStringFactory();
                for (Object value : prop) {
                    String workspaceName = (String)strings.create(value);
                    workspaceNames.add(workspaceName);
                }
                this.workspaceNames.addAll(workspaceNames);
                this.workspaceNames.retainAll(workspaceNames);
            } else {
                try {
                    Transactions.Transaction txn = this.sessionContext.getTransactions().begin();
                    EditableDocument editable = entry.editDocumentContent();
                    PropertyFactory propFactory = this.context.getPropertyFactory();
                    translator.setProperty(editable, propFactory.create(this.name("workspaces"), workspaceNames), null);
                    this.documentStore.localStore().replace(systemMetadataKeyStr, (Document)editable);
                    txn.commit();
                }
                catch (Exception err) {
                    throw new SystemFailureException(JcrI18n.errorUpdatingWorkspaceNames.text(new Object[]{this.name, err.getMessage()}));
                }
            }
        }
    }

    public void runOneTimeSystemInitializationOperation(Callable<Void> initOperation) throws Exception {
        if (!this.isInitializingRepository()) {
            return;
        }
        SessionCache systemSession = this.createSession(this.context, this.systemWorkspaceName, false);
        MutableCachedNode systemNode = this.getSystemNode(systemSession);
        ChildReference repositoryReference = systemNode.getChildReferences(systemSession).getChild(ModeShapeLexicon.REPOSITORY);
        if (repositoryReference != null) {
            return;
        }
        initOperation.call();
        Property primaryType = this.context.getPropertyFactory().create(JcrLexicon.PRIMARY_TYPE, ModeShapeLexicon.REPOSITORY);
        systemNode.createChild(systemSession, systemNode.getKey().withId("mode:repository"), ModeShapeLexicon.REPOSITORY, primaryType, new Property[0]);
        systemSession.save();
    }

    private MutableCachedNode getSystemNode(SessionCache systemSession) {
        NodeKey systemRootKey = systemSession.getRootKey();
        CachedNode systemRoot = systemSession.getNode(systemRootKey);
        ChildReference systemRef = systemRoot.getChildReferences(systemSession).getChild(JcrLexicon.SYSTEM);
        return systemSession.mutable(systemRef.getKey());
    }

    public final String getKey() {
        return this.repoKey;
    }

    public final NodeKey getSystemKey() {
        return this.systemKey;
    }

    public final String getSystemWorkspaceKey() {
        return NodeKey.keyForWorkspaceName(this.getSystemWorkspaceName());
    }

    public final String getSystemWorkspaceName() {
        return this.systemWorkspaceName;
    }

    public final String getName() {
        return this.name;
    }

    public final Set<String> getWorkspaceNames() {
        return Collections.unmodifiableSet(this.workspaceNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WorkspaceCache workspace(final String name) {
        WorkspaceCache workspaceCache = this.workspaceCachesByName.get(name);
        if (workspaceCache != null) {
            return workspaceCache;
        }
        if (!this.workspaceNames.contains(name) && !this.systemWorkspaceName.equals(name)) {
            throw new WorkspaceNotFoundException(name);
        }
        RepositoryCache repositoryCache = this;
        synchronized (repositoryCache) {
            if (!this.workspaceCachesByName.containsKey(name)) {
                WorkspaceCache initializedWsCache = this.runInTransaction(new Callable<WorkspaceCache>(){

                    @Override
                    public WorkspaceCache call() throws Exception {
                        Cache<NodeKey, CachedNode> nodeCache = RepositoryCache.this.cacheForWorkspace(name);
                        ExecutionContext context = RepositoryCache.this.context();
                        String workspaceKey = NodeKey.keyForWorkspaceName(name);
                        NodeKey rootKey = new NodeKey(RepositoryCache.this.sourceKey, workspaceKey, RepositoryCache.this.rootNodeId);
                        EditableDocument rootDoc = Schematic.newDocument();
                        DocumentTranslator trans = new DocumentTranslator(context, RepositoryCache.this.documentStore, Long.MAX_VALUE);
                        trans.setProperty(rootDoc, context.getPropertyFactory().create(JcrLexicon.PRIMARY_TYPE, ModeShapeLexicon.ROOT), null);
                        trans.setProperty(rootDoc, context.getPropertyFactory().create(JcrLexicon.UUID, rootKey.toString()), null);
                        WorkspaceCache workspaceCache = new WorkspaceCache(context, RepositoryCache.this.getKey(), name, RepositoryCache.this.documentStore, RepositoryCache.this.translator, rootKey, (ConcurrentMap<NodeKey, CachedNode>)nodeCache, RepositoryCache.this.changeBus);
                        if (RepositoryCache.this.documentStore.localStore().putIfAbsent(rootKey.toString(), (Document)rootDoc) == null && !RepositoryCache.this.systemWorkspaceName.equals(name)) {
                            RepositoryCache.this.logger.debug("Creating '{0}' workspace in repository '{1}'", new Object[]{name, RepositoryCache.this.getName()});
                            WritableSessionCache workspaceSession = new WritableSessionCache(context, workspaceCache, RepositoryCache.this.sessionContext);
                            MutableCachedNode workspaceRootNode = workspaceSession.mutable(workspaceSession.getRootKey());
                            workspaceRootNode.linkChild(workspaceSession, RepositoryCache.this.systemKey, JcrLexicon.SYSTEM);
                            workspaceSession.save();
                        }
                        return workspaceCache;
                    }
                });
                this.workspaceCachesByName.put(name, initializedWsCache);
            }
        }
        return this.workspaceCachesByName.get(name);
    }

    protected Cache<NodeKey, CachedNode> cacheForWorkspace(String name) {
        TransactionManager txManager;
        Cache cache = this.workspaceCacheManager.getCache(this.cacheNameForWorkspace(name));
        if (cache instanceof AdvancedCache && (txManager = ((AdvancedCache)cache).getTransactionManager()) != null) {
            throw new ConfigurationException(JcrI18n.workspaceCacheShouldNotBeTransactional.text(new Object[]{name}));
        }
        return cache;
    }

    protected final String cacheNameForWorkspace(String workspaceName) {
        return this.name + "/" + workspaceName;
    }

    public final DocumentTranslator getDocumentTranslator() {
        return this.translator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeWorkspace(String name) {
        assert (name != null);
        assert (!this.workspaceNames.contains(name));
        WorkspaceCache removed = this.workspaceCachesByName.remove(name);
        if (removed != null) {
            try {
                removed.signalDeleted();
                this.sessionContext.getTransactionalWorkspaceCacheFactory().remove(name);
            }
            finally {
                if (this.workspaceCacheManager instanceof EmbeddedCacheManager) {
                    ((EmbeddedCacheManager)this.workspaceCacheManager).removeCache(this.cacheNameForWorkspace(name));
                }
            }
        }
    }

    void refreshWorkspace(String name) {
        assert (name != null);
        this.workspaceCachesByName.remove(name);
    }

    Iterable<WorkspaceCache> workspaces() {
        return this.workspaceCachesByName.values();
    }

    public WorkspaceCache createWorkspace(String name) {
        if (!this.workspaceNames.contains(name)) {
            if (!this.configuration.isCreatingWorkspacesAllowed()) {
                throw new UnsupportedOperationException(JcrI18n.creatingWorkspacesIsNotAllowedInRepository.text(new Object[]{this.getName()}));
            }
            this.workspaceNames.add(name);
            this.refreshWorkspaces(true);
            SessionCache session = this.createSession(this.context, name, false);
            MutableCachedNode root = session.mutable(session.getRootKey());
            ChildReference ref = root.getChildReferences(session).getChild(JcrLexicon.SYSTEM);
            if (ref == null) {
                root.linkChild(session, this.systemKey, JcrLexicon.SYSTEM);
                session.save();
            }
            String userId = this.context.getSecurityContext().getUserName();
            Map<String, String> userData = this.context.getData();
            DateTime timestamp = this.context.getValueFactories().getDateFactory().create();
            RecordingChanges changes = new RecordingChanges(this.context.getId(), this.getKey());
            changes.workspaceAdded(name);
            changes.freeze(userId, userData, timestamp);
            this.changeBus.notify(changes);
        }
        return this.workspace(name);
    }

    public boolean destroyWorkspace(String name) {
        if (this.workspaceNames.contains(name)) {
            if (this.configuration.getPredefinedWorkspaceNames().contains(name)) {
                throw new UnsupportedOperationException(JcrI18n.unableToDestroyPredefinedWorkspaceInRepository.text(new Object[]{name, this.getName()}));
            }
            if (this.configuration.getDefaultWorkspaceName().equals(name)) {
                throw new UnsupportedOperationException(JcrI18n.unableToDestroyDefaultWorkspaceInRepository.text(new Object[]{name, this.getName()}));
            }
            if (this.systemWorkspaceName.equals(name)) {
                throw new UnsupportedOperationException(JcrI18n.unableToDestroySystemWorkspaceInRepository.text(new Object[]{name, this.getName()}));
            }
            if (!this.configuration.isCreatingWorkspacesAllowed()) {
                throw new UnsupportedOperationException(JcrI18n.creatingWorkspacesIsNotAllowedInRepository.text(new Object[]{this.getName()}));
            }
            this.workspaceNames.remove(name);
            this.refreshWorkspaces(true);
            String userId = this.context.getSecurityContext().getUserName();
            Map<String, String> userData = this.context.getData();
            DateTime timestamp = this.context.getValueFactories().getDateFactory().create();
            RecordingChanges changes = new RecordingChanges(this.context.getId(), this.getKey());
            changes.workspaceRemoved(name);
            changes.freeze(userId, userData, timestamp);
            this.changeBus.notify(changes);
            return true;
        }
        return false;
    }

    public WorkspaceCache getWorkspaceCache(String workspaceName) {
        return this.workspace(workspaceName);
    }

    public SessionCache createSession(ExecutionContext context, String workspaceName, boolean readOnly) {
        if (readOnly) {
            return new ReadOnlySessionCache(context, this.workspace(workspaceName), this.sessionContext);
        }
        return new WritableSessionCache(context, this.workspace(workspaceName), this.sessionContext);
    }

    public static interface ContentInitializer {
        public void initialize(SessionCache var1, MutableCachedNode var2);
    }

    protected class LocalChangeListener
    implements ChangeSetListener {
        protected LocalChangeListener() {
        }

        @Override
        public void notify(ChangeSet changeSet) {
            if (changeSet == null || !RepositoryCache.this.getKey().equals(changeSet.getRepositoryKey())) {
                return;
            }
            boolean isLocalEvent = RepositoryCache.this.processKey().equals(changeSet.getProcessKey());
            String workspaceName = changeSet.getWorkspaceName();
            if (workspaceName != null) {
                for (WorkspaceCache cache : RepositoryCache.this.workspaces()) {
                    if (isLocalEvent && cache.getWorkspaceName().equalsIgnoreCase(workspaceName)) continue;
                    cache.notify(changeSet);
                }
                if (RepositoryCache.this.sessionContext().indexingClustered()) {
                    if (RepositoryCache.this.logger.isTraceEnabled()) {
                        RepositoryCache.this.logger.trace("Process {0} ignoring {1} because indexing is configured in clustered mode", new Object[]{RepositoryCache.this.processKey(), changeSet});
                    }
                    return;
                }
                if (!isLocalEvent) {
                    this.updateIndexesForRemoteEvent(changeSet);
                }
            } else {
                HashSet<String> removedNames = new HashSet<String>();
                boolean changed = false;
                for (Change change : changeSet) {
                    if (change instanceof WorkspaceAdded) {
                        String addedName = ((WorkspaceAdded)change).getWorkspaceName();
                        if (RepositoryCache.this.getWorkspaceNames().contains(addedName)) continue;
                        changed = true;
                        continue;
                    }
                    if (!(change instanceof WorkspaceRemoved)) continue;
                    String removedName = ((WorkspaceRemoved)change).getWorkspaceName();
                    removedNames.add(removedName);
                    if (!RepositoryCache.this.getWorkspaceNames().contains(removedName)) continue;
                    changed = true;
                }
                if (changed) {
                    RepositoryCache.this.refreshWorkspaces(false);
                    for (String removedName : removedNames) {
                        RepositoryCache.this.removeWorkspace(removedName);
                    }
                }
            }
        }

        private void updateIndexesForRemoteEvent(ChangeSet event) {
            block10: {
                String workspaceName = event.getWorkspaceName();
                WorkspaceCache workspaceCache = RepositoryCache.this.workspace(workspaceName);
                Transactions.Transaction tx = null;
                try {
                    tx = RepositoryCache.this.sessionContext().getTransactions().begin();
                    SessionEnvironment.Monitor monitor = tx.createMonitor();
                    HashSet<NodeKey> nodesWithUpdatedIndexes = new HashSet<NodeKey>();
                    HashSet<NodeKey> nodesToBeRemovedFromIndexes = new HashSet<NodeKey>();
                    for (Change change : event) {
                        if (RepositoryCache.this.logger.isTraceEnabled()) {
                            RepositoryCache.this.logger.trace("Process {0} updating indexes for change: {1} ", new Object[]{RepositoryCache.this.processKey(), change});
                        }
                        if (!(change instanceof AbstractNodeChange)) {
                            if (!RepositoryCache.this.logger.isTraceEnabled()) continue;
                            RepositoryCache.this.logger.trace("Process {0} ignoring change: {1} because it is not index-related", new Object[]{RepositoryCache.this.processKey(), change});
                            continue;
                        }
                        boolean shouldUpdateIndexes = change instanceof NodeMoved || change instanceof NodeRenamed || change instanceof NodeReordered || change instanceof NodeChanged || change instanceof AbstractPropertyChange;
                        AbstractNodeChange nodeChange = (AbstractNodeChange)change;
                        CachedNode node = workspaceCache.getNode(nodeChange.getKey());
                        if (node != null) {
                            NodeKey nodeKey = node.getKey();
                            if (change instanceof NodeAdded) {
                                monitor.recordAdd(workspaceName, nodeKey, node.getPath(workspaceCache), node.getPrimaryType(workspaceCache), node.getMixinTypes(workspaceCache), node.getProperties(workspaceCache));
                                continue;
                            }
                            if (!shouldUpdateIndexes || nodesWithUpdatedIndexes.contains(nodeKey)) continue;
                            nodesWithUpdatedIndexes.add(nodeKey);
                            monitor.recordUpdate(workspaceName, nodeKey, node.getPath(workspaceCache), node.getPrimaryType(workspaceCache), node.getMixinTypes(workspaceCache), node.getProperties(workspaceCache));
                            continue;
                        }
                        if (!(change instanceof NodeRemoved)) continue;
                        nodesToBeRemovedFromIndexes.add(nodeChange.getKey());
                    }
                    if (!nodesToBeRemovedFromIndexes.isEmpty()) {
                        monitor.recordRemove(workspaceName, nodesToBeRemovedFromIndexes);
                    }
                    tx.commit();
                }
                catch (Exception e) {
                    RepositoryCache.this.logger.error((Throwable)e, (I18nResource)JcrI18n.errorUpdatingQueryIndexes, new Object[]{e.getMessage()});
                    if (tx == null) break block10;
                    try {
                        tx.rollback();
                    }
                    catch (SystemException se) {
                        RepositoryCache.this.logger.debug((Throwable)se, "Error while rolling back transaction", new Object[0]);
                    }
                }
            }
        }
    }
}

