/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.List;
import org.infinispan.manager.CacheContainer;
import org.infinispan.schematic.document.EditableDocument;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.jboss.service.BinaryStorage;
import org.modeshape.jboss.service.BinaryStorageService;
import org.modeshape.jboss.subsystem.AbstractAddBinaryStorage;
import org.modeshape.jboss.subsystem.ModelAttributes;

public class AddCacheBinaryStorage
extends AbstractAddBinaryStorage {
    public static final AddCacheBinaryStorage INSTANCE = new AddCacheBinaryStorage();
    private String containerName;

    private AddCacheBinaryStorage() {
    }

    @Override
    protected void writeBinaryStorageConfiguration(String repositoryName, OperationContext context, ModelNode model, EditableDocument binaries) throws OperationFailedException {
        binaries.set("type", (Object)"cache");
        String defaultDataCache = repositoryName + "-binary-data";
        String defaultMetaCache = repositoryName + "-binary-metadata";
        ModelNode dataNode = ModelAttributes.DATA_CACHE_NAME.resolveModelAttribute(context, model);
        ModelNode metaNode = ModelAttributes.METADATA_CACHE_NAME.resolveModelAttribute(context, model);
        String dataCache = dataNode.isDefined() ? dataNode.asString() : defaultDataCache;
        String metaCache = metaNode.isDefined() ? metaNode.asString() : defaultMetaCache;
        binaries.set("dataCacheName", (Object)dataCache);
        binaries.set("metadataCacheName", (Object)metaCache);
        if (ModelAttributes.CACHE_CONTAINER.isMarshallable(model, false)) {
            this.containerName = ModelAttributes.CACHE_CONTAINER.resolveModelAttribute(context, model).asString();
            binaries.set("cacheConfiguration", (Object)"binaries");
        }
    }

    @Override
    protected void addControllersAndDependencies(String repositoryName, BinaryStorageService service, ServiceBuilder<BinaryStorage> builder, List<ServiceController<?>> newControllers, ServiceTarget target, String binariesStoreName) {
        if (this.containerName != null) {
            builder.addDependency(ServiceName.JBOSS.append(new String[]{"infinispan", this.containerName}), CacheContainer.class, service.getBinaryCacheManagerInjector());
        }
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddCacheBinaryStorage.populate(operation, model, ModelAttributes.CACHE_BINARY_STORAGE_ATTRIBUTES);
    }
}

