/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query.lucene.basic;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.indexes.spi.ReaderProvider;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.NodeTypeSchemata;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.query.IndexRules;
import org.modeshape.jcr.query.QueryContext;
import org.modeshape.jcr.query.QueryResults;
import org.modeshape.jcr.query.lucene.FieldUtil;
import org.modeshape.jcr.query.lucene.LuceneException;
import org.modeshape.jcr.query.lucene.LuceneProcessingContext;
import org.modeshape.jcr.query.lucene.LuceneQuery;
import org.modeshape.jcr.query.lucene.LuceneQueryEngine;
import org.modeshape.jcr.query.lucene.LuceneQueryFactory;
import org.modeshape.jcr.query.lucene.LuceneSchema;
import org.modeshape.jcr.query.lucene.basic.BasicLuceneQueryFactory;
import org.modeshape.jcr.query.lucene.basic.BasicTupleCollector;
import org.modeshape.jcr.query.lucene.basic.DynamicField;
import org.modeshape.jcr.query.lucene.basic.NodeInfo;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.query.model.DynamicOperand;
import org.modeshape.jcr.query.model.Literal;
import org.modeshape.jcr.query.model.PropertyValue;
import org.modeshape.jcr.query.model.SelectorName;
import org.modeshape.jcr.query.model.SetCriteria;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.binary.BinaryStore;
import org.modeshape.jcr.value.binary.BinaryStoreException;

public class BasicLuceneSchema
implements LuceneSchema {
    private final SearchFactoryImplementor searchFactory;
    private final Version version;
    private final NamespaceRegistry namespaces;
    private final ExecutionContext context;
    private final Logger logger;
    private final BinaryStore binaryStore;
    private final ValueFactory<String> stringFactory;
    private final boolean enableFullTextSearch;
    private final boolean indexesWereEmpty;

    public BasicLuceneSchema(ExecutionContext context, SearchFactoryImplementor searchFactory, Version version, boolean enableFullTextSearch) {
        this.searchFactory = searchFactory;
        this.context = context;
        this.stringFactory = this.context.getValueFactories().getStringFactory();
        this.binaryStore = this.context.getBinaryStore();
        this.version = version;
        this.enableFullTextSearch = enableFullTextSearch;
        this.namespaces = context.getNamespaceRegistry();
        this.logger = Logger.getLogger(this.getClass());
        assert (this.searchFactory != null);
        this.indexesWereEmpty = this.indexesEmpty();
    }

    public void shutdown() {
        this.searchFactory.getWorker().close();
        this.searchFactory.close();
    }

    @Override
    public LuceneQueryFactory createLuceneQueryFactory(QueryContext context, SearchFactory searchFactory) {
        return new BasicLuceneQueryFactory(context, searchFactory, this.version);
    }

    protected final String stringFrom(Path path) {
        if (path.isRoot()) {
            return "/";
        }
        StringBuilder sb = new StringBuilder();
        for (Path.Segment segment : path) {
            sb.append('/');
            sb.append(segment.getName().getString(this.namespaces));
            sb.append('[');
            sb.append(segment.getIndex());
            sb.append(']');
        }
        return sb.toString();
    }

    protected final String stringFrom(Name name) {
        return name.getString(this.namespaces);
    }

    public IndexManagerHolder getAllIndexesManager() {
        return this.searchFactory.getAllIndexesManager();
    }

    protected final NodeInfo nodeInfo(String id, String workspace, Path path, Name primaryType, Set<Name> mixinTypes, Iterator<Property> propertyIterator, NodeTypeSchemata schemata) {
        String pathStr = null;
        String name = null;
        String localName = null;
        int depth = 0;
        int snsIndex = 1;
        if (path.isRoot()) {
            pathStr = "/";
            name = "";
            localName = "";
            depth = 0;
        } else {
            pathStr = this.stringFrom(path);
            Path.Segment segment = path.getLastSegment();
            Name nodeName = segment.getName();
            name = this.stringFrom(nodeName);
            localName = nodeName.getLocalName();
            depth = path.size();
            snsIndex = segment.getIndex();
        }
        IndexRules rules = schemata.getIndexRules();
        StringBuilder fullText = null;
        if (this.enableFullTextSearch) {
            fullText = new StringBuilder();
            fullText.append(localName);
        }
        DynamicField dynamicField = null;
        while (propertyIterator.hasNext()) {
            boolean fullTextSearchable;
            IndexRules.Rule rule;
            Property property = propertyIterator.next();
            Name propertyName = property.getName();
            String propName = this.stringFrom(propertyName);
            if (property.isEmpty() || (rule = rules.getRule(propertyName)).isSkipped()) continue;
            Field.Store store = rule.getStoreOption();
            boolean bl = fullTextSearchable = this.enableFullTextSearch && rule.isFullTextSearchable();
            if (property.isSingle()) {
                Object value = property.getFirstValue();
                dynamicField = this.addDynamicField(propName, value, dynamicField, store, fullTextSearchable, fullText);
                continue;
            }
            Iterator<?> iter = property.getValues();
            while (iter.hasNext()) {
                Object value = iter.next();
                dynamicField = this.addDynamicField(propName, value, dynamicField, store, fullTextSearchable, fullText);
            }
        }
        if (fullText != null) {
            assert (this.enableFullTextSearch);
            dynamicField = new DynamicField(dynamicField, "::fts", fullText.toString(), true, false);
        }
        return new NodeInfo(id, workspace, pathStr, name, localName, snsIndex, depth, dynamicField);
    }

    protected final DynamicField addDynamicField(String propertyName, Object value, DynamicField previous, Field.Store stored, boolean fullTextSearchable, StringBuilder fullText) {
        boolean isStored;
        boolean bl = isStored = stored == Field.Store.YES;
        if (value instanceof String) {
            String str = (String)value;
            previous = new DynamicField(previous, propertyName, str, false, true);
            previous = new DynamicField(previous, ":len:" + propertyName, str.length(), false, true);
            if (fullTextSearchable) {
                String ftsPropName = ":ft:" + propertyName;
                previous = new DynamicField(previous, ftsPropName, str, true, false);
                fullText.append(' ').append(str);
            }
        } else if (value instanceof BinaryValue) {
            BinaryValue binary = (BinaryValue)value;
            previous = new DynamicField(previous, ":len:" + propertyName, binary.getSize(), false, true);
            if (fullTextSearchable) {
                try {
                    String fullTextTerms = this.binaryStore.getText(binary);
                    if (fullTextTerms != null) {
                        String ftsPropName = ":ft:" + propertyName;
                        previous = new DynamicField(previous, ftsPropName, fullTextTerms, true, false);
                        fullText.append(' ').append(fullTextTerms);
                    }
                }
                catch (BinaryStoreException e) {
                    this.logger.error((Throwable)((Object)e), (I18nResource)JcrI18n.errorExtractingTextFromBinary, new Object[]{binary, e.getLocalizedMessage()});
                }
            }
            String sha1 = binary.getHexHash();
            String sha1PropName = ":sha1:" + propertyName;
            previous = new DynamicField(previous, sha1PropName, sha1, false, false);
        } else if (value instanceof DateTime) {
            DateTime timestamp = (DateTime)value;
            previous = new DynamicField(previous, propertyName, timestamp.getMillisecondsInUtc(), false, isStored);
            String strValue = this.stringFactory.create(timestamp);
            previous = new DynamicField(previous, ":len:" + propertyName, strValue.length(), false, true);
        } else if (value instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)value;
            String strValue = FieldUtil.decimalToString(decimal);
            previous = new DynamicField(previous, propertyName, strValue, false, isStored);
            strValue = this.stringFactory.create(decimal);
            previous = new DynamicField(previous, ":len:" + propertyName, strValue.length(), false, true);
        } else if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            previous = new DynamicField(previous, propertyName, bool != false ? Boolean.TRUE : Boolean.FALSE, false, true);
            long len = bool != false ? 4L : 5L;
            previous = new DynamicField(previous, ":len:" + propertyName, len, false, true);
        } else if (value instanceof Number) {
            Number number = (Number)value;
            previous = new DynamicField(previous, propertyName, number, false, isStored);
            String strValue = null;
            strValue = value instanceof Integer ? this.stringFactory.create(number.intValue()) : (value instanceof Long ? this.stringFactory.create(number.longValue()) : (value instanceof Short ? this.stringFactory.create(number.shortValue()) : (value instanceof Float ? this.stringFactory.create(number.floatValue()) : (value instanceof Double ? this.stringFactory.create(number.doubleValue()) : this.stringFactory.create(number)))));
            previous = new DynamicField(previous, ":len:" + propertyName, strValue.length(), false, true);
        } else if (value instanceof Reference) {
            Reference ref = (Reference)value;
            String stringifiedRef = ref.getString();
            previous = new DynamicField(previous, propertyName, stringifiedRef, false, true);
            String propName = ref.isWeak() ? "::ref" : "::sref";
            previous = new DynamicField(previous, propName, stringifiedRef, false, isStored);
            previous = new DynamicField(previous, ":len:" + propertyName, stringifiedRef.length(), false, true);
        } else if (value != null) {
            String str = this.stringFactory.create(value);
            previous = new DynamicField(previous, propertyName, str, false, isStored);
            previous = new DynamicField(previous, ":len:" + propertyName, str.length(), false, true);
            if (fullTextSearchable) {
                String ftsPropName = ":ft:" + propertyName;
                previous = new DynamicField(previous, ftsPropName, str, true, false);
                fullText.append(' ').append(str);
            }
        }
        return previous;
    }

    @Override
    public void addToIndex(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, Iterator<Property> propertiesIterator, NodeTypeSchemata schemata, TransactionContext txnCtx) {
        String id = key.toString();
        NodeInfo nodeInfo = this.nodeInfo(id, workspace, path, primaryType, mixinTypes, propertiesIterator, schemata);
        this.logger.trace("index for \"{0}\" workspace: ADD    {1} ", new Object[]{workspace, nodeInfo});
        Work work = new Work((Object)nodeInfo, (Serializable)((Object)id), WorkType.ADD);
        this.searchFactory.getWorker().performWork(work, txnCtx);
    }

    @Override
    public void updateIndex(String workspace, NodeKey key, Path path, Name primaryType, Set<Name> mixinTypes, Iterator<Property> properties, NodeTypeSchemata schemata, TransactionContext txnCtx) {
        String id = key.toString();
        NodeInfo nodeInfo = this.nodeInfo(id, workspace, path, primaryType, mixinTypes, properties, schemata);
        this.logger.trace("index for \"{0}\" workspace: UPDATE {1} ", new Object[]{workspace, nodeInfo});
        Work work = new Work((Object)nodeInfo, (Serializable)((Object)id), WorkType.UPDATE);
        this.searchFactory.getWorker().performWork(work, txnCtx);
    }

    @Override
    public void removeFromIndex(String workspace, Iterable<NodeKey> keys, TransactionContext txnCtx) {
        Worker worker = this.searchFactory.getWorker();
        for (NodeKey key : keys) {
            String id = key.toString();
            Work work = new Work(NodeInfo.class, (Serializable)((Object)id), WorkType.PURGE);
            this.logger.trace("index for \"{0}\" workspace: REMOVE {1} ", new Object[]{workspace, id});
            worker.performWork(work, txnCtx);
        }
    }

    @Override
    public void removeAllFromIndex(String workspace, TransactionContext txnCtx) {
        Work work = new Work(Object.class, (Serializable)null, WorkType.PURGE_ALL);
        this.logger.trace("index for \"{0}\" workspace: REMOVEALL", new Object[]{workspace});
        this.searchFactory.getWorker().performWork(work, txnCtx);
    }

    @Override
    public void addBinaryToIndex(Binary binary, TransactionContext txnCtx) {
    }

    @Override
    public void removeBinariesFromIndex(Iterable<String> sha1s, TransactionContext txnCtx) {
    }

    @Override
    public LuceneQuery createQuery(SelectorName selectorName, List<Constraint> andedConstraints, LuceneProcessingContext processingContext) throws LuceneException {
        try {
            Query constraintQuery;
            LuceneQuery queries = new LuceneQuery("nodeinfo");
            LuceneQueryFactory queryFactory = processingContext.getQueryFactory();
            Set<String> workspaceNames = processingContext.getWorkspaceNames();
            int numWorkspaceNames = workspaceNames.size();
            if (numWorkspaceNames > 0) {
                PropertyValue workspaceField = new PropertyValue(selectorName, "::wks");
                Constraint workspacesConstraint = null;
                if (numWorkspaceNames == 1) {
                    String workspaceName = workspaceNames.iterator().next();
                    Literal workspaceValue = new Literal(workspaceName);
                    workspacesConstraint = new Comparison(workspaceField, Operator.EQUAL_TO, workspaceValue);
                } else if (numWorkspaceNames > 1) {
                    ArrayList<Literal> workspaceValues = new ArrayList<Literal>(numWorkspaceNames);
                    for (String workspaceName : workspaceNames) {
                        workspaceValues.add(new Literal(workspaceName));
                    }
                    workspacesConstraint = new SetCriteria((DynamicOperand)workspaceField, workspaceValues);
                }
                constraintQuery = queryFactory.createQuery(selectorName, workspacesConstraint);
                queries.addQuery(constraintQuery);
            }
            for (Constraint andedConstraint : andedConstraints) {
                constraintQuery = queryFactory.createQuery(selectorName, andedConstraint);
                if (constraintQuery != null) {
                    queries.addQuery(constraintQuery);
                    continue;
                }
                queries.addConstraintForPostprocessing(andedConstraint);
            }
            return queries;
        }
        catch (IOException e) {
            throw new LuceneException(e);
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    @Override
    public LuceneQueryEngine.TupleCollector createTupleCollector(QueryContext queryContext, QueryResults.Columns columns) {
        return new BasicTupleCollector(queryContext, columns);
    }

    @Override
    public boolean initializedIndexes() {
        return this.indexesWereEmpty;
    }

    private boolean indexesEmpty() {
        IndexManager indexManager = this.searchFactory.getAllIndexesManager().getIndexManager("nodeinfo");
        if (indexManager == null) {
            return true;
        }
        ReaderProvider readerProvider = indexManager.getReaderProvider();
        IndexReader indexReader = readerProvider.openIndexReader();
        FieldSelector fieldSelector = new FieldSelector(){
            private static final long serialVersionUID = 1L;

            public FieldSelectorResult accept(String fieldName) {
                return "::id".equalsIgnoreCase(fieldName) ? FieldSelectorResult.LOAD_AND_BREAK : FieldSelectorResult.NO_LOAD;
            }
        };
        try {
            int numDocs = indexReader.numDocs();
            for (int docNumber = 0; docNumber < numDocs; ++docNumber) {
                if (indexReader.isDeleted(docNumber)) continue;
                Document doc = indexReader.document(docNumber, fieldSelector);
                assert (doc != null);
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            readerProvider.closeIndexReader(indexReader);
        }
    }
}

