/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.file;

import java.io.Serializable;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.storage.file.CheckoutEntry;
import org.eclipse.jgit.util.RawParseUtils;

public class ReflogEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ObjectId oldId;
    private ObjectId newId;
    private PersonIdent who;
    private String comment;

    ReflogEntry(byte[] raw, int pos) {
        int p1;
        this.oldId = ObjectId.fromString(raw, pos);
        pos += 40;
        if (raw[pos++] != 32) {
            throw new IllegalArgumentException(JGitText.get().rawLogMessageDoesNotParseAsLogEntry);
        }
        this.newId = ObjectId.fromString(raw, pos);
        pos += 40;
        if (raw[pos++] != 32) {
            throw new IllegalArgumentException(JGitText.get().rawLogMessageDoesNotParseAsLogEntry);
        }
        this.who = RawParseUtils.parsePersonIdentOnly(raw, pos);
        int p0 = RawParseUtils.next(raw, pos, '\t');
        this.comment = p0 >= raw.length ? "" : ((p1 = RawParseUtils.nextLF(raw, p0)) > p0 ? RawParseUtils.decode(raw, p0, p1 - 1) : "");
    }

    public ObjectId getOldId() {
        return this.oldId;
    }

    public ObjectId getNewId() {
        return this.newId;
    }

    public PersonIdent getWho() {
        return this.who;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return "Entry[" + this.oldId.name() + ", " + this.newId.name() + ", " + this.getWho() + ", " + this.getComment() + "]";
    }

    public CheckoutEntry parseCheckout() {
        if (this.getComment().startsWith("checkout: moving from ")) {
            return new CheckoutEntry(this);
        }
        return null;
    }
}

