/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.connector.git;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.ListTagCommand;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.infinispan.schematic.document.Document;
import org.modeshape.connector.git.CallSpecification;
import org.modeshape.connector.git.GitConnector;
import org.modeshape.connector.git.Values;
import org.modeshape.jcr.federation.spi.DocumentWriter;
import org.modeshape.jcr.federation.spi.PageKey;
import org.modeshape.jcr.federation.spi.PageWriter;

public abstract class GitFunction {
    protected static final String DELIMITER = "/";
    protected static final String REMOTE_BRANCH_PREFIX = "refs/remotes/";
    protected static final String TAG_PREFIX = "refs/tags/";
    protected static final int DEFAULT_PAGE_SIZE = 15;
    protected static final Comparator<Ref> REVERSE_REF_COMPARATOR = new Comparator<Ref>(){

        @Override
        public int compare(Ref o1, Ref o2) {
            return 0 - o1.getName().compareTo(o2.getName());
        }
    };
    protected final String name;
    protected final GitConnector connector;
    protected int pageSize = 15;

    protected GitFunction(String name, GitConnector connector) {
        this.name = name;
        this.connector = connector;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPaged() {
        return false;
    }

    public abstract Document execute(Repository var1, Git var2, CallSpecification var3, DocumentWriter var4, Values var5) throws GitAPIException, IOException;

    private String remoteBranchPrefix() {
        String remoteName = this.connector.remoteName();
        return REMOTE_BRANCH_PREFIX + remoteName + DELIMITER;
    }

    protected String branchRefForName(String branchName) {
        return this.remoteBranchPrefix() + branchName;
    }

    protected ObjectId resolveBranchOrTagOrCommitId(Repository repository, String branchOrTagOrCommitId) throws IOException {
        ObjectId objId = repository.resolve(branchOrTagOrCommitId);
        if (objId == null) {
            String branchRef = this.branchRefForName(branchOrTagOrCommitId);
            objId = repository.resolve(branchRef);
        }
        return objId;
    }

    protected void addBranchesAsChildren(Git git, CallSpecification spec, DocumentWriter writer) throws GitAPIException {
        ListBranchCommand command = git.branchList();
        command.setListMode(ListBranchCommand.ListMode.REMOTE);
        String remoteBranchPrefix = this.remoteBranchPrefix();
        List branches = command.call();
        Collections.sort(branches, REVERSE_REF_COMPARATOR);
        for (Ref ref : branches) {
            String name = ref.getName();
            if (!name.startsWith(remoteBranchPrefix)) continue;
            name = name.replaceFirst(remoteBranchPrefix, "");
            writer.addChild(spec.childId(name), name);
        }
    }

    protected void addTagsAsChildren(Git git, CallSpecification spec, DocumentWriter writer) throws GitAPIException {
        ListTagCommand command = git.tagList();
        List tags = command.call();
        Collections.sort(tags, REVERSE_REF_COMPARATOR);
        for (Ref ref : tags) {
            String fullName = ref.getName();
            String name = fullName.replaceFirst(TAG_PREFIX, "");
            writer.addChild(spec.childId(name), name);
        }
    }

    protected void addCommitsAsChildren(Git git, CallSpecification spec, DocumentWriter writer, int pageSize) throws GitAPIException {
        LogCommand command = git.log();
        command.setSkip(0);
        command.setMaxCount(pageSize);
        int actual = 0;
        String commitId = null;
        for (RevCommit commit : command.call()) {
            commitId = commit.getName();
            writer.addChild(spec.childId(commitId), commitId);
            ++actual;
        }
        if (actual == pageSize) {
            writer.addPage(spec.getId(), commitId, (long)pageSize, -1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCommitsAsPageOfChildren(Git git, Repository repository, CallSpecification spec, PageWriter writer, PageKey pageKey) throws GitAPIException, IOException {
        RevWalk walker = new RevWalk(repository);
        try {
            String lastCommitIdName = pageKey.getOffsetString();
            ObjectId lastCommitId = repository.resolve(lastCommitIdName);
            int pageSize = (int)pageKey.getBlockSize();
            LogCommand command = git.log();
            command.add((AnyObjectId)lastCommitId);
            command.setMaxCount(pageSize + 1);
            int actual = 0;
            String commitId = null;
            for (RevCommit commit : command.call()) {
                commitId = commit.getName();
                if (commitId.equals(lastCommitIdName)) continue;
                writer.addChild(spec.childId(commitId), commitId);
                ++actual;
            }
            if (actual == pageSize) {
                assert (commitId != null);
                writer.addPage(pageKey.getParentId(), commitId, (long)pageSize, -1L);
            }
        }
        finally {
            walker.dispose();
        }
    }

    protected boolean isQueryable(CallSpecification callSpec) {
        return false;
    }

    public String toString() {
        return this.getName();
    }
}

