/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jgit.diff.RawText;

public class AutoCRLFOutputStream
extends OutputStream {
    private final OutputStream out;
    private int buf = -1;
    private byte[] binbuf = new byte[8000];
    private int binbufcnt = 0;
    private boolean isBinary;

    public AutoCRLFOutputStream(OutputStream out) {
        this.out = out;
    }

    public void write(int b) throws IOException {
        int overflow = this.buffer((byte)b);
        if (overflow >= 0) {
            return;
        }
        if (this.isBinary) {
            this.out.write(b);
            return;
        }
        if (b == 10) {
            if (this.buf == 13) {
                this.out.write(10);
                this.buf = -1;
            } else if (this.buf == -1) {
                this.out.write(13);
                this.out.write(10);
                this.buf = -1;
            }
        } else if (b == 13) {
            this.out.write(b);
            this.buf = 13;
        } else {
            this.out.write(b);
            this.buf = -1;
        }
    }

    public void write(byte[] b) throws IOException {
        int overflow = this.buffer(b, 0, b.length);
        if (overflow > 0) {
            this.write(b, b.length - overflow, overflow);
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int overflow = this.buffer(b, off, len);
        if (overflow < 0) {
            return;
        }
        off = off + len - overflow;
        len = overflow;
        if (len == 0) {
            return;
        }
        int lastw = off;
        if (this.isBinary) {
            this.out.write(b, off, len);
            return;
        }
        for (int i = off; i < off + len; ++i) {
            byte c = b[i];
            if (c == 13) {
                this.buf = 13;
                continue;
            }
            if (c == 10) {
                if (this.buf != 13) {
                    if (lastw < i) {
                        this.out.write(b, lastw, i - lastw);
                    }
                    this.out.write(13);
                    lastw = i;
                }
                this.buf = -1;
                continue;
            }
            this.buf = -1;
        }
        if (lastw < off + len) {
            this.out.write(b, lastw, off + len - lastw);
        }
        if (b[off + len - 1] == 13) {
            this.buf = 13;
        }
    }

    private int buffer(byte b) throws IOException {
        if (this.binbufcnt > this.binbuf.length) {
            return 1;
        }
        this.binbuf[this.binbufcnt++] = b;
        if (this.binbufcnt == this.binbuf.length) {
            this.decideMode();
        }
        return 0;
    }

    private int buffer(byte[] b, int off, int len) throws IOException {
        if (this.binbufcnt > this.binbuf.length) {
            return len;
        }
        int copy = Math.min(this.binbuf.length - this.binbufcnt, len);
        System.arraycopy(b, off, this.binbuf, this.binbufcnt, copy);
        this.binbufcnt += copy;
        int remaining = len - copy;
        if (remaining > 0) {
            this.decideMode();
        }
        return remaining;
    }

    private void decideMode() throws IOException {
        this.isBinary = RawText.isBinary(this.binbuf, this.binbufcnt);
        int cachedLen = this.binbufcnt;
        this.binbufcnt = this.binbuf.length + 1;
        this.write(this.binbuf, 0, cachedLen);
    }

    public void flush() throws IOException {
        if (this.binbufcnt < this.binbuf.length) {
            this.decideMode();
        }
        this.buf = -1;
        this.out.flush();
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }
}

