/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.util.concurrent.jdk8backported.ConcurrentHashMapV8;

public class ConcurrentMapFactory {
    private static final ConcurrentMapCreator MAP_CREATOR;

    public static <K, V> ConcurrentMap<K, V> makeConcurrentMap() {
        return MAP_CREATOR.createConcurrentMap();
    }

    public static <K, V> ConcurrentMap<K, V> makeConcurrentMap(int initCapacity) {
        return MAP_CREATOR.createConcurrentMap(initCapacity);
    }

    public static <K, V> ConcurrentMap<K, V> makeConcurrentMap(int initCapacity, int concurrencyLevel) {
        return MAP_CREATOR.createConcurrentMap(initCapacity, concurrencyLevel);
    }

    public static <K, V> ConcurrentMap<K, V> makeConcurrentMap(int initCapacity, float loadFactor, int concurrencyLevel) {
        return MAP_CREATOR.createConcurrentMap(initCapacity, loadFactor, concurrencyLevel);
    }

    static {
        boolean jdk8;
        boolean sunIncompatibleJvm;
        boolean allowExperimentalMap = Boolean.getBoolean("infinispan.unsafe.allow_jdk8_chm");
        try {
            Class.forName("sun.misc.Unsafe");
            sunIncompatibleJvm = false;
        }
        catch (ClassNotFoundException e) {
            sunIncompatibleJvm = true;
        }
        try {
            Class.forName("java.util.concurrent.atomic.LongAdder");
            jdk8 = true;
        }
        catch (ClassNotFoundException e) {
            jdk8 = false;
        }
        MAP_CREATOR = jdk8 || sunIncompatibleJvm || !allowExperimentalMap ? new JdkConcurrentMapCreator() : new BackportedV8ConcurrentMapCreator();
    }

    private static class BackportedV8ConcurrentMapCreator
    implements ConcurrentMapCreator {
        private BackportedV8ConcurrentMapCreator() {
        }

        @Override
        public <K, V> ConcurrentMap<K, V> createConcurrentMap() {
            return new ConcurrentHashMapV8();
        }

        @Override
        public <K, V> ConcurrentMap<K, V> createConcurrentMap(int initialCapacity) {
            return new ConcurrentHashMapV8(initialCapacity);
        }

        @Override
        public <K, V> ConcurrentMap<K, V> createConcurrentMap(int initialCapacity, int concurrencyLevel) {
            return new ConcurrentHashMapV8(initialCapacity, 0.75f, concurrencyLevel);
        }

        @Override
        public <K, V> ConcurrentMap<K, V> createConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
            return new ConcurrentHashMapV8(initialCapacity, loadFactor, concurrencyLevel);
        }
    }

    private static class JdkConcurrentMapCreator
    implements ConcurrentMapCreator {
        private JdkConcurrentMapCreator() {
        }

        @Override
        public <K, V> ConcurrentMap<K, V> createConcurrentMap() {
            return new ConcurrentHashMap();
        }

        @Override
        public <K, V> ConcurrentMap<K, V> createConcurrentMap(int initialCapacity) {
            return new ConcurrentHashMap(initialCapacity);
        }

        @Override
        public <K, V> ConcurrentMap<K, V> createConcurrentMap(int initialCapacity, int concurrencyLevel) {
            return new ConcurrentHashMap(initialCapacity, 0.75f, concurrencyLevel);
        }

        @Override
        public <K, V> ConcurrentMap<K, V> createConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
            return new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
        }
    }

    private static interface ConcurrentMapCreator {
        public <K, V> ConcurrentMap<K, V> createConcurrentMap();

        public <K, V> ConcurrentMap<K, V> createConcurrentMap(int var1);

        public <K, V> ConcurrentMap<K, V> createConcurrentMap(int var1, int var2);

        public <K, V> ConcurrentMap<K, V> createConcurrentMap(int var1, float var2, int var3);
    }
}

