/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.txn;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.modeshape.common.logging.Logger;
import org.modeshape.jcr.cache.SessionEnvironment;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.document.WorkspaceCache;

public abstract class Transactions {
    protected final TransactionManager txnMgr;
    protected final SessionEnvironment.MonitorFactory monitorFactory;
    protected final Logger logger = Logger.getLogger(Transactions.class);

    protected Transactions(SessionEnvironment.MonitorFactory monitorFactory, TransactionManager txnMgr) {
        this.monitorFactory = monitorFactory;
        this.txnMgr = txnMgr;
    }

    public boolean isCurrentlyInTransaction() throws SystemException {
        return this.txnMgr.getTransaction() != null;
    }

    public String currentTransactionId() {
        try {
            javax.transaction.Transaction txn = this.txnMgr.getTransaction();
            return txn != null ? txn.toString() : null;
        }
        catch (SystemException e) {
            return null;
        }
    }

    public TransactionManager getTransactionManager() {
        return this.txnMgr;
    }

    public abstract Transaction begin() throws NotSupportedException, SystemException;

    public void updateCache(WorkspaceCache workspace, ChangeSet changes, Transaction transaction) {
        if (changes != null && !changes.isEmpty()) {
            workspace.changed(changes);
        }
    }

    public javax.transaction.Transaction suspend() throws SystemException {
        return this.txnMgr.suspend();
    }

    public void resume(javax.transaction.Transaction transaction) throws SystemException {
        if (transaction != null && this.txnMgr.getTransaction() == null) {
            try {
                this.txnMgr.resume(transaction);
            }
            catch (InvalidTransactionException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected SessionEnvironment.Monitor newMonitor() {
        return this.monitorFactory.createMonitor();
    }

    protected class TraceableSimpleTransaction
    extends SimpleTransaction {
        protected TraceableSimpleTransaction(TransactionManager txnMgr) {
            super(txnMgr);
        }

        @Override
        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            if (Transactions.this.logger.isTraceEnabled()) {
                Transactions.this.logger.trace("Rolling back transaction '{0}'", new Object[]{Transactions.this.currentTransactionId()});
            }
            super.rollback();
        }

        @Override
        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            if (Transactions.this.logger.isTraceEnabled()) {
                String id = Transactions.this.currentTransactionId();
                super.commit();
                Transactions.this.logger.trace("Committed transaction '{0}'", new Object[]{id});
            } else {
                super.commit();
            }
        }
    }

    protected class SimpleTransaction
    extends BaseTransaction {
        protected SimpleTransaction(TransactionManager txnMgr) {
            super(txnMgr);
        }

        @Override
        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            this.txnMgr.rollback();
        }

        @Override
        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            this.txnMgr.commit();
            this.executeFunctions();
        }
    }

    protected abstract class BaseTransaction
    implements Transaction {
        protected final TransactionManager txnMgr;
        private List<TransactionFunction> functions;

        protected BaseTransaction(TransactionManager txnMgr) {
            this.txnMgr = txnMgr;
        }

        @Override
        public SessionEnvironment.Monitor createMonitor() {
            return Transactions.this.newMonitor();
        }

        protected void executeFunctions() {
            if (this.functions != null) {
                for (TransactionFunction function : this.functions) {
                    function.transactionComplete();
                }
            }
        }

        @Override
        public void uponCompletion(TransactionFunction function) {
            if (this.functions == null) {
                this.functions = Collections.singletonList(function);
            } else {
                if (this.functions.size() == 1) {
                    this.functions = new LinkedList<TransactionFunction>(this.functions);
                }
                this.functions.add(function);
            }
        }
    }

    public static interface TransactionFunction {
        public void transactionComplete();
    }

    public static interface Transaction
    extends SessionEnvironment.MonitorFactory {
        @Override
        public SessionEnvironment.Monitor createMonitor();

        public void uponCompletion(TransactionFunction var1);

        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException;

        public void rollback() throws IllegalStateException, SecurityException, SystemException;
    }
}

