/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.value.basic;

import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.IoException;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.PropertyType;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;
import org.modeshape.jcr.value.ValueFormatException;

@Immutable
public abstract class AbstractValueFactory<T>
implements ValueFactory<T> {
    protected final TextDecoder decoder;
    protected final PropertyType propertyType;
    protected final ValueFactories valueFactories;

    protected AbstractValueFactory(PropertyType type, TextDecoder decoder, ValueFactories valueFactories) {
        CheckArg.isNotNull((Object)((Object)type), (String)"type");
        this.propertyType = type;
        this.decoder = decoder != null ? decoder : DEFAULT_DECODER;
        this.valueFactories = valueFactories;
    }

    protected ValueFactory<String> getStringValueFactory() {
        return this.valueFactories.getStringFactory();
    }

    public TextDecoder getDecoder() {
        return this.decoder;
    }

    protected TextDecoder getDecoder(TextDecoder decoder) {
        return decoder != null ? decoder : this.getDecoder();
    }

    @Override
    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    @Override
    public T create(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.create((String)value);
        }
        if (value instanceof Integer) {
            return this.create((Integer)value);
        }
        if (value instanceof Long) {
            return this.create((Long)value);
        }
        if (value instanceof Double) {
            return this.create((Double)value);
        }
        if (value instanceof Float) {
            return this.create(((Float)value).floatValue());
        }
        if (value instanceof Boolean) {
            return this.create((Boolean)value);
        }
        if (value instanceof BigDecimal) {
            return this.create((BigDecimal)value);
        }
        if (value instanceof DateTime) {
            return this.create((DateTime)value);
        }
        if (value instanceof Calendar) {
            return this.create((Calendar)value);
        }
        if (value instanceof Date) {
            return this.create((Date)value);
        }
        if (value instanceof Name) {
            return this.create((Name)value);
        }
        if (value instanceof Path) {
            return this.create((Path)value);
        }
        if (value instanceof Path.Segment) {
            return this.create((Path.Segment)value);
        }
        if (value instanceof Reference) {
            return this.create((Reference)value);
        }
        if (value instanceof NodeKey) {
            return this.create((NodeKey)value);
        }
        if (value instanceof UUID) {
            return this.create((UUID)value);
        }
        if (value instanceof URI) {
            return this.create((URI)value);
        }
        if (value instanceof BinaryValue) {
            return this.create((BinaryValue)value);
        }
        if (value instanceof Binary) {
            Binary jcrBinary = (Binary)value;
            try {
                return this.create(jcrBinary.getStream());
            }
            catch (RepositoryException e) {
                throw new RuntimeException(e);
            }
        }
        if (value instanceof byte[]) {
            return this.create((byte[])value);
        }
        if (value instanceof InputStream) {
            return this.create((InputStream)value);
        }
        return this.create(value.toString());
    }

    protected abstract T[] createEmptyArray(int var1);

    @Override
    public T[] create(BigDecimal[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(boolean[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(byte[][] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(Calendar[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(Date[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(DateTime[] values) throws ValueFormatException {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(double[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(float[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(int[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(long[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(Name[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(Object[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(Path[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(Reference[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(String[] values, TextDecoder decoder) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i], decoder);
        }
        return result;
    }

    @Override
    public T[] create(String[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(URI[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(UUID[] values) {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(NodeKey[] values) throws ValueFormatException {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public T[] create(BinaryValue[] values) throws ValueFormatException, IoException {
        if (values == null) {
            return null;
        }
        int length = values.length;
        T[] result = this.createEmptyArray(length);
        for (int i = 0; i != length; ++i) {
            result[i] = this.create(values[i]);
        }
        return result;
    }

    @Override
    public Iterator<T> create(Iterator<?> values) throws ValueFormatException, IoException {
        return new ConvertingIterator(values, this);
    }

    @Override
    public Iterable<T> create(final Iterable<?> valueIterable) throws ValueFormatException, IoException {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return AbstractValueFactory.this.create(valueIterable.iterator());
            }
        };
    }

    @Override
    public T create(InputStream stream, String hint) throws ValueFormatException, IoException {
        return this.create(stream);
    }

    protected static class ConvertingIterator<ValueType>
    implements Iterator<ValueType> {
        private final Iterator<?> delegate;
        private final ValueFactory<ValueType> factory;

        protected ConvertingIterator(Iterator<?> delegate, ValueFactory<ValueType> factory) {
            assert (delegate != null);
            assert (factory != null);
            this.delegate = delegate;
            this.factory = factory;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public ValueType next() {
            return this.factory.create(this.delegate.next());
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

