/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.metric;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jboss.metric.GetDurationMetric;
import org.modeshape.jboss.metric.GetValueMetric;
import org.modeshape.jcr.api.monitor.DurationMetric;
import org.modeshape.jcr.api.monitor.ValueMetric;
import org.modeshape.jcr.api.monitor.Window;

public final class ModelMetrics {
    public static final List<MetricAttributeDefinition> ALL_METRICS;

    private ModelMetrics() {
    }

    static {
        Window[] windows = Window.values();
        ValueMetric[] valueMetrics = ValueMetric.values();
        DurationMetric[] durationMetrics = DurationMetric.values();
        ALL_METRICS = new ArrayList<MetricAttributeDefinition>(windows.length * (valueMetrics.length + durationMetrics.length));
        for (Window window : windows) {
            MetricAttributeDefinition attrDefn;
            for (DurationMetric durationMetric : durationMetrics) {
                attrDefn = new DurationMetricAttributeDefinition(durationMetric, window);
                ALL_METRICS.add(attrDefn);
            }
            for (DurationMetric durationMetric : valueMetrics) {
                attrDefn = new ValueMetricAttributeDefinition((ValueMetric)durationMetric, window);
                ALL_METRICS.add(attrDefn);
            }
        }
    }

    private static class ValueMetricAttributeDefinition
    extends MetricAttributeDefinition {
        final OperationStepHandler handler;

        ValueMetricAttributeDefinition(ValueMetric metric, Window window) {
            super(ValueMetricAttributeDefinition.attributeName(metric.getLiteral(), window));
            this.handler = new GetValueMetric(metric, window);
        }

        @Override
        public OperationStepHandler metricHandler() {
            return this.handler;
        }
    }

    public static abstract class MetricAttributeDefinition
    extends SimpleAttributeDefinition {
        public static final String attributeName(String metricName, Window window) {
            assert (!StringUtil.isBlank((String)metricName));
            assert (window != null);
            return metricName + '-' + window.getLiteral();
        }

        protected MetricAttributeDefinition(String name) {
            super(name, new ModelNode(0), ModelType.DOUBLE, false);
        }

        public abstract OperationStepHandler metricHandler();
    }

    private static class DurationMetricAttributeDefinition
    extends MetricAttributeDefinition {
        final OperationStepHandler handler;

        DurationMetricAttributeDefinition(DurationMetric metric, Window window) {
            super(DurationMetricAttributeDefinition.attributeName(metric.getLiteral(), window));
            this.handler = new GetDurationMetric(metric, window);
        }

        @Override
        public OperationStepHandler metricHandler() {
            return this.handler;
        }
    }
}

