/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.service;

import org.infinispan.manager.CacheContainer;
import org.infinispan.schematic.document.EditableDocument;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.modeshape.jboss.service.BinaryStorage;

public class BinaryStorageService
implements Service<BinaryStorage> {
    private final Injector<CacheContainer> binaryManagerInjector = new Injector<CacheContainer>(){

        public void inject(CacheContainer value) throws InjectionException {
            BinaryStorageService.this.binaryStorage().setCacheContainer(value);
        }

        public void uninject() {
            BinaryStorageService.this.binaryStorage().setCacheContainer(null);
        }
    };
    private final InjectedValue<String> binaryStorageBasePathInjector = new InjectedValue();
    private final InjectedValue<String> dataDirectoryPathInjector = new InjectedValue();
    private final String repositoryName;
    private final BinaryStorage binaryStorage;

    public BinaryStorageService(String repositoryName, EditableDocument binaryConfig) {
        this.repositoryName = repositoryName;
        this.binaryStorage = new BinaryStorage(binaryConfig);
    }

    public BinaryStorageService(String repositoryName) {
        this.repositoryName = repositoryName;
        this.binaryStorage = null;
    }

    protected final BinaryStorage binaryStorage() {
        return this.binaryStorage;
    }

    private String getBinaryStorageBasePath() {
        return this.appendDirDelim((String)this.binaryStorageBasePathInjector.getOptionalValue());
    }

    private String appendDirDelim(String value) {
        if (value != null && !value.endsWith("/")) {
            value = value + "/";
        }
        return value;
    }

    public InjectedValue<String> getBinaryStorageBasePathInjector() {
        return this.binaryStorageBasePathInjector;
    }

    public Injector<CacheContainer> getBinaryCacheManagerInjector() {
        return this.binaryManagerInjector;
    }

    public BinaryStorage getValue() throws IllegalStateException, IllegalArgumentException {
        return this.binaryStorage != null ? this.binaryStorage : BinaryStorage.defaultStorage(this.repositoryName, (String)this.dataDirectoryPathInjector.getValue());
    }

    public InjectedValue<String> getDataDirectoryPathInjector() {
        return this.dataDirectoryPathInjector;
    }

    public void start(StartContext arg0) {
        EditableDocument binaryConfig;
        String relativePath;
        String binaryStorageBasePath = this.getBinaryStorageBasePath();
        if (binaryStorageBasePath != null && (relativePath = (binaryConfig = this.binaryStorage.getBinaryConfiguration()).getString("directory")) != null) {
            binaryConfig.set("directory", (Object)(binaryStorageBasePath + relativePath));
        }
    }

    public void stop(StopContext arg0) {
    }
}

