/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.TpHeader;
import org.jgroups.stack.GossipData;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.RouterStub;
import org.jgroups.stack.RouterStubManager;
import org.jgroups.util.Buffer;
import org.jgroups.util.ExposedByteArrayOutputStream;
import org.jgroups.util.ExposedDataOutputStream;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@Experimental
public class TUNNEL
extends TP {
    @Property(description="Interval in msec to attempt connecting back to router in case of torn connection. Default is 5000 msec")
    private long reconnect_interval = 5000L;
    @Property(description="Should TCP no delay flag be turned on")
    boolean tcp_nodelay = false;
    private final List<InetSocketAddress> gossip_router_hosts = new ArrayList<InetSocketAddress>();
    private TUNNELPolicy tunnel_policy = new DefaultTUNNELPolicy();
    private DatagramSocket sock;
    private volatile RouterStubManager stubManager;

    @Override
    public boolean supportsMulticasting() {
        return true;
    }

    @Property(description="A comma-separated list of GossipRouter hosts, e.g. HostA[12001],HostB[12001]")
    public void setGossipRouterHosts(String hosts) throws UnknownHostException {
        this.gossip_router_hosts.clear();
        if (hosts.startsWith("[") && hosts.endsWith("]")) {
            hosts = hosts.substring(1, hosts.length() - 1);
        }
        this.gossip_router_hosts.addAll(Util.parseCommaDelimitedHosts2(hosts, 1));
    }

    @Override
    public String toString() {
        return "TUNNEL";
    }

    public long getReconnectInterval() {
        return this.reconnect_interval;
    }

    public void setReconnectInterval(long reconnect_interval) {
        this.reconnect_interval = reconnect_interval;
    }

    public synchronized void setTUNNELPolicy(TUNNELPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Tunnel policy has to be non null");
        }
        this.tunnel_policy = policy;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.enable_bundling) {
            this.log.warn("bundling is currently not supported by TUNNEL; bundling is disabled");
            this.enable_bundling = false;
        }
        if (this.timer == null) {
            throw new Exception("timer cannot be retrieved from protocol stack");
        }
        if (this.isSingleton()) {
            throw new Exception("TUNNEL and shared transport mode are not supported!");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("GossipRouters are:" + this.gossip_router_hosts.toString());
        }
        this.stubManager = RouterStubManager.emptyGossipClientStubManager(this);
        this.sock = this.getSocketFactory().createDatagramSocket("jgroups.tunnel.ucast_sock", this.bind_port, this.bind_addr);
        this.loopback = true;
    }

    @Override
    public void destroy() {
        this.stubManager.destroyStubs();
        super.destroy();
    }

    private void disconnectStub(String group, Address addr) {
        this.stubManager.disconnectStubs();
    }

    @Override
    public Object handleDownEvent(Event evt) {
        Object retEvent = super.handleDownEvent(evt);
        switch (evt.getType()) {
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                String group = (String)evt.getArg();
                Address local = null;
                if (!this.isSingleton()) {
                    local = this.local_addr;
                } else {
                    TP.ProtocolAdapter adapter = TP.ProtocolAdapter.thread_local.get();
                    local = adapter.local_addr;
                }
                if (this.stubManager != null) {
                    this.stubManager.destroyStubs();
                }
                this.stubManager = new TUNNELStubManager(this, group, local, this.getReconnectInterval());
                for (InetSocketAddress gr : this.gossip_router_hosts) {
                    RouterStub stub = this.stubManager.createAndRegisterStub(gr.getHostName(), gr.getPort(), this.bind_addr);
                    stub.setTcpNoDelay(this.tcp_nodelay);
                }
                PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, local));
                List<PhysicalAddress> physical_addrs = Arrays.asList(physical_addr);
                String logical_name = UUID.get(local);
                List<RouterStub> stubs = this.stubManager.getStubs();
                this.tunnel_policy.connect(stubs, group, local, logical_name, physical_addrs);
                break;
            }
            case 4: {
                String group;
                Address local;
                if (!this.isSingleton()) {
                    local = this.local_addr;
                    group = this.channel_name;
                } else {
                    TP.ProtocolAdapter adapter = TP.ProtocolAdapter.thread_local.get();
                    local = adapter.local_addr;
                    group = adapter.cluster_name;
                }
                this.disconnectStub(group, local);
            }
        }
        return retEvent;
    }

    @Override
    protected void send(Message msg, Address dest, boolean multicast) throws Exception {
        TpHeader hdr = (TpHeader)msg.getHeader(this.id);
        if (hdr == null) {
            throw new Exception("message " + msg + " doesn't have a transport header, cannot route it");
        }
        String group = hdr.channel_name;
        ExposedByteArrayOutputStream out_stream = new ExposedByteArrayOutputStream((int)(msg.size() + 50L));
        ExposedDataOutputStream dos = new ExposedDataOutputStream(out_stream);
        TUNNEL.writeMessage(msg, dos, multicast);
        Buffer buf = new Buffer(out_stream.getRawBuffer(), 0, out_stream.size());
        if (this.stats) {
            ++this.num_msgs_sent;
            this.num_bytes_sent += (long)buf.getLength();
        }
        List<RouterStub> stubs = this.stubManager.getStubs();
        if (multicast) {
            this.tunnel_policy.sendToAllMembers(stubs, group, buf.getBuf(), buf.getOffset(), buf.getLength());
        } else {
            this.tunnel_policy.sendToSingleMember(stubs, group, dest, buf.getBuf(), buf.getOffset(), buf.getLength());
        }
    }

    @Override
    public void sendMulticast(byte[] data, int offset, int length) throws Exception {
        throw new UnsupportedOperationException("sendMulticast() should not get called on TUNNEL");
    }

    @Override
    public void sendUnicast(PhysicalAddress dest, byte[] data, int offset, int length) throws Exception {
        throw new UnsupportedOperationException("sendUnicast() should not get called on TUNNEL");
    }

    @Override
    public String getInfo() {
        List<RouterStub> stubs = this.stubManager.getStubs();
        if (stubs.isEmpty()) {
            return stubs.toString();
        }
        return "RouterStubs not yet initialized";
    }

    @Override
    protected PhysicalAddress getPhysicalAddress() {
        return this.sock != null ? new IpAddress(this.bind_addr, this.sock.getLocalPort()) : null;
    }

    private class DefaultTUNNELPolicy
    implements TUNNELPolicy {
        private DefaultTUNNELPolicy() {
        }

        @Override
        public void sendToAllMembers(List<RouterStub> stubs, String group, byte[] data, int offset, int length) throws Exception {
            boolean sent = false;
            if (stubs.size() > 1) {
                Collections.shuffle(stubs);
            }
            for (RouterStub stub : stubs) {
                try {
                    if (!stub.isConnected()) continue;
                    stub.sendToAllMembers(group, data, offset, length);
                    if (TUNNEL.this.log.isTraceEnabled()) {
                        TUNNEL.this.log.trace("sent a message to all members, GR used " + stub.getGossipRouterAddress());
                    }
                    sent = true;
                    break;
                }
                catch (Exception e) {
                    if (!TUNNEL.this.log.isWarnEnabled()) continue;
                    TUNNEL.this.log.warn("failed sending a message to all members, GR used " + stub.getGossipRouterAddress());
                }
            }
            if (!sent) {
                throw new Exception("None of the available stubs " + stubs + " accepted a multicast message");
            }
        }

        @Override
        public void sendToSingleMember(List<RouterStub> stubs, String group, Address dest, byte[] data, int offset, int length) throws Exception {
            boolean sent = false;
            if (stubs.size() > 1) {
                Collections.shuffle(stubs);
            }
            for (RouterStub stub : stubs) {
                try {
                    if (!stub.isConnected()) continue;
                    stub.sendToMember(group, dest, data, offset, length);
                    if (TUNNEL.this.log.isDebugEnabled()) {
                        TUNNEL.this.log.debug("sent a message to " + dest + ", GR used " + stub.getGossipRouterAddress());
                    }
                    sent = true;
                    break;
                }
                catch (Exception e) {
                    if (!TUNNEL.this.log.isWarnEnabled()) continue;
                    TUNNEL.this.log.warn("failed sending a message to " + dest + ", GR used " + stub.getGossipRouterAddress());
                }
            }
            if (!sent) {
                throw new Exception("None of the available stubs " + stubs + " accepted a message for dest " + dest);
            }
        }

        @Override
        public void connect(List<RouterStub> stubs, String group, Address addr, String logical_name, List<PhysicalAddress> phys_addrs) {
            for (RouterStub stub : stubs) {
                try {
                    stub.connect(group, addr, logical_name, phys_addrs);
                }
                catch (Exception e) {
                    if (TUNNEL.this.log.isWarnEnabled()) {
                        TUNNEL.this.log.warn("Failed connecting to GossipRouter at " + stub.getGossipRouterAddress());
                    }
                    TUNNEL.this.stubManager.startReconnecting(stub);
                }
            }
        }
    }

    public static interface TUNNELPolicy {
        public void connect(List<RouterStub> var1, String var2, Address var3, String var4, List<PhysicalAddress> var5);

        public void sendToAllMembers(List<RouterStub> var1, String var2, byte[] var3, int var4, int var5) throws Exception;

        public void sendToSingleMember(List<RouterStub> var1, String var2, Address var3, byte[] var4, int var5, int var6) throws Exception;
    }

    public class StubReceiver
    implements Runnable {
        private Thread runner;
        private final RouterStub stub;

        public StubReceiver(RouterStub stub) {
            this.stub = stub;
        }

        public synchronized void setThread(Thread t) {
            this.runner = t;
        }

        public synchronized Thread getThread() {
            return this.runner;
        }

        @Override
        public void run() {
            DataInputStream input = this.stub.getInputStream();
            block7: while (!Thread.currentThread().isInterrupted()) {
                try {
                    GossipData msg = new GossipData();
                    msg.readFrom(input);
                    switch (msg.getType()) {
                        case 16: {
                            break block7;
                        }
                        case 10: {
                            byte[] data = msg.getBuffer();
                            TUNNEL.this.receive(null, data, 0, data.length);
                            break;
                        }
                        case 11: {
                            final Address suspect = Util.readAddress(input);
                            TUNNEL.this.log.debug("Firing suspect event " + suspect + " at " + TUNNEL.this.local_addr);
                            if (suspect != null) {
                                Thread thread = TUNNEL.this.getThreadFactory().newThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        StubReceiver.this.fireSuspectEvent(suspect);
                                    }
                                }, "StubReceiver-suspect");
                                thread.start();
                            } else {
                                break;
                            }
                        }
                    }
                }
                catch (Exception ioe) {
                    if (!this.stub.isConnected()) break;
                }
            }
        }

        private void fireSuspectEvent(Address suspect) {
            TUNNEL.this.up(new Event(9, suspect));
        }
    }

    private class TUNNELStubManager
    extends RouterStubManager {
        TUNNELStubManager(Protocol owner, String channelName, Address logicalAddress, long interval) {
            super(owner, channelName, logicalAddress, interval);
        }

        @Override
        public void connectionStatusChange(RouterStub stub, RouterStub.ConnectionStatus newState) {
            super.connectionStatusChange(stub, newState);
            if (newState == RouterStub.ConnectionStatus.CONNECTED) {
                StubReceiver stubReceiver = new StubReceiver(stub);
                stub.setReceiver(stubReceiver);
                Thread t = TUNNEL.this.global_thread_factory.newThread(stubReceiver, "TUNNEL receiver for " + stub.toString());
                stubReceiver.setThread(t);
                t.setDaemon(true);
                t.start();
            }
        }
    }
}

