/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.sequencer.ddl.dialect.mysql;

import java.util.ArrayList;
import java.util.List;
import org.modeshape.common.text.ParsingException;
import org.modeshape.sequencer.ddl.DdlTokenStream;
import org.modeshape.sequencer.ddl.StandardDdlParser;
import org.modeshape.sequencer.ddl.datatype.DataType;
import org.modeshape.sequencer.ddl.datatype.DataTypeParser;
import org.modeshape.sequencer.ddl.dialect.mysql.MySqlDdlConstants;
import org.modeshape.sequencer.ddl.node.AstNode;

public class MySqlDdlParser
extends StandardDdlParser
implements MySqlDdlConstants,
MySqlDdlConstants.MySqlStatementStartPhrases {
    public static final String ID = "MYSQL";
    static List<String[]> mysqlDataTypeStrings = new ArrayList<String[]>();
    private static final String TERMINATOR = ";";

    public MySqlDdlParser() {
        this.initialize();
    }

    @Override
    public String getId() {
        return ID;
    }

    private void initialize() {
        this.setDatatypeParser(new MySqlDataTypeParser());
        this.setDoUseTerminator(true);
        this.setTerminator(TERMINATOR);
        mysqlDataTypeStrings.addAll(MySqlDdlConstants.MySqlDataTypes.CUSTOM_DATATYPE_START_PHRASES);
    }

    @Override
    protected void initializeTokenStream(DdlTokenStream tokens) {
        super.initializeTokenStream(tokens);
        tokens.registerKeyWords(CUSTOM_KEYWORDS);
        tokens.registerKeyWords(MySqlDdlConstants.MySqlDataTypes.CUSTOM_DATATYPE_START_WORDS);
        tokens.registerStatementStartPhrase(ALTER_PHRASES);
        tokens.registerStatementStartPhrase(CREATE_PHRASES);
        tokens.registerStatementStartPhrase(DROP_PHRASES);
        tokens.registerStatementStartPhrase(MISC_PHRASES);
    }

    @Override
    protected AstNode parseCreateStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_CREATE_INDEX)) {
            return this.parseStatement(tokens, MySqlDdlConstants.MySqlStatementStartPhrases.STMT_CREATE_INDEX, parentNode, "mysqlddl:createIndexStatement");
        }
        if (tokens.matches(STMT_CREATE_UNIQUE_INDEX)) {
            return this.parseStatement(tokens, MySqlDdlConstants.MySqlStatementStartPhrases.STMT_CREATE_UNIQUE_INDEX, parentNode, "mysqlddl:createIndexStatement");
        }
        if (tokens.matches(STMT_CREATE_FUNCTION)) {
            return this.parseStatement(tokens, MySqlDdlConstants.MySqlStatementStartPhrases.STMT_CREATE_FUNCTION, parentNode, "mysqlddl:createFunctionStatement");
        }
        if (tokens.matches(STMT_CREATE_PROCEDURE)) {
            return this.parseStatement(tokens, MySqlDdlConstants.MySqlStatementStartPhrases.STMT_CREATE_PROCEDURE, parentNode, "mysqlddl:createProcedureStatement");
        }
        if (tokens.matches(STMT_CREATE_SERVER)) {
            return this.parseStatement(tokens, MySqlDdlConstants.MySqlStatementStartPhrases.STMT_CREATE_SERVER, parentNode, "mysqlddl:createFunctionStatement");
        }
        if (tokens.matches(STMT_CREATE_TRIGGER)) {
            return this.parseStatement(tokens, MySqlDdlConstants.MySqlStatementStartPhrases.STMT_CREATE_TRIGGER, parentNode, "mysqlddl:createTriggerStatement");
        }
        if (tokens.matches(STMT_CREATE_EVENT)) {
            return this.parseStatement(tokens, MySqlDdlConstants.MySqlStatementStartPhrases.STMT_CREATE_EVENT, parentNode, "mysqlddl:createEventStatement");
        }
        if (tokens.matches(STMT_CREATE_TABLESPACE)) {
            return this.parseStatement(tokens, MySqlDdlConstants.MySqlStatementStartPhrases.STMT_CREATE_TABLESPACE, parentNode, "mysqlddl:createTablespaceStatement");
        }
        if (tokens.matches(STMT_CREATE_DEFINER)) {
            return this.parseStatement(tokens, MySqlDdlConstants.MySqlStatementStartPhrases.STMT_CREATE_DEFINER, parentNode, "mysqlddl:createDefinerStatement");
        }
        return super.parseCreateStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseAlterStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_ALTER_ALGORITHM)) {
            return this.parseStatement(tokens, STMT_ALTER_ALGORITHM, parentNode, "mysqlddl:alterAlgorithmStatement");
        }
        if (tokens.matches(STMT_ALTER_DATABASE)) {
            return this.parseStatement(tokens, STMT_ALTER_DATABASE, parentNode, "mysqlddl:alterDatabaseStatement");
        }
        if (tokens.matches(STMT_ALTER_DEFINER)) {
            return this.parseStatement(tokens, STMT_ALTER_DEFINER, parentNode, "mysqlddl:alterDefinerStatement");
        }
        if (tokens.matches(STMT_ALTER_EVENT)) {
            return this.parseStatement(tokens, STMT_ALTER_EVENT, parentNode, "mysqlddl:alterEventStatement");
        }
        if (tokens.matches(STMT_ALTER_FUNCTION)) {
            return this.parseStatement(tokens, STMT_ALTER_FUNCTION, parentNode, "mysqlddl:alterFunctionStatement");
        }
        if (tokens.matches(STMT_ALTER_LOGFILE_GROUP)) {
            return this.parseStatement(tokens, STMT_ALTER_LOGFILE_GROUP, parentNode, "mysqlddl:alterLogfileGroupStatement");
        }
        if (tokens.matches(STMT_ALTER_PROCEDURE)) {
            return this.parseStatement(tokens, STMT_ALTER_PROCEDURE, parentNode, "mysqlddl:alterProcedureStatement");
        }
        if (tokens.matches(STMT_ALTER_SCHEMA)) {
            return this.parseStatement(tokens, STMT_ALTER_SCHEMA, parentNode, "mysqlddl:alterSchemaStatement");
        }
        if (tokens.matches(STMT_ALTER_SERVER)) {
            return this.parseStatement(tokens, STMT_ALTER_SERVER, parentNode, "mysqlddl:alterServerStatement");
        }
        if (tokens.matches(STMT_ALTER_TABLESPACE)) {
            return this.parseStatement(tokens, STMT_ALTER_TABLESPACE, parentNode, "mysqlddl:alterTablespaceStatement");
        }
        if (tokens.matches(STMT_ALTER_SQL_SECURITY)) {
            return this.parseStatement(tokens, STMT_ALTER_SQL_SECURITY, parentNode, "mysqlddl:alterViewStatement");
        }
        if (tokens.matches(STMT_ALTER_IGNORE_TABLE) || tokens.matches(STMT_ALTER_ONLINE_TABLE) || tokens.matches(STMT_ALTER_ONLINE_IGNORE_TABLE) || tokens.matches(STMT_ALTER_OFFLINE_TABLE) || tokens.matches(STMT_ALTER_OFFLINE_IGNORE_TABLE)) {
            return this.parseAlterTableStatement(tokens, parentNode);
        }
        return super.parseAlterStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseAlterTableStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        return super.parseAlterTableStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseCustomStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_RENAME_DATABASE)) {
            this.markStartOfStatement(tokens);
            tokens.consume(STMT_RENAME_DATABASE);
            String oldName = this.parseName(tokens);
            tokens.consume("TO");
            AstNode node = this.nodeFactory().node(oldName, parentNode, "mysqlddl:renameDatabaseStatement");
            String newName = this.parseName(tokens);
            node.setProperty("ddl:newName", (Object)newName);
            this.markEndOfStatement(tokens, node);
            return node;
        }
        if (tokens.matches(STMT_RENAME_SCHEMA)) {
            this.markStartOfStatement(tokens);
            tokens.consume(STMT_RENAME_SCHEMA);
            String oldName = this.parseName(tokens);
            tokens.consume("TO");
            AstNode node = this.nodeFactory().node(oldName, parentNode, "mysqlddl:renameSchemaStatement");
            String newName = this.parseName(tokens);
            node.setProperty("ddl:newName", (Object)newName);
            this.markEndOfStatement(tokens, node);
            return node;
        }
        if (tokens.matches(STMT_RENAME_TABLE)) {
            this.markStartOfStatement(tokens);
            tokens.consume(STMT_RENAME_TABLE);
            String oldName = this.parseName(tokens);
            tokens.consume("TO");
            String newName = this.parseName(tokens);
            AstNode node = this.nodeFactory().node(oldName, parentNode, "mysqlddl:renameTableStatement");
            node.setProperty("ddl:newName", (Object)newName);
            if (!tokens.matches(",")) {
                this.markEndOfStatement(tokens, node);
                return node;
            }
            ArrayList<AstNode> nodes = new ArrayList<AstNode>();
            nodes.add(node);
            while (tokens.matches(",")) {
                tokens.consume(",");
                oldName = this.parseName(tokens);
                tokens.consume("TO");
                newName = this.parseName(tokens);
                node = this.nodeFactory().node(oldName, parentNode, "mysqlddl:renameTableStatement");
                node.setProperty("ddl:newName", (Object)newName);
                nodes.add(node);
            }
            this.markEndOfStatement(tokens, (AstNode)nodes.get(0));
            String originalExpression = (String)((AstNode)nodes.get(0)).getProperty("ddl:expression");
            Object startLineNumber = ((AstNode)nodes.get(0)).getProperty("ddl:startLineNumber");
            Object startColumnNumber = ((AstNode)nodes.get(0)).getProperty("ddl:startColumnNumber");
            Object startCharIndex = ((AstNode)nodes.get(0)).getProperty("ddl:startCharIndex");
            for (AstNode nextNode : nodes) {
                oldName = nextNode.getName();
                newName = (String)nextNode.getProperty("ddl:newName");
                String express = "RENAME TABLE " + oldName + " " + "TO" + " " + newName + TERMINATOR;
                nextNode.setProperty("ddl:expression", (Object)express);
                nextNode.setProperty("ddl:originalExpression", (Object)originalExpression);
                nextNode.setProperty("ddl:startLineNumber", startLineNumber);
                nextNode.setProperty("ddl:startColumnNumber", startColumnNumber);
                nextNode.setProperty("ddl:startCharIndex", startCharIndex);
            }
            return (AstNode)nodes.get(0);
        }
        return super.parseCustomStatement(tokens, parentNode);
    }

    @Override
    protected AstNode parseDropStatement(DdlTokenStream tokens, AstNode parentNode) throws ParsingException {
        assert (tokens != null);
        assert (parentNode != null);
        if (tokens.matches(STMT_DROP_DATABASE)) {
            return this.parseStatement(tokens, STMT_DROP_DATABASE, parentNode, "mysqlddl:dropDatabaseStatement");
        }
        if (tokens.matches(STMT_DROP_EVENT)) {
            return this.parseStatement(tokens, STMT_DROP_EVENT, parentNode, "mysqlddl:dropEventStatement");
        }
        if (tokens.matches(STMT_DROP_FUNCTION)) {
            return this.parseStatement(tokens, STMT_DROP_FUNCTION, parentNode, "mysqlddl:dropFunctionStatement");
        }
        if (tokens.matches(STMT_DROP_INDEX)) {
            return this.parseStatement(tokens, STMT_DROP_INDEX, parentNode, "mysqlddl:dropIndexStatement");
        }
        if (tokens.matches(STMT_DROP_OFFLINE_INDEX)) {
            return this.parseStatement(tokens, STMT_DROP_OFFLINE_INDEX, parentNode, "mysqlddl:dropIndexStatement");
        }
        if (tokens.matches(STMT_DROP_ONLINE_INDEX)) {
            return this.parseStatement(tokens, STMT_DROP_ONLINE_INDEX, parentNode, "mysqlddl:dropIndexStatement");
        }
        if (tokens.matches(STMT_DROP_LOGFILE_GROUP)) {
            return this.parseStatement(tokens, STMT_DROP_LOGFILE_GROUP, parentNode, "mysqlddl:dropLogfileGroupStatement");
        }
        if (tokens.matches(STMT_DROP_PROCEDURE)) {
            return this.parseStatement(tokens, STMT_DROP_PROCEDURE, parentNode, "mysqlddl:dropProcedureStatement");
        }
        if (tokens.matches(STMT_DROP_SERVER)) {
            return this.parseStatement(tokens, STMT_DROP_SERVER, parentNode, "mysqlddl:dropServerStatement");
        }
        if (tokens.matches(STMT_DROP_TABLESPACE)) {
            return this.parseStatement(tokens, STMT_DROP_TABLESPACE, parentNode, "mysqlddl:dropTablespaceStatement");
        }
        if (tokens.matches(STMT_DROP_TRIGGER)) {
            return this.parseStatement(tokens, STMT_DROP_TRIGGER, parentNode, "mysqlddl:dropTriggerStatement");
        }
        return super.parseDropStatement(tokens, parentNode);
    }

    @Override
    protected List<String> getCustomDataTypeStartWords() {
        return MySqlDdlConstants.MySqlDataTypes.CUSTOM_DATATYPE_START_WORDS;
    }

    class MySqlDataTypeParser
    extends DataTypeParser
    implements MySqlDdlConstants.MySqlDataTypes {
        MySqlDataTypeParser() {
        }

        @Override
        protected boolean isCustomDataType(DdlTokenStream tokens) throws ParsingException {
            for (String[] stmts : mysqlDataTypeStrings) {
                if (!tokens.matches(stmts)) continue;
                return true;
            }
            return super.isCustomDataType(tokens);
        }

        @Override
        protected DataType parseApproxNumericType(DdlTokenStream tokens) throws ParsingException {
            DataType dType = super.parseApproxNumericType(tokens);
            tokens.canConsume("UNSIGNED");
            tokens.canConsume("ZEROFILL");
            tokens.canConsume("UNSIGNED");
            return dType;
        }

        @Override
        protected DataType parseBitStringType(DdlTokenStream tokens) throws ParsingException {
            return super.parseBitStringType(tokens);
        }

        @Override
        protected DataType parseCharStringType(DdlTokenStream tokens) throws ParsingException {
            DataType result = super.parseCharStringType(tokens);
            tokens.canConsume("FOR", new String[]{"BIT", "DATA"});
            return result;
        }

        @Override
        protected DataType parseCustomType(DdlTokenStream tokens) throws ParsingException {
            DataType dataType = null;
            if (tokens.matches(MySqlDdlConstants.DTYPE_FIXED) || tokens.matches(MySqlDdlConstants.DTYPE_DOUBLE)) {
                dataType = new DataType();
                String typeName = tokens.consume();
                dataType.setName(typeName);
                int precision = 0;
                int scale = 0;
                if (tokens.matches("(")) {
                    this.consume(tokens, dataType, false, "(");
                    precision = (int)this.parseLong(tokens, dataType);
                    scale = tokens.canConsume(",") ? (int)this.parseLong(tokens, dataType) : this.getDefaultScale();
                    tokens.consume(")");
                } else {
                    precision = this.getDefaultPrecision();
                    scale = this.getDefaultScale();
                }
                dataType.setPrecision(precision);
                dataType.setScale(scale);
            } else if (tokens.matches(MySqlDdlConstants.DTYPE_MEDIUMBLOB) || tokens.matches(MySqlDdlConstants.DTYPE_LONGBLOB) || tokens.matches(MySqlDdlConstants.DTYPE_BLOB) || tokens.matches(MySqlDdlConstants.DTYPE_TINYBLOB) || tokens.matches(MySqlDdlConstants.DTYPE_YEAR) || tokens.matches(MySqlDdlConstants.DTYPE_DATETIME) || tokens.matches(MySqlDdlConstants.DTYPE_BOOLEAN) || tokens.matches(MySqlDdlConstants.DTYPE_BOOL)) {
                String typeName = tokens.consume();
                dataType = new DataType(typeName);
            } else if (tokens.matches(MySqlDdlConstants.DTYPE_MEDIUMINT) || tokens.matches(MySqlDdlConstants.DTYPE_TINYINT) || tokens.matches(MySqlDdlConstants.DTYPE_VARBINARY) || tokens.matches(MySqlDdlConstants.DTYPE_BINARY) || tokens.matches(MySqlDdlConstants.DTYPE_BIGINT)) {
                String typeName = tokens.consume();
                dataType = new DataType(typeName);
                long length = this.getDefaultLength();
                if (tokens.matches("(")) {
                    length = this.parseBracketedLong(tokens, dataType);
                }
                dataType.setLength(length);
            } else if (tokens.matches(MySqlDdlConstants.DTYPE_NATIONAL_VARCHAR)) {
                String typeName = this.getStatementTypeName(MySqlDdlConstants.DTYPE_NATIONAL_VARCHAR);
                dataType = new DataType(typeName);
                tokens.consume(MySqlDdlConstants.DTYPE_NATIONAL_VARCHAR);
                long length = this.getDefaultLength();
                if (tokens.matches("(")) {
                    length = this.parseBracketedLong(tokens, dataType);
                }
                dataType.setLength(length);
            } else if (tokens.matches(MySqlDdlConstants.DTYPE_MEDIUMTEXT) || tokens.matches(MySqlDdlConstants.DTYPE_TEXT) || tokens.matches(MySqlDdlConstants.DTYPE_LONGTEXT) || tokens.matches(MySqlDdlConstants.DTYPE_TINYTEXT)) {
                String typeName = tokens.consume();
                dataType = new DataType(typeName);
                tokens.canConsume("BINARY");
                tokens.canConsume("COLLATE", new String[]{"any value"});
                tokens.canConsume("CHARACTER", new String[]{"SET", "any value"});
                tokens.canConsume("COLLATE", new String[]{"any value"});
            } else if (tokens.matches(MySqlDdlConstants.DTYPE_SET)) {
                String typeName = tokens.consume();
                dataType = new DataType(typeName);
                tokens.consume("(");
                do {
                    tokens.consume();
                } while (tokens.canConsume(","));
                tokens.consume(")");
                tokens.canConsume("COLLATE", new String[]{"any value"});
                tokens.canConsume("CHARACTER", new String[]{"SET", "any value"});
                tokens.canConsume("COLLATE", new String[]{"any value"});
            } else if (tokens.matches(MySqlDdlConstants.DTYPE_ENUM)) {
                String typeName = tokens.consume();
                dataType = new DataType(typeName);
                tokens.consume("(");
                do {
                    tokens.consume();
                } while (tokens.canConsume(","));
                tokens.consume(")");
                tokens.canConsume("COLLATE", new String[]{"any value"});
                tokens.canConsume("CHARACTER", new String[]{"SET", "any value"});
                tokens.canConsume("COLLATE", new String[]{"any value"});
            }
            if (dataType == null) {
                dataType = super.parseCustomType(tokens);
            }
            tokens.canConsume("UNSIGNED");
            tokens.canConsume("ZEROFILL");
            tokens.canConsume("UNSIGNED");
            return dataType;
        }

        @Override
        protected DataType parseDateTimeType(DdlTokenStream tokens) throws ParsingException {
            return super.parseDateTimeType(tokens);
        }

        @Override
        protected DataType parseExactNumericType(DdlTokenStream tokens) throws ParsingException {
            DataType dType = super.parseExactNumericType(tokens);
            tokens.canConsume("UNSIGNED");
            tokens.canConsume("ZEROFILL");
            tokens.canConsume("UNSIGNED");
            return dType;
        }
    }
}

