/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.backend.impl.blackhole.BlackHoleBackendQueueProcessor;
import org.hibernate.search.backend.impl.jgroups.AutoNodeSelector;
import org.hibernate.search.backend.impl.jgroups.JGroupsBackendQueueProcessor;
import org.hibernate.search.backend.impl.jgroups.MasterNodeSelector;
import org.hibernate.search.backend.impl.jgroups.SlaveNodeSelector;
import org.hibernate.search.backend.impl.jms.JndiJMSBackendQueueProcessor;
import org.hibernate.search.backend.impl.lucene.LuceneBackendQueueProcessor;
import org.hibernate.search.backend.spi.BackendQueueProcessor;
import org.hibernate.search.batchindexing.impl.Executors;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class BackendFactory {
    private static final Log log = LoggerFactory.make();

    public static BackendQueueProcessor createBackend(DirectoryBasedIndexManager indexManager, WorkerBuildContext context, Properties properties) {
        String backend = properties.getProperty("worker.backend");
        return BackendFactory.createBackend(backend, indexManager, context, properties);
    }

    public static BackendQueueProcessor createBackend(String backend, DirectoryBasedIndexManager indexManager, WorkerBuildContext context, Properties properties) {
        BackendQueueProcessor backendQueueProcessor = StringHelper.isEmpty((String)backend) || "lucene".equalsIgnoreCase(backend) ? new LuceneBackendQueueProcessor() : ("jms".equalsIgnoreCase(backend) ? new JndiJMSBackendQueueProcessor() : ("blackhole".equalsIgnoreCase(backend) ? new BlackHoleBackendQueueProcessor() : ("jgroupsMaster".equals(backend) ? new JGroupsBackendQueueProcessor(new MasterNodeSelector()) : ("jgroupsSlave".equals(backend) ? new JGroupsBackendQueueProcessor(new SlaveNodeSelector()) : ("jgroups".equals(backend) ? new JGroupsBackendQueueProcessor(new AutoNodeSelector(indexManager.getIndexName())) : ClassLoaderHelper.instanceFromName(BackendQueueProcessor.class, backend, BackendFactory.class, "processor"))))));
        backendQueueProcessor.initialize(properties, context, indexManager);
        return backendQueueProcessor;
    }

    public static boolean isConfiguredAsSync(Properties properties) {
        return !"async".equalsIgnoreCase(properties.getProperty("worker.execution"));
    }

    public static ExecutorService buildWorkersExecutor(Properties properties, String indexManagerName) {
        int threadPoolSize = BackendFactory.getWorkerThreadPoolSize(properties);
        int queueSize = BackendFactory.getWorkerQueueSize(properties);
        return Executors.newFixedThreadPool(threadPoolSize, "IndexWriter worker executor for " + indexManagerName, queueSize);
    }

    public static int getWorkerThreadPoolSize(Properties properties) {
        return ConfigurationParseHelper.getIntValue(properties, "worker.thread_pool.size", 1);
    }

    public static int getWorkerQueueSize(Properties properties) {
        return ConfigurationParseHelper.getIntValue(properties, "worker.buffer_queue.max", Integer.MAX_VALUE);
    }
}

