/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.IndexReader;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.backend.impl.WorkVisitor;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.DirectoryBasedReaderProvider;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class NRTWorkspaceImpl
extends AbstractWorkspaceImpl
implements DirectoryBasedReaderProvider {
    private static final Log log = LoggerFactory.make();
    private final ReentrantLock writeLock = new ReentrantLock();
    private final AtomicReference<IndexReader> currentReader = new AtomicReference();
    private final FlushStrategySelector flushStrategySelector = new FlushStrategySelector();
    private boolean shutdown = false;
    private final AtomicBoolean needFlushWrites = new AtomicBoolean(true);
    private final AtomicBoolean needFlushDeletes = new AtomicBoolean(false);
    private final AtomicLong readerGeneration = new AtomicLong(0L);
    private long readerGenRequiringFlushDeletes = 0L;
    private volatile long readerGenRequiringFlushWrites = 0L;
    private volatile long currentReaderGen = 0L;

    public NRTWorkspaceImpl(DirectoryBasedIndexManager indexManager, WorkerBuildContext buildContext, Properties cfg) {
        super(indexManager, buildContext, cfg);
    }

    @Override
    public void afterTransactionApplied(boolean someFailureHappened, boolean streaming) {
        if (someFailureHappened) {
            this.writerHolder.forceLockRelease();
        } else if (!streaming) {
            this.setupNewReadersRequirements();
        }
    }

    private void setupNewReadersRequirements() {
        if (this.needFlushDeletes.get() || this.needFlushWrites.get()) {
            long nextGenId = this.readerGeneration.incrementAndGet();
            if (this.needFlushDeletes.get()) {
                this.needFlushDeletes.lazySet(false);
                this.readerGenRequiringFlushDeletes = nextGenId;
            }
            this.needFlushWrites.lazySet(false);
            this.readerGenRequiringFlushWrites = nextGenId;
        }
    }

    private synchronized IndexReader refreshReaders() {
        if (this.indexReaderIsFresh()) {
            return this.currentReader.get();
        }
        long readerGenRequiringFlushWrites = this.readerGenRequiringFlushWrites;
        long readerGenRequiringFlushDeletes = this.readerGenRequiringFlushDeletes;
        boolean flushDeletes = this.currentReaderGen < readerGenRequiringFlushDeletes;
        long openingGen = Math.max(readerGenRequiringFlushDeletes, readerGenRequiringFlushWrites);
        IndexReader newIndexReader = this.writerHolder.openNRTIndexReader(flushDeletes);
        IndexReader oldReader = this.currentReader.getAndSet(newIndexReader);
        this.currentReaderGen = openingGen;
        try {
            if (oldReader != null) {
                oldReader.decRef();
            }
        }
        catch (IOException e) {
            log.unableToCloseLuceneIndexReader(e);
        }
        return newIndexReader;
    }

    private boolean indexReaderIsFresh() {
        long currentReaderGen = this.currentReaderGen;
        return currentReaderGen >= this.readerGenRequiringFlushWrites && currentReaderGen >= this.readerGenRequiringFlushDeletes;
    }

    @Override
    public IndexReader openIndexReader() {
        return this.openIndexReader(!this.indexReaderIsFresh());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexReader openIndexReader(boolean needRefresh) {
        IndexReader indexReader = needRefresh ? this.refreshReaders() : this.currentReader.get();
        if (indexReader == null) {
            this.writeLock.lock();
            try {
                if (this.shutdown) {
                    throw new AssertionFailure("IndexReader requested after ReaderProvider is shutdown");
                }
                indexReader = this.currentReader.get();
                if (indexReader == null) {
                    indexReader = this.writerHolder.openDirectoryIndexReader();
                    this.currentReader.set(indexReader);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        if (indexReader.tryIncRef()) {
            return indexReader;
        }
        return this.openIndexReader(false);
    }

    @Override
    public void closeIndexReader(IndexReader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.decRef();
        }
        catch (IOException e) {
            log.unableToCloseLuceneIndexReader(e);
        }
    }

    @Override
    public void initialize(DirectoryBasedIndexManager indexManager, Properties props) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.writeLock.lock();
        try {
            IndexReader oldReader = this.currentReader.getAndSet(null);
            this.closeIndexReader(oldReader);
            this.shutdown = true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void flush() {
        this.writerHolder.commitIndexWriter();
    }

    @Override
    public void notifyWorkApplied(LuceneWork work) {
        this.incrementModificationCounter();
        work.getWorkDelegate(this.flushStrategySelector).apply(this);
    }

    private static enum FlushStrategyNeed {
        NONE{

            @Override
            void apply(NRTWorkspaceImpl workspace) {
            }
        }
        ,
        FLUSH_DELETIONS{

            @Override
            void apply(NRTWorkspaceImpl workspace) {
                workspace.needFlushDeletes.lazySet(true);
            }
        }
        ,
        FLUSH_WRITES{

            @Override
            void apply(NRTWorkspaceImpl workspace) {
                workspace.needFlushWrites.lazySet(true);
            }
        }
        ,
        FLUSH_WRITES_AND_DELETES{

            @Override
            void apply(NRTWorkspaceImpl workspace) {
                FLUSH_DELETIONS.apply(workspace);
                FLUSH_WRITES.apply(workspace);
            }
        };


        abstract void apply(NRTWorkspaceImpl var1);
    }

    private static class FlushStrategySelector
    implements WorkVisitor<FlushStrategyNeed> {
        private FlushStrategySelector() {
        }

        @Override
        public FlushStrategyNeed getDelegate(AddLuceneWork addLuceneWork) {
            return FlushStrategyNeed.FLUSH_WRITES;
        }

        @Override
        public FlushStrategyNeed getDelegate(DeleteLuceneWork deleteLuceneWork) {
            return FlushStrategyNeed.FLUSH_DELETIONS;
        }

        @Override
        public FlushStrategyNeed getDelegate(OptimizeLuceneWork optimizeLuceneWork) {
            return FlushStrategyNeed.NONE;
        }

        @Override
        public FlushStrategyNeed getDelegate(PurgeAllLuceneWork purgeAllLuceneWork) {
            return FlushStrategyNeed.FLUSH_DELETIONS;
        }

        @Override
        public FlushStrategyNeed getDelegate(UpdateLuceneWork updateLuceneWork) {
            return FlushStrategyNeed.FLUSH_WRITES_AND_DELETES;
        }

        @Override
        public FlushStrategyNeed getDelegate(FlushLuceneWork flushLuceneWork) {
            return FlushStrategyNeed.FLUSH_WRITES_AND_DELETES;
        }
    }
}

