/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest;

import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.query.InvalidQueryException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.codehaus.jettison.json.JSONException;
import org.jboss.resteasy.spi.NotFoundException;
import org.modeshape.web.jcr.NoSuchRepositoryException;
import org.modeshape.web.jcr.rest.handler.AbstractHandler;
import org.modeshape.web.jcr.rest.model.RestException;

@Provider
public class ModeShapeExceptionMapper<T extends Throwable>
implements ExceptionMapper<T> {
    public Response toResponse(T throwable) {
        AbstractHandler.cleanupActiveSession();
        if (throwable instanceof NotFoundException || throwable instanceof PathNotFoundException || throwable instanceof NoSuchWorkspaceException || throwable instanceof NoSuchRepositoryException || throwable instanceof NoSuchNodeTypeException) {
            return this.exceptionResponse((Throwable)throwable, Response.Status.NOT_FOUND);
        }
        if (throwable instanceof JSONException || throwable instanceof InvalidQueryException || throwable instanceof RepositoryException || throwable instanceof IllegalArgumentException) {
            return this.exceptionResponse((Throwable)throwable, Response.Status.BAD_REQUEST);
        }
        return this.exceptionResponse((Throwable)throwable, Response.Status.INTERNAL_SERVER_ERROR);
    }

    private Response exceptionResponse(Throwable t, Response.Status status) {
        return Response.status((Response.Status)status).entity((Object)new RestException(t)).build();
    }
}

