/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.cache.document;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jcr.RepositoryException;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.text.Inflector;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.Connectors;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.cache.CachedNode;
import org.modeshape.jcr.cache.ChildReference;
import org.modeshape.jcr.cache.ChildReferences;
import org.modeshape.jcr.cache.MutableCachedNode;
import org.modeshape.jcr.cache.NodeCache;
import org.modeshape.jcr.cache.NodeKey;
import org.modeshape.jcr.cache.NodeNotFoundException;
import org.modeshape.jcr.cache.NodeNotFoundInParentException;
import org.modeshape.jcr.cache.PathCache;
import org.modeshape.jcr.cache.SessionCache;
import org.modeshape.jcr.cache.WrappedException;
import org.modeshape.jcr.cache.document.AbstractSessionCache;
import org.modeshape.jcr.cache.document.DocumentCache;
import org.modeshape.jcr.cache.document.DocumentStore;
import org.modeshape.jcr.cache.document.MutableChildReferences;
import org.modeshape.jcr.cache.document.PatternIterator;
import org.modeshape.jcr.cache.document.SessionChildReferences;
import org.modeshape.jcr.cache.document.UnionIterator;
import org.modeshape.jcr.cache.document.WorkspaceCache;
import org.modeshape.jcr.cache.document.WritableSessionCache;
import org.modeshape.jcr.value.BinaryValue;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.NameFactory;
import org.modeshape.jcr.value.NamespaceRegistry;
import org.modeshape.jcr.value.Path;
import org.modeshape.jcr.value.Property;
import org.modeshape.jcr.value.PropertyFactory;
import org.modeshape.jcr.value.Reference;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.basic.NodeKeyReference;
import org.modeshape.jcr.value.basic.StringReference;
import org.modeshape.jcr.value.basic.UuidReference;
import org.modeshape.jcr.value.binary.ExternalBinaryValue;

@ThreadSafe
public class SessionNode
implements MutableCachedNode {
    private final NodeKey key;
    private final ConcurrentMap<Name, Property> changedProperties = new ConcurrentHashMap<Name, Property>();
    private final ConcurrentMap<Name, Name> removedProperties = new ConcurrentHashMap<Name, Name>();
    private final AtomicReference<FederatedSegmentChanges> federatedSegments = new AtomicReference();
    private volatile NodeKey newParent;
    private final AtomicReference<ChangedAdditionalParents> additionalParents = new AtomicReference();
    private final ChangedChildren changedChildren = new ChangedChildren();
    private final AtomicReference<MutableChildReferences> appended = new AtomicReference();
    private final AtomicReference<MixinChanges> mixinChanges = new AtomicReference();
    private final AtomicReference<ReferrerChanges> referrerChanges = new AtomicReference();
    private final AtomicReference<Boolean> isQueryable = new AtomicReference();
    private final boolean isNew;
    private volatile LockChange lockChange;

    public SessionNode(NodeKey key, boolean isNew) {
        this.key = key;
        this.isNew = isNew;
        assert (this.key != null);
    }

    protected final ChangedChildren changedChildren() {
        return this.changedChildren;
    }

    protected final Set<Name> removedProperties() {
        return this.removedProperties.keySet();
    }

    protected final ConcurrentMap<Name, Property> changedProperties() {
        return this.changedProperties;
    }

    protected final NodeKey newParent() {
        return this.newParent;
    }

    @Override
    public final boolean isNew() {
        return this.isNew;
    }

    @Override
    public final boolean isPropertyNew(SessionCache cache, Name propertyName) {
        return this.isNew || this.changedProperties.containsKey(propertyName) && !this.isPropertyInWorkspaceCache(cache, propertyName);
    }

    @Override
    public final boolean isPropertyModified(SessionCache cache, Name propertyName) {
        return !this.isNew && this.changedProperties.containsKey(propertyName) && this.isPropertyInWorkspaceCache(cache, propertyName);
    }

    private boolean isPropertyInWorkspaceCache(SessionCache cache, Name propertyName) {
        AbstractSessionCache session = this.session(cache);
        CachedNode raw = this.nodeInWorkspace(session);
        if (raw == null) {
            return false;
        }
        WorkspaceCache workspaceCache = this.workspace(cache);
        return raw.hasProperty(propertyName, workspaceCache);
    }

    @Override
    public boolean hasChanges() {
        return this.hasPropertyChanges() || this.hasNonPropertyChanges();
    }

    @Override
    public boolean hasNonPropertyChanges() {
        if (this.isNew) {
            return true;
        }
        if (this.newParent != null) {
            return true;
        }
        ChangedChildren changedChildren = this.changedChildren();
        if (changedChildren != null && !changedChildren.isEmpty()) {
            return true;
        }
        MutableChildReferences childRefChanges = this.appended(false);
        if (childRefChanges != null && !childRefChanges.isEmpty()) {
            return true;
        }
        ChangedAdditionalParents additionalParents = this.additionalParents();
        if (additionalParents != null && !additionalParents.isEmpty()) {
            return true;
        }
        ReferrerChanges referrerChanges = this.referrerChanges(false);
        return referrerChanges != null && !referrerChanges.isEmpty();
    }

    @Override
    public boolean hasPropertyChanges() {
        if (this.isNew) {
            return true;
        }
        if (!this.changedProperties.isEmpty()) {
            return true;
        }
        return !this.removedProperties.isEmpty();
    }

    @Override
    public boolean hasIndexRelatedChanges() {
        if (this.isNew) {
            return true;
        }
        if (this.newParent != null) {
            return true;
        }
        ChangedAdditionalParents additionalParents = this.additionalParents();
        if (additionalParents != null && !additionalParents.isEmpty()) {
            return true;
        }
        return this.hasPropertyChanges();
    }

    @Override
    public void lock(boolean sessionScoped) {
        this.lockChange = sessionScoped ? LockChange.LOCK_FOR_SESSION : LockChange.LOCK_FOR_NON_SESSION;
    }

    @Override
    public void unlock() {
        this.lockChange = LockChange.UNLOCK;
    }

    public LockChange getLockChange() {
        return this.lockChange;
    }

    private boolean addAdditionalParent(NodeCache cache, NodeKey newParent) {
        assert (newParent != null);
        if (newParent.equals(this.newParent)) {
            return false;
        }
        NodeKey existingParentKey = this.getParentKey(cache);
        if (newParent.equals(existingParentKey)) {
            return false;
        }
        ChangedAdditionalParents additionalParents = this.additionalParents.get();
        if (additionalParents == null && !this.additionalParents.compareAndSet(null, additionalParents = new ChangedAdditionalParents())) {
            additionalParents = this.additionalParents.get();
        }
        return additionalParents.add(newParent);
    }

    private boolean removeAdditionalParent(NodeCache cache, NodeKey oldParent) {
        if (this.getAdditionalParentKeys(cache).contains(oldParent)) {
            ChangedAdditionalParents additionalParents = this.additionalParents.get();
            if (additionalParents == null && !this.additionalParents.compareAndSet(null, additionalParents = new ChangedAdditionalParents())) {
                additionalParents = this.additionalParents.get();
            }
            return additionalParents.remove(oldParent);
        }
        return false;
    }

    protected void replaceParentWithAdditionalParent(NodeCache cache, NodeKey oldParent, NodeKey existingAdditionalParent) {
        assert (this.getAdditionalParentKeys(cache).contains(existingAdditionalParent));
        this.newParent = existingAdditionalParent;
        ChangedAdditionalParents additionalParents = this.additionalParents.get();
        if (additionalParents == null && !this.additionalParents.compareAndSet(null, additionalParents = new ChangedAdditionalParents())) {
            additionalParents = this.additionalParents.get();
        }
        additionalParents.remove(existingAdditionalParent);
        additionalParents.remove(oldParent);
    }

    protected MutableChildReferences appended(boolean createIfMissing) {
        MutableChildReferences appended = this.appended.get();
        if (appended == null && createIfMissing && !this.appended.compareAndSet(null, appended = new MutableChildReferences())) {
            appended = this.appended.get();
        }
        return appended;
    }

    protected MixinChanges mixinChanges(boolean createIfMissing) {
        MixinChanges changes = this.mixinChanges.get();
        if (changes == null && createIfMissing && !this.mixinChanges.compareAndSet(null, changes = new MixinChanges())) {
            changes = this.mixinChanges.get();
        }
        return changes;
    }

    protected ReferrerChanges referrerChanges(boolean createIfMissing) {
        ReferrerChanges changes = this.referrerChanges.get();
        if (changes == null && createIfMissing && !this.referrerChanges.compareAndSet(null, changes = new ReferrerChanges())) {
            changes = this.referrerChanges.get();
        }
        return changes;
    }

    protected final WritableSessionCache writableSession(NodeCache cache) {
        return (WritableSessionCache)cache.unwrap();
    }

    protected final AbstractSessionCache session(NodeCache cache) {
        return (AbstractSessionCache)cache.unwrap();
    }

    protected final WorkspaceCache workspace(NodeCache cache) {
        return ((DocumentCache)cache.unwrap()).workspaceCache();
    }

    protected CachedNode nodeInWorkspace(AbstractSessionCache session) {
        return this.isNew() ? null : session.getWorkspace().getNode(this.key);
    }

    @Override
    public NodeKey getParentKey(NodeCache cache) {
        if (this.newParent != null) {
            return this.newParent;
        }
        CachedNode cachedNode = this.nodeInWorkspace(this.session(cache));
        return cachedNode != null ? cachedNode.getParentKey(cache) : null;
    }

    @Override
    public NodeKey getParentKeyInAnyWorkspace(NodeCache cache) {
        if (this.newParent != null) {
            return this.newParent;
        }
        CachedNode cachedNode = this.nodeInWorkspace(this.session(cache));
        return cachedNode != null ? cachedNode.getParentKeyInAnyWorkspace(cache) : null;
    }

    protected CachedNode parent(AbstractSessionCache session) {
        NodeKey parentKey = this.getParentKey(session);
        if (parentKey == null) {
            return null;
        }
        return session.getNode(parentKey);
    }

    protected ChangedAdditionalParents additionalParents() {
        return this.additionalParents.get();
    }

    @Override
    public Set<NodeKey> getAdditionalParentKeys(NodeCache cache) {
        AbstractSessionCache session = this.session(cache);
        CachedNode raw = this.nodeInWorkspace(session);
        Set<NodeKey> persisted = raw != null ? raw.getAdditionalParentKeys(cache) : null;
        ChangedAdditionalParents additionalParents = this.additionalParents.get();
        if (additionalParents == null || additionalParents.isEmpty()) {
            return persisted != null ? persisted : Collections.emptySet();
        }
        LinkedHashSet<NodeKey> copy = persisted != null ? new LinkedHashSet<NodeKey>(persisted) : new LinkedHashSet();
        copy.addAll(additionalParents.getAdditions());
        copy.removeAll(additionalParents.getRemovals());
        return Collections.unmodifiableSet(copy);
    }

    @Override
    public boolean hasOnlyChangesToAdditionalParents() {
        if (this.isNew) {
            return false;
        }
        if (this.newParent != null) {
            return false;
        }
        if (!this.changedProperties.isEmpty()) {
            return false;
        }
        if (!this.removedProperties.isEmpty()) {
            return false;
        }
        ChangedChildren changedChildren = this.changedChildren();
        if (changedChildren != null && !changedChildren.isEmpty()) {
            return false;
        }
        MutableChildReferences childRefChanges = this.appended(false);
        if (childRefChanges != null && !childRefChanges.isEmpty()) {
            return false;
        }
        ChangedAdditionalParents additionalParents = this.additionalParents();
        return additionalParents != null && !additionalParents.isEmpty();
    }

    @Override
    public boolean isAtOrBelow(NodeCache cache, Path path) {
        Path aPath = this.getPath(cache);
        if (path.isAtOrAbove(aPath)) {
            return true;
        }
        ChangedAdditionalParents additionalParents = this.additionalParents();
        if (additionalParents != null && !additionalParents.isEmpty()) {
            CachedNode parent;
            for (NodeKey parentKey : additionalParents.getAdditions()) {
                parent = cache.getNode(parentKey);
                if (!parent.getPath(cache).isAtOrBelow(path)) continue;
                return true;
            }
            for (NodeKey parentKey : additionalParents.getRemovals()) {
                parent = cache.getNode(parentKey);
                if (parent == null || !parent.getPath(cache).isAtOrBelow(path)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public NodeKey getKey() {
        return this.key;
    }

    @Override
    public Name getName(NodeCache cache) {
        return this.getSegment(cache).getName();
    }

    @Override
    public Path.Segment getSegment(NodeCache cache) {
        AbstractSessionCache session = this.session(cache);
        CachedNode parent = this.parent(session);
        return this.getSegment(cache, parent);
    }

    protected final Path.Segment getSegment(NodeCache cache, CachedNode parent) {
        if (parent != null) {
            ChildReference ref = parent.getChildReferences(cache).getChild(this.key, new ChildReferences.BasicContext());
            if (ref == null) {
                throw new NodeNotFoundInParentException(this.key, parent.getKey());
            }
            return ref.getSegment();
        }
        return this.workspace(cache).childReferenceForRoot().getSegment();
    }

    @Override
    public Path getPath(NodeCache cache) {
        AbstractSessionCache session = this.session(cache);
        CachedNode parent = this.parent(session);
        if (parent != null) {
            Path parentPath = parent.getPath(session);
            return session.pathFactory().create(parentPath, this.getSegment(session, parent));
        }
        CachedNode persistedNode = this.workspace(cache).getNode(this.key);
        if (persistedNode == null) {
            throw new NodeNotFoundException(this.key);
        }
        return session.rootPath();
    }

    @Override
    public Path getPath(PathCache pathCache) throws NodeNotFoundException {
        NodeCache cache = pathCache.getCache();
        AbstractSessionCache session = this.session(cache);
        CachedNode parent = this.parent(session);
        if (parent != null) {
            Path parentPath = pathCache.getPath(parent);
            return session.pathFactory().create(parentPath, this.getSegment(session, parent));
        }
        CachedNode persistedNode = this.workspace(cache).getNode(this.key);
        if (persistedNode == null) {
            throw new NodeNotFoundException(this.key);
        }
        return session.rootPath();
    }

    @Override
    public Name getPrimaryType(NodeCache cache) {
        AbstractSessionCache session = this.session(cache);
        Property prop = this.getProperty(JcrLexicon.PRIMARY_TYPE, session);
        NameFactory nameFactory = session.nameFactory();
        return prop != null ? (Name)nameFactory.create(prop.getFirstValue()) : (Name)nameFactory.create((Object)null);
    }

    @Override
    public boolean hasChangedPrimaryType() {
        return this.changedProperties.containsKey(JcrLexicon.PRIMARY_TYPE);
    }

    @Override
    public Set<Name> getMixinTypes(NodeCache cache) {
        AbstractSessionCache session = this.session(cache);
        Property prop = this.getProperty(JcrLexicon.MIXIN_TYPES, session);
        MixinChanges changes = this.mixinChanges(false);
        if (prop == null || prop.size() == 0) {
            return changes != null ? changes.getAdded() : Collections.emptySet();
        }
        NameFactory nameFactory = session.nameFactory();
        if (prop.size() == 1) {
            Name name = (Name)nameFactory.create(prop.getFirstValue());
            if (changes == null) {
                return Collections.singleton(name);
            }
            HashSet<Name> all = new HashSet<Name>(changes.getAdded());
            all.add(name);
            all.removeAll(changes.getRemoved());
            return all;
        }
        HashSet<Name> names = new HashSet<Name>();
        for (Object value : prop) {
            Name name = (Name)nameFactory.create(value);
            if (changes != null && changes.getRemoved().contains(name)) continue;
            names.add(name);
        }
        if (changes != null) {
            names.addAll(changes.getAdded());
        }
        return names;
    }

    @Override
    public void addMixin(SessionCache cache, Name mixinName) {
        assert (mixinName != null);
        if (this.isNew) {
            Property mixinTypes = cache.getContext().getPropertyFactory().create(JcrLexicon.MIXIN_TYPES, new Name[]{mixinName});
            Property existing = this.changedProperties().putIfAbsent(mixinTypes.getName(), mixinTypes);
            while (existing != null) {
                ArrayList<Object> values = new ArrayList<Object>(existing.size());
                for (Object value : existing) {
                    if (mixinName.equals(value)) {
                        return;
                    }
                    values.add(value);
                }
                values.add(mixinName);
                mixinTypes = cache.getContext().getPropertyFactory().create(JcrLexicon.MIXIN_TYPES, values);
                Property existing2 = this.changedProperties().put(mixinTypes.getName(), mixinTypes);
                if (existing2 == existing) {
                    existing = null;
                    continue;
                }
                existing = existing2;
            }
        } else {
            this.mixinChanges(true).add(mixinName);
        }
    }

    @Override
    public void removeMixin(SessionCache cache, Name mixinName) {
        if (this.isNew) {
            Property existing = (Property)this.changedProperties().get(JcrLexicon.MIXIN_TYPES);
            while (existing != null) {
                ArrayList values = new ArrayList(existing.size());
                boolean found = false;
                for (Object value : existing) {
                    if (mixinName.equals(value)) {
                        found = true;
                        continue;
                    }
                    values.add(value);
                }
                if (!found) {
                    return;
                }
                Property mixinTypes = cache.getContext().getPropertyFactory().create(JcrLexicon.MIXIN_TYPES, values);
                Property existing2 = this.changedProperties().put(mixinTypes.getName(), mixinTypes);
                if (existing2 == existing) {
                    existing = null;
                    continue;
                }
                existing = existing2;
            }
        } else {
            this.mixinChanges(true).remove(mixinName);
        }
    }

    public MixinChanges getMixinChanges() {
        return this.mixinChanges(false);
    }

    @Override
    public Set<Name> getAddedMixins(SessionCache cache) {
        if (!this.isNew()) {
            MixinChanges mixinChanges = this.mixinChanges(false);
            if (mixinChanges != null) {
                return mixinChanges.getAdded();
            }
            return Collections.emptySet();
        }
        Property prop = (Property)this.changedProperties.get(JcrLexicon.MIXIN_TYPES);
        if (prop == null || prop.size() == 0) {
            return Collections.emptySet();
        }
        NameFactory nameFactory = this.session(cache).nameFactory();
        HashSet<Name> names = new HashSet<Name>();
        for (Object value : prop) {
            Name name = (Name)nameFactory.create(value);
            names.add(name);
        }
        return names;
    }

    @Override
    public Set<NodeKey> getReferrers(NodeCache cache, CachedNode.ReferenceType type) {
        AbstractSessionCache session = this.session(cache);
        ReferrerChanges changes = this.referrerChanges(false);
        CachedNode persisted = this.nodeInWorkspace(session);
        if (persisted == null) {
            if (changes == null) {
                return Collections.emptySet();
            }
            return new HashSet<NodeKey>(changes.getAddedReferrers(type));
        }
        Set<NodeKey> referrers = persisted.getReferrers(this.workspace(cache), type);
        if (changes != null) {
            referrers.addAll(changes.getAddedReferrers(type));
            referrers.removeAll(changes.getRemovedReferrers(type));
        }
        return referrers;
    }

    protected ReferrerChanges getReferrerChanges() {
        return this.referrerChanges(false);
    }

    @Override
    public void addReferrer(SessionCache cache, NodeKey referrerKey, CachedNode.ReferenceType type) {
        ReferrerChanges changes = this.referrerChanges(true);
        switch (type) {
            case WEAK: {
                changes.addWeakReferrer(referrerKey);
                break;
            }
            case STRONG: {
                changes.addStrongReferrer(referrerKey);
                break;
            }
            case BOTH: {
                throw new IllegalArgumentException("The type parameter may be WEAK or STRONG, but may not be BOTH");
            }
        }
    }

    @Override
    public void removeReferrer(SessionCache cache, NodeKey referrerKey, CachedNode.ReferenceType type) {
        ReferrerChanges changes = this.referrerChanges(true);
        switch (type) {
            case WEAK: {
                changes.removeWeakReferrer(referrerKey);
                break;
            }
            case STRONG: {
                changes.removeStrongReferrer(referrerKey);
                break;
            }
            case BOTH: {
                throw new IllegalArgumentException("The type parameter may be WEAK or STRONG, but may not be BOTH");
            }
        }
    }

    @Override
    public int getPropertyCount(NodeCache cache) {
        int count = this.changedProperties.size() - this.removedProperties.size();
        AbstractSessionCache session = this.session(cache);
        CachedNode raw = this.nodeInWorkspace(session);
        return raw != null ? count + raw.getPropertyCount(session) : count;
    }

    @Override
    public boolean hasProperties(NodeCache cache) {
        if (!this.changedProperties.isEmpty()) {
            return true;
        }
        AbstractSessionCache session = this.session(cache);
        CachedNode raw = this.nodeInWorkspace(session);
        return raw != null ? raw.hasProperties(session) : false;
    }

    @Override
    public boolean hasProperty(Name name, NodeCache cache) {
        if (this.changedProperties.containsKey(name)) {
            return true;
        }
        if (this.isPropertyRemoved(name)) {
            return false;
        }
        AbstractSessionCache session = this.session(cache);
        CachedNode raw = this.nodeInWorkspace(session);
        return raw != null ? raw.hasProperty(name, session) : false;
    }

    @Override
    public Property getProperty(Name name, NodeCache cache) {
        Property prop = null;
        prop = (Property)this.changedProperties.get(name);
        if (prop != null) {
            return prop;
        }
        if (this.isPropertyRemoved(name)) {
            return null;
        }
        AbstractSessionCache session = this.session(cache);
        CachedNode raw = this.nodeInWorkspace(session);
        return raw != null ? raw.getProperty(name, session) : null;
    }

    protected final boolean isPropertyRemoved(Name name) {
        return !this.isNew && this.removedProperties.containsKey(name);
    }

    @Override
    public Iterator<Property> getProperties(final NodeCache cache) {
        AbstractSessionCache session = this.session(cache);
        final CachedNode raw = this.nodeInWorkspace(session);
        final ConcurrentMap<Name, Property> changedProperties = this.changedProperties;
        Iterable<Property> rawProps = raw == null ? null : new Iterable<Property>(){

            @Override
            public Iterator<Property> iterator() {
                LinkedList<Property> values = new LinkedList<Property>();
                Iterator<Property> iter = raw.getProperties(SessionNode.this.workspace(cache));
                while (iter.hasNext()) {
                    Property prop = iter.next();
                    if (SessionNode.this.isPropertyRemoved(prop.getName()) || changedProperties.containsKey(prop.getName())) continue;
                    values.add(prop);
                }
                return values.iterator();
            }
        };
        return new UnionIterator<Property>(changedProperties.values().iterator(), rawProps);
    }

    @Override
    public Iterator<Property> getProperties(Collection<?> namePatterns, NodeCache cache) {
        AbstractSessionCache session = this.session(cache);
        final NamespaceRegistry registry = session.context().getNamespaceRegistry();
        return new PatternIterator<Property>(this.getProperties(session), namePatterns){

            @Override
            protected String matchable(Property value) {
                return value.getName().getString(registry);
            }
        };
    }

    @Override
    public void setProperty(SessionCache cache, Property property) {
        this.writableSession(cache).assertInSession(this);
        Name name = property.getName();
        this.changedProperties.put(name, property);
        if (!this.isNew) {
            this.removedProperties.remove(name);
        }
        this.updateReferences(cache, name, null);
    }

    @Override
    public void setReference(SessionCache cache, Property property, SessionCache systemCache) {
        assert (property.isEmpty() || property.isReference());
        this.writableSession(cache).assertInSession(this);
        Name name = property.getName();
        this.changedProperties.put(name, property);
        if (!this.isNew) {
            this.removedProperties.remove(name);
        }
        this.updateReferences(cache, name, systemCache);
    }

    private void updateReferences(SessionCache cache, Name propertyName, SessionCache systemCache) {
        CachedNode persistedNode;
        Property oldProperty;
        boolean oldPropertyWasReference = false;
        ArrayList<Reference> referencesToRemove = new ArrayList<Reference>();
        if ((this.isPropertyModified(cache, propertyName) || this.isPropertyRemoved(propertyName)) && (oldProperty = (persistedNode = this.nodeInWorkspace(this.session(cache))).getProperty(propertyName, cache)) != null && oldProperty.isReference()) {
            oldPropertyWasReference = true;
            for (Object referenceObject : oldProperty.getValuesAsArray()) {
                assert (referenceObject instanceof Reference);
                referencesToRemove.add((Reference)referenceObject);
            }
        }
        boolean updatedPropertyIsReference = false;
        ArrayList<Reference> referencesToAdd = new ArrayList<Reference>();
        Property property = (Property)this.changedProperties.get(propertyName);
        if (property != null && property.isReference()) {
            updatedPropertyIsReference = true;
            for (Object referenceObject : property.getValuesAsArray()) {
                assert (referenceObject instanceof Reference);
                Reference updatedReference = (Reference)referenceObject;
                if (referencesToRemove.contains(updatedReference)) {
                    referencesToRemove.remove(updatedReference);
                    continue;
                }
                referencesToAdd.add(updatedReference);
            }
        }
        if (referencesToRemove.isEmpty() && referencesToAdd.isEmpty() && oldPropertyWasReference && updatedPropertyIsReference) {
            this.changedProperties.remove(propertyName);
            return;
        }
        if (!referencesToRemove.isEmpty()) {
            this.addOrRemoveReferrers(cache, systemCache, referencesToRemove.iterator(), false);
        }
        if (!referencesToAdd.isEmpty()) {
            this.addOrRemoveReferrers(cache, systemCache, referencesToAdd.iterator(), true);
        }
    }

    protected void removeAllReferences(SessionCache cache) {
        Iterator<Property> it = this.getProperties(cache);
        while (it.hasNext()) {
            Property property = it.next();
            if (!property.isReference()) continue;
            this.addOrRemoveReferrers(cache, null, property.getValues(), false);
        }
    }

    protected void addOrRemoveReferrers(SessionCache cache, SessionCache systemCache, Iterator<?> referenceValuesIterator, boolean add) {
        boolean isFrozenNode = JcrNtLexicon.FROZEN_NODE.equals(this.getPrimaryType(cache));
        while (referenceValuesIterator.hasNext()) {
            CachedNode.ReferenceType referenceType;
            Object value = referenceValuesIterator.next();
            assert (value instanceof Reference);
            Reference reference = (Reference)value;
            NodeKey referredKey = this.nodeKeyFromReference(reference);
            boolean isWeak = reference.isWeak();
            if (isFrozenNode && !isWeak) {
                return;
            }
            SessionNode referredNode = null;
            if (cache.getNode(referredKey) != null) {
                referredNode = this.writableSession(cache).mutable(referredKey);
            } else if (systemCache != null && systemCache.getNode(referredKey) != null) {
                referredNode = this.writableSession(systemCache).mutable(referredKey);
            }
            if (referredNode == null) continue;
            CachedNode.ReferenceType referenceType2 = referenceType = isWeak ? CachedNode.ReferenceType.WEAK : CachedNode.ReferenceType.STRONG;
            if (add) {
                referredNode.addReferrer(cache, this.key, referenceType);
                continue;
            }
            referredNode.removeReferrer(cache, this.key, referenceType);
        }
    }

    private NodeKey nodeKeyFromReference(Reference reference) {
        if (reference instanceof NodeKeyReference) {
            return ((NodeKeyReference)reference).getNodeKey();
        }
        if (reference instanceof StringReference) {
            return new NodeKey(reference.getString());
        }
        if (reference instanceof UuidReference) {
            UuidReference uuidReference = (UuidReference)reference;
            return this.getKey().withId(uuidReference.getString());
        }
        throw new IllegalArgumentException("Unknown reference type: " + reference.getClass().getSimpleName());
    }

    @Override
    public void setPropertyIfUnchanged(SessionCache cache, Property property) {
        boolean isModified;
        Name propertyName = property.getName();
        boolean bl = isModified = this.changedProperties.containsKey(propertyName) && (this.isNew || this.isPropertyInWorkspaceCache(cache, propertyName));
        if (!isModified) {
            this.setProperty(cache, property);
        }
    }

    @Override
    public void setProperties(SessionCache cache, Iterable<Property> properties) {
        this.writableSession(cache).assertInSession(this);
        for (Property property : properties) {
            Name name = property.getName();
            this.changedProperties.put(name, property);
            if (!this.isNew) {
                this.removedProperties.remove(name);
            }
            this.updateReferences(cache, name, null);
        }
    }

    @Override
    public void setProperties(SessionCache cache, Iterator<Property> properties) {
        this.writableSession(cache).assertInSession(this);
        while (properties.hasNext()) {
            Property property = properties.next();
            Name name = property.getName();
            this.changedProperties.put(name, property);
            if (!this.isNew) {
                this.removedProperties.remove(name);
            }
            this.updateReferences(cache, name, null);
        }
    }

    @Override
    public void removeProperty(SessionCache cache, Name name) {
        AbstractSessionCache session;
        CachedNode raw;
        this.writableSession(cache).assertInSession(this);
        this.changedProperties.remove(name);
        if (!this.isNew && (raw = this.nodeInWorkspace(session = this.session(cache))).hasProperty(name, cache)) {
            this.removedProperties.put(name, name);
        }
        this.updateReferences(cache, name, null);
    }

    @Override
    public void removeAllProperties(SessionCache cache) {
        this.writableSession(cache).assertInSession(this);
        CachedNode raw = null;
        Iterator<Property> propertyIterator = this.getProperties(cache);
        while (propertyIterator.hasNext()) {
            Name name = propertyIterator.next().getName();
            this.changedProperties.remove(name);
            if (!this.isNew) {
                if (raw == null) {
                    AbstractSessionCache session = this.session(cache);
                    raw = this.nodeInWorkspace(session);
                }
                if (raw.hasProperty(name, cache)) {
                    this.removedProperties.put(name, name);
                }
            }
            this.updateReferences(cache, name, null);
        }
    }

    @Override
    public ChildReferences getChildReferences(NodeCache cache) {
        if (this.isNew) {
            return new SessionChildReferences(null, this.appended.get(), this.changedChildren);
        }
        CachedNode persistedNode = this.nodeInWorkspace(this.session(cache));
        ChildReferences persisted = persistedNode != null ? persistedNode.getChildReferences(cache) : null;
        return new SessionChildReferences(persisted, this.appended.get(), this.changedChildren);
    }

    @Override
    public MutableCachedNode createChild(SessionCache cache, NodeKey key, Name name, Property firstProperty, Property ... additionalProperties) {
        WritableSessionCache session = this.writableSession(cache);
        session.assertInSession(this);
        if (key == null) {
            key = this.getKey().withRandomId();
        }
        SessionNode child = new SessionNode(key, true);
        child = session.add(child);
        if (firstProperty != null) {
            child.setProperty(cache, firstProperty);
        }
        if (additionalProperties != null) {
            for (Property property : additionalProperties) {
                if (property == null) continue;
                child.setProperty(cache, property);
            }
        }
        child.newParent = this.key;
        this.appended(true).append(key, name);
        return child;
    }

    @Override
    public MutableCachedNode createChild(SessionCache cache, NodeKey key, Name name, Iterable<Property> properties) {
        WritableSessionCache session = this.writableSession(cache);
        session.assertInSession(this);
        if (key == null) {
            key = this.getKey().withRandomId();
        }
        SessionNode child = new SessionNode(key, true);
        child = session.add(child);
        if (properties != null) {
            for (Property property : properties) {
                if (property == null) continue;
                child.setProperty(cache, property);
            }
        }
        child.newParent = this.key;
        this.appended(true).append(key, name);
        return child;
    }

    @Override
    public void removeChild(SessionCache cache, NodeKey key) {
        WritableSessionCache session = this.writableSession(cache);
        session.assertInSession(this);
        this.removeChildFromNode(session, key);
    }

    @Override
    public void moveChild(SessionCache cache, NodeKey key, MutableCachedNode newParent, Name newName) {
        assert (newParent != this);
        assert (newParent != null);
        WritableSessionCache session = this.writableSession(cache);
        session.assertInSession(this);
        SessionNode node = this.removeChildFromNode(session, key);
        if (newName == null) {
            newName = node.getName(session);
        }
        ((SessionNode)newParent).appended(true).append(key, newName);
        node.newParent = newParent.getKey();
    }

    protected SessionNode removeChildFromNode(AbstractSessionCache session, NodeKey childKey) {
        SessionNode child = session.mutable(childKey);
        if (child.getParentKey(session).equals(this.key)) {
            Set<NodeKey> additionalParentKeys = child.getAdditionalParentKeys(session);
            if (additionalParentKeys.isEmpty()) {
                child.newParent = null;
            } else {
                NodeKey newParentKey = additionalParentKeys.iterator().next();
                child.replaceParentWithAdditionalParent(session, this.key, newParentKey);
            }
        } else {
            boolean removed = child.removeAdditionalParent(session, this.key);
            if (!removed && !this.getChildReferences(session).hasChild(childKey)) {
                throw new NodeNotFoundException(childKey);
            }
        }
        MutableChildReferences appended = this.appended.get();
        ChildReference removed = null;
        if (appended != null) {
            removed = appended.remove(childKey);
        }
        if (removed == null) {
            this.changedChildren.remove(childKey);
        }
        return child;
    }

    @Override
    public void reorderChild(SessionCache cache, NodeKey key, NodeKey nextNode) {
        WritableSessionCache session = this.writableSession(cache);
        session.assertInSession(this);
        ChildReferences references = this.getChildReferences(session);
        ChildReference before = null;
        if (nextNode != null && (before = references.getChild(nextNode)) == null) {
            throw new NodeNotFoundException(key);
        }
        MutableChildReferences appended = this.appended.get();
        ChildReference toBeMoved = null;
        if (appended != null) {
            toBeMoved = appended.remove(key);
        }
        if (toBeMoved == null) {
            toBeMoved = references.getChild(key);
            if (toBeMoved == null) {
                throw new NodeNotFoundException(key);
            }
            this.changedChildren.remove(key);
        }
        if (nextNode == null) {
            this.appended(true).append(key, toBeMoved.getName());
        } else {
            this.changedChildren.insertBefore(before, toBeMoved);
        }
    }

    @Override
    public void renameChild(SessionCache cache, NodeKey key, Name newName) {
        WritableSessionCache session = this.writableSession(cache);
        session.assertInSession(this);
        ChildReferences references = this.getChildReferences(session);
        if (!references.hasChild(key)) {
            throw new NodeNotFoundException(key);
        }
        cache.mutable(key);
        MutableChildReferences appended = this.appended.get();
        if (appended != null && appended.hasChild(key)) {
            appended.remove(key);
            appended.append(key, newName);
        } else {
            this.changedChildren.renameTo(key, newName);
        }
    }

    @Override
    public boolean linkChild(SessionCache cache, NodeKey childKey, Name name) {
        WritableSessionCache session = this.writableSession(cache);
        session.assertInSession(this);
        SessionNode child = session.mutable(childKey);
        if (!child.isNew() && this.key.equals(child.getParentKey(cache))) {
            return false;
        }
        if (child.addAdditionalParent(cache, this.key)) {
            this.appended(true).append(childKey, name);
        }
        return true;
    }

    @Override
    public String getEtag(SessionCache cache) {
        StringBuilder sb = new StringBuilder();
        Iterator<Property> iter = this.getProperties(cache);
        while (iter.hasNext()) {
            Property prop = iter.next();
            if (prop.isEmpty()) continue;
            for (Object value : prop) {
                if (!(value instanceof BinaryValue)) continue;
                BinaryValue binary = (BinaryValue)value;
                sb.append(binary.getHexHash());
            }
        }
        return sb.toString();
    }

    @Override
    public Map<NodeKey, NodeKey> deepCopy(SessionCache cache, CachedNode sourceNode, SessionCache sourceCache, String systemWorkspaceKey, Connectors connectors) {
        WritableSessionCache writableSessionCache = this.writableSession(cache);
        writableSessionCache.assertInSession(this);
        DeepCopy copier = new DeepCopy(this, writableSessionCache, sourceNode, sourceCache, systemWorkspaceKey, connectors);
        copier.execute();
        return copier.getSourceToTargetKeys();
    }

    @Override
    public void deepClone(SessionCache cache, CachedNode sourceNode, SessionCache sourceCache, String systemWorkspaceKey, Connectors connectors) {
        WritableSessionCache writableSessionCache = this.writableSession(cache);
        writableSessionCache.assertInSession(this);
        DeepClone cloner = new DeepClone(this, writableSessionCache, sourceNode, sourceCache, systemWorkspaceKey, connectors);
        cloner.execute();
    }

    @Override
    public Set<NodeKey> removedChildren() {
        return this.changedChildren().getRemovals();
    }

    @Override
    public Set<NodeKey> getChangedReferrerNodes() {
        HashSet<NodeKey> result = new HashSet<NodeKey>();
        ReferrerChanges referrerChanges = this.getReferrerChanges();
        if (referrerChanges == null) {
            return Collections.emptySet();
        }
        result.addAll(referrerChanges.getAddedReferrers(CachedNode.ReferenceType.BOTH));
        result.addAll(referrerChanges.getRemovedReferrers(CachedNode.ReferenceType.BOTH));
        return result;
    }

    @Override
    public void addFederatedSegment(String externalNodeKey, String segmentName) {
        if (this.federatedSegments.get() == null) {
            this.federatedSegments.compareAndSet(null, new FederatedSegmentChanges());
        }
        this.federatedSegments.get().addSegment(externalNodeKey, segmentName);
    }

    protected Map<String, String> getAddedFederatedSegments() {
        return this.federatedSegments.get() != null ? this.federatedSegments.get().getAdditions() : Collections.emptyMap();
    }

    @Override
    public void removeFederatedSegment(String externalNodeKey) {
        if (this.federatedSegments.get() == null) {
            this.federatedSegments.compareAndSet(null, new FederatedSegmentChanges());
        }
        this.federatedSegments.get().removeSegment(externalNodeKey);
    }

    protected Set<String> getRemovedFederatedSegments() {
        return this.federatedSegments.get() != null ? this.federatedSegments.get().getRemovals() : Collections.emptySet();
    }

    @Override
    public NodeChanges getNodeChanges() {
        return new NodeChanges();
    }

    @Override
    public boolean isQueryable(NodeCache cache) {
        Boolean isQueryable = this.isQueryable.get();
        if (isQueryable != null) {
            return isQueryable;
        }
        CachedNode persistedNode = this.nodeInWorkspace(this.session(cache));
        return persistedNode == null || persistedNode.isQueryable(cache);
    }

    @Override
    public void setQueryable(boolean queryable) {
        this.isQueryable.set(queryable);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CachedNode) {
            CachedNode that = (CachedNode)obj;
            return this.getKey().equals(that.getKey());
        }
        return false;
    }

    public String toString() {
        return this.getString(null);
    }

    public String getString(NamespaceRegistry registry) {
        ReferrerChanges referrerChg;
        boolean removedProps;
        StringBuilder sb = new StringBuilder();
        sb.append("Node '").append(this.key).append("' ->");
        NodeKey newParent = this.newParent;
        if (this.isNew) {
            if (newParent != null) {
                sb.append(" created under '").append(newParent).append('\'');
            } else {
                sb.append(" created; ");
            }
        } else if (newParent != null) {
            sb.append(" moved to '").append(newParent).append('\'');
        }
        ChangedAdditionalParents additionalParents = this.additionalParents();
        if (additionalParents != null) {
            sb.append(" parents: [");
            if (!additionalParents.getAdditions().isEmpty()) {
                sb.append("+").append(additionalParents.getAdditions());
            }
            if (!additionalParents.getRemovals().isEmpty()) {
                sb.append("-").append(additionalParents.getRemovals());
            }
            sb.append(']');
        }
        boolean changedProps = !this.changedProperties.isEmpty();
        boolean bl = removedProps = !this.removedProperties.isEmpty();
        if (changedProps || removedProps) {
            boolean first;
            sb.append(" props: {");
            if (changedProps) {
                first = true;
                for (Map.Entry entry : this.changedProperties.entrySet()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(',');
                    }
                    Property property = (Property)entry.getValue();
                    sb.append(" +").append(property.getString(registry));
                }
            }
            if (removedProps) {
                first = true;
                for (Name name : this.removedProperties.keySet()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append(" -").append(name.getString(registry));
                }
            }
            sb.append('}');
        }
        MutableChildReferences appended = this.appended(false);
        if (!this.changedChildren.isEmpty() || appended != null && !appended.isEmpty()) {
            sb.append(" children: ");
            if (!this.changedChildren.isEmpty()) {
                this.changedChildren.getString(sb);
                sb.append(' ');
            }
            if (appended != null && !appended.isEmpty()) {
                sb.append("appended [");
                Iterator<ChildReference> iter = appended.iterator();
                if (iter.hasNext()) {
                    sb.append(iter.next().toString(registry));
                    while (iter.hasNext()) {
                        sb.append(',');
                        sb.append(iter.next().toString(registry));
                    }
                }
                sb.append(']');
            }
        }
        if ((referrerChg = this.getReferrerChanges()) != null && !referrerChg.isEmpty()) {
            sb.append(' ');
            referrerChg.getString(sb);
        }
        return sb.toString();
    }

    protected class DeepClone
    extends DeepCopy {
        protected DeepClone(SessionNode targetNode, WritableSessionCache cache, CachedNode sourceNode, SessionCache sourceCache, String systemWorkspaceKey, Connectors connectors) {
            super(targetNode, cache, sourceNode, sourceCache, systemWorkspaceKey, connectors);
        }

        @Override
        protected void copyProperties(MutableCachedNode targetNode, CachedNode sourceNode) {
            targetNode.removeAllProperties(this.targetCache);
            super.copyProperties(targetNode, sourceNode);
        }

        @Override
        protected void copyUUIDProperty(Property sourceProperty, MutableCachedNode targetNode, CachedNode sourceNode) {
            targetNode.setProperty(this.targetCache, sourceProperty);
        }

        @Override
        protected NodeKey createTargetKeyFor(NodeKey sourceKey, NodeKey parentKeyInTarget, String preferredKey) {
            return !StringUtil.isBlank((String)preferredKey) ? new NodeKey(preferredKey) : parentKeyInTarget.withId(sourceKey.getIdentifier());
        }

        @Override
        protected String getOperationName() {
            return "Clone";
        }
    }

    protected class DeepCopy {
        protected final WritableSessionCache targetCache;
        protected final SessionNode targetNode;
        protected final SessionCache sourceCache;
        protected final CachedNode sourceNode;
        protected final Path startingPathInSource;
        protected final PropertyFactory propertyFactory;
        protected final String targetWorkspaceKey;
        protected final Map<NodeKey, NodeKey> linkedPlaceholdersToOriginal = new HashMap<NodeKey, NodeKey>();
        protected final Map<NodeKey, NodeKey> sourceToTargetKeys = new HashMap<NodeKey, NodeKey>();
        protected final Map<NodeKey, Set<Property>> sourceKeyToReferenceProperties = new HashMap<NodeKey, Set<Property>>();
        protected final DocumentStore documentStore;
        protected final String systemWorkspaceKey;
        protected final Connectors connectors;
        protected final ValueFactories valueFactories;

        protected DeepCopy(SessionNode targetNode, WritableSessionCache cache, CachedNode sourceNode, SessionCache sourceCache, String systemWorkspaceKey, Connectors connectors) {
            this.targetCache = cache;
            this.targetNode = targetNode;
            this.sourceCache = sourceCache;
            this.sourceNode = sourceNode;
            this.startingPathInSource = sourceNode.getPath(sourceCache);
            this.propertyFactory = this.targetCache.getContext().getPropertyFactory();
            this.targetWorkspaceKey = targetNode.getKey().getWorkspaceKey();
            this.documentStore = ((WorkspaceCache)sourceCache.getWorkspace()).documentStore();
            this.systemWorkspaceKey = systemWorkspaceKey;
            this.connectors = connectors;
            this.valueFactories = this.targetCache.context().getValueFactories();
        }

        public Map<NodeKey, NodeKey> getSourceToTargetKeys() {
            return this.sourceToTargetKeys;
        }

        public void execute() {
            this.doPhase1(this.targetNode, this.sourceNode);
            this.doPhase2();
            this.resolveReferences();
        }

        /*
         * Enabled aggressive block sorting
         */
        protected void doPhase1(MutableCachedNode targetNode, CachedNode sourceNode) {
            NodeKey sourceKey = sourceNode.getKey();
            NodeKey targetKey = targetNode.getKey();
            this.sourceToTargetKeys.put(sourceKey, targetKey);
            if (this.shouldProcessSourceKey(sourceKey)) {
                this.copyProperties(targetNode, sourceNode);
            }
            Iterator<ChildReference> i$ = sourceNode.getChildReferences(this.sourceCache).iterator();
            while (i$.hasNext()) {
                ChildReference childReference = i$.next();
                NodeKey childKey = childReference.getKey();
                if (!this.shouldProcessSourceKey(childKey)) continue;
                CachedNode sourceChild = this.sourceCache.getNode(childKey);
                NodeKey parentSourceKey = sourceChild.getParentKeyInAnyWorkspace(this.sourceCache);
                if (sourceKey.equals(parentSourceKey)) {
                    boolean isExternal = !childKey.getSourceKey().equalsIgnoreCase(this.sourceCache.getRootKey().getSourceKey());
                    MutableCachedNode childCopy = null;
                    String projectionAlias = childReference.getName().getString();
                    if (isExternal && this.connectors.hasExternalProjection(projectionAlias, childKey.toString())) {
                        targetNode.addFederatedSegment(childKey.toString(), projectionAlias);
                        childCopy = this.targetCache.mutable(childKey);
                    } else {
                        String childCopyPreferredKey = this.documentStore.newDocumentKey(targetKey.toString(), childReference.getName(), sourceChild.getPrimaryType(this.sourceCache));
                        NodeKey newKey = this.createTargetKeyFor(childKey, targetKey, childCopyPreferredKey);
                        childCopy = targetNode.createChild(this.targetCache, newKey, childReference.getName(), null);
                    }
                    this.doPhase1(childCopy, sourceChild);
                    continue;
                }
                Path sourceChildPath = sourceChild.getPath(this.sourceCache);
                NodeKey newKey = null;
                if (sourceChildPath.isAtOrBelow(this.startingPathInSource)) {
                    newKey = this.sourceToTargetKeys.get(childKey);
                    if (newKey == null) {
                        CachedNode nodeInOtherWorkspace = this.targetCache.getNode(childKey);
                        if (nodeInOtherWorkspace != null) {
                            newKey = childKey;
                        } else {
                            NodeKey placeholderKey = this.createTargetKeyFor(childKey, targetKey, null);
                            String childCopyPreferredKey = this.documentStore.newDocumentKey(targetKey.toString(), childReference.getName(), sourceChild.getPrimaryType(this.sourceCache));
                            newKey = this.createTargetKeyFor(childKey, targetKey, childCopyPreferredKey);
                            this.sourceToTargetKeys.put(childKey, newKey);
                            targetNode.createChild(this.targetCache, placeholderKey, childReference.getName(), null);
                            this.linkedPlaceholdersToOriginal.put(placeholderKey, newKey);
                            continue;
                        }
                    }
                } else {
                    newKey = childReference.getKey();
                }
                targetNode.linkChild(this.targetCache, newKey, childReference.getName());
            }
            return;
        }

        protected NodeKey createTargetKeyFor(NodeKey sourceKey, NodeKey parentKeyInTarget, String preferredKey) {
            NodeKey newKey = this.sourceToTargetKeys.get(sourceKey);
            if (newKey != null) {
                return newKey;
            }
            if (!StringUtil.isBlank((String)preferredKey)) {
                return new NodeKey(preferredKey);
            }
            return parentKeyInTarget.withRandomId();
        }

        protected void doPhase2() {
            RuntimeException firstException = null;
            Iterator<Map.Entry<NodeKey, NodeKey>> entryIterator = this.linkedPlaceholdersToOriginal.entrySet().iterator();
            while (entryIterator.hasNext()) {
                Map.Entry<NodeKey, NodeKey> entry = entryIterator.next();
                try {
                    NodeKey placeholderKey = entry.getKey();
                    NodeKey linkableKey = entry.getValue();
                    CachedNode placeholder = this.targetCache.getNode(placeholderKey);
                    NodeKey parentKey = placeholder.getParentKey(this.targetCache);
                    SessionNode parent = this.targetCache.mutable(parentKey);
                    if (parent.linkChild(this.targetCache, linkableKey, placeholder.getName(this.targetCache))) {
                        parent.reorderChild(this.targetCache, linkableKey, placeholderKey);
                    }
                    parent.removeChild(this.targetCache, placeholderKey);
                    entryIterator.remove();
                }
                catch (RuntimeException e) {
                    if (firstException != null) continue;
                    firstException = e;
                }
            }
            if (firstException != null) {
                throw firstException;
            }
        }

        protected void resolveReferences() {
            for (Map.Entry<NodeKey, NodeKey> entry : this.sourceToTargetKeys.entrySet()) {
                NodeKey sourceKey = entry.getKey();
                NodeKey targetKey = entry.getValue();
                Set<Property> referenceProperties = this.sourceKeyToReferenceProperties.get(sourceKey);
                if (referenceProperties == null) continue;
                SessionNode targetNode = this.targetCache.mutable(targetKey);
                for (Property property : referenceProperties) {
                    ArrayList<Reference> resolvedReferences = new ArrayList<Reference>();
                    Iterator<?> valuesIterator = property.getValues();
                    while (valuesIterator.hasNext()) {
                        Reference reference = (Reference)valuesIterator.next();
                        resolvedReferences.add(this.resolveReference(sourceKey, targetKey, property.getName(), reference));
                    }
                    Property updatedProperty = property.isMultiple() ? this.propertyFactory.create(property.getName(), resolvedReferences) : this.propertyFactory.create(property.getName(), resolvedReferences.get(0));
                    targetNode.setProperty(this.targetCache, updatedProperty);
                }
            }
        }

        private Reference resolveReference(NodeKey sourceNodeKey, NodeKey targetNodeKey, Name propertyName, Reference referenceInSource) {
            String referenceStringValue = referenceInSource.getString();
            NodeKey referenceInSourceKey = null;
            referenceInSourceKey = referenceInSource instanceof NodeKeyReference ? ((NodeKeyReference)referenceInSource).getNodeKey() : (NodeKey.isValidFormat(referenceStringValue) ? new NodeKey(referenceStringValue) : sourceNodeKey.withId(referenceStringValue));
            if (referenceInSourceKey.getWorkspaceKey().equals(this.systemWorkspaceKey)) {
                return referenceInSource;
            }
            NodeKey referenceInTargetKey = this.sourceToTargetKeys.get(referenceInSourceKey);
            if (referenceInTargetKey == null) {
                boolean resolvableInSourceWorkspace;
                referenceInTargetKey = referenceInSourceKey.withWorkspaceKey(targetNodeKey.getWorkspaceKey());
                boolean resolvableInTargetWorkspace = this.targetCache.getNode(referenceInTargetKey) != null;
                boolean bl = resolvableInSourceWorkspace = this.sourceCache.getNode(referenceInSourceKey) != null;
                if (!resolvableInTargetWorkspace && resolvableInSourceWorkspace) {
                    throw new WrappedException((Exception)((Object)new RepositoryException(JcrI18n.cannotCopyOrCloneReferenceOutsideGraph.text(new Object[]{propertyName, referenceInSourceKey, this.startingPathInSource}))));
                }
                if (!(resolvableInSourceWorkspace || referenceInSource.isWeak() || referenceInSource.isSimple())) {
                    throw new WrappedException((Exception)((Object)new RepositoryException(JcrI18n.cannotCopyOrCloneCorruptReference.text(new Object[]{propertyName, referenceInSourceKey}))));
                }
            }
            if (referenceInSource.isSimple()) {
                return this.valueFactories.getSimpleReferenceFactory().create(referenceInTargetKey, referenceInSource.isForeign());
            }
            if (referenceInSource.isWeak()) {
                return this.valueFactories.getWeakReferenceFactory().create(referenceInTargetKey, referenceInSource.isForeign());
            }
            return this.valueFactories.getReferenceFactory().create(referenceInTargetKey, referenceInSource.isForeign());
        }

        protected void copyProperties(MutableCachedNode targetNode, CachedNode sourceNode) {
            NodeKey sourceNodeKey = sourceNode.getKey();
            Iterator<Property> propertyIterator = sourceNode.getProperties(this.sourceCache);
            while (propertyIterator.hasNext()) {
                Property property = propertyIterator.next();
                if (property.isReference() || property.isSimpleReference()) {
                    Set<Property> referenceProperties = this.sourceKeyToReferenceProperties.get(sourceNodeKey);
                    if (referenceProperties == null) {
                        referenceProperties = new HashSet<Property>();
                        this.sourceKeyToReferenceProperties.put(sourceNodeKey, referenceProperties);
                    }
                    referenceProperties.add(property);
                    continue;
                }
                if (property.getName().equals(JcrLexicon.UUID)) {
                    this.copyUUIDProperty(property, targetNode, sourceNode);
                    continue;
                }
                boolean sourceExternal = !sourceNodeKey.getSourceKey().equals(this.sourceCache.getRootKey().getSourceKey());
                boolean targetInternal = targetNode.getKey().getSourceKey().equals(this.targetCache.getRootKey().getSourceKey());
                if (sourceExternal && targetInternal && property.getFirstValue() instanceof ExternalBinaryValue) {
                    Property newProperty = null;
                    if (property.isMultiple()) {
                        ArrayList<Object> values = new ArrayList<Object>(property.size());
                        for (Object value : property) {
                            values.add(this.convertToInternalBinaryValue(value));
                        }
                        newProperty = this.propertyFactory.create(property.getName(), values.iterator());
                    } else if (property.isSingle()) {
                        Object value = this.convertToInternalBinaryValue(property.getFirstValue());
                        newProperty = this.propertyFactory.create(property.getName(), value);
                    }
                    if (newProperty == null) continue;
                    targetNode.setProperty(this.targetCache, newProperty);
                    continue;
                }
                targetNode.setProperty(this.targetCache, property);
            }
        }

        protected Object convertToInternalBinaryValue(Object value) {
            if (value instanceof ExternalBinaryValue) {
                try {
                    return this.valueFactories.getBinaryFactory().create(((ExternalBinaryValue)value).getStream());
                }
                catch (RepositoryException e) {
                    throw new WrappedException((Exception)((Object)e));
                }
            }
            return value;
        }

        protected void copyUUIDProperty(Property sourceProperty, MutableCachedNode targetNode, CachedNode sourceNode) {
            String targetUUID = JcrSession.nodeIdentifier(targetNode.getKey(), this.targetCache.getRootKey());
            targetNode.setProperty(this.targetCache, this.propertyFactory.create(sourceProperty.getName(), targetUUID));
        }

        public String toString() {
            return this.getOperationName() + " '" + this.startingPathInSource.getString(this.sourceCache.getContext().getNamespaceRegistry()) + "' in workspace '" + this.sourceCache.getWorkspace().toString() + "' into '" + this.targetNode.getPath(this.targetCache).getString(this.targetCache.getContext().getNamespaceRegistry()) + "' in workspace '" + this.targetCache.getWorkspace().toString() + "'";
        }

        protected String getOperationName() {
            return "Copy";
        }

        protected boolean shouldProcessSourceKey(NodeKey sourceKey) {
            return !sourceKey.equals(this.sourceCache.getRootKey()) && !sourceKey.getWorkspaceKey().equalsIgnoreCase(this.systemWorkspaceKey);
        }
    }

    protected static class ReferrerChanges {
        private final List<NodeKey> addedWeak = new ArrayList<NodeKey>();
        private final List<NodeKey> removedWeak = new ArrayList<NodeKey>();
        private final List<NodeKey> addedStrong = new ArrayList<NodeKey>();
        private final List<NodeKey> removedStrong = new ArrayList<NodeKey>();

        protected ReferrerChanges() {
        }

        public void addWeakReferrer(NodeKey nodeKey) {
            this.addedWeak.add(nodeKey);
            this.removedWeak.remove(nodeKey);
        }

        public void removeWeakReferrer(NodeKey nodeKey) {
            this.addedWeak.remove(nodeKey);
            this.removedWeak.add(nodeKey);
        }

        public void addStrongReferrer(NodeKey nodeKey) {
            this.addedStrong.add(nodeKey);
            this.removedStrong.remove(nodeKey);
        }

        public void removeStrongReferrer(NodeKey nodeKey) {
            this.addedStrong.remove(nodeKey);
            this.removedStrong.add(nodeKey);
        }

        public List<NodeKey> getAddedReferrers(CachedNode.ReferenceType type) {
            switch (type) {
                case STRONG: {
                    return this.addedStrong;
                }
                case WEAK: {
                    return this.addedWeak;
                }
                case BOTH: {
                    ArrayList<NodeKey> result = new ArrayList<NodeKey>();
                    result.addAll(this.addedWeak);
                    result.addAll(this.addedStrong);
                    return result;
                }
            }
            assert (false) : "Should never get here";
            return null;
        }

        public List<NodeKey> getRemovedReferrers(CachedNode.ReferenceType type) {
            switch (type) {
                case STRONG: {
                    return this.removedStrong;
                }
                case WEAK: {
                    return this.removedWeak;
                }
                case BOTH: {
                    ArrayList<NodeKey> result = new ArrayList<NodeKey>();
                    result.addAll(this.removedStrong);
                    result.addAll(this.removedWeak);
                    return result;
                }
            }
            assert (false) : "Should never get here";
            return null;
        }

        public boolean isEmpty() {
            return this.addedWeak.isEmpty() && this.removedWeak.isEmpty() && this.addedStrong.isEmpty() && this.removedStrong.isEmpty();
        }

        public String toString() {
            return this.getString(new StringBuilder());
        }

        public String getString(StringBuilder sb) {
            sb.append("ReferrerChanges: ");
            if (!this.addedStrong.isEmpty()) {
                sb.append(" addedStrong=").append(this.addedStrong);
            }
            if (!this.addedWeak.isEmpty()) {
                sb.append(" addedWeak=").append(this.addedWeak);
            }
            if (!this.removedWeak.isEmpty()) {
                sb.append(" removedWeak=").append(this.removedWeak);
            }
            if (!this.removedStrong.isEmpty()) {
                sb.append(" removedStrong=").append(this.removedStrong);
            }
            return sb.toString();
        }
    }

    protected static class MixinChanges {
        private final Set<Name> added = new HashSet<Name>();
        private final Set<Name> removed = new HashSet<Name>();

        protected MixinChanges() {
        }

        public void add(Name mixin) {
            this.added.add(mixin);
            this.removed.remove(mixin);
        }

        public void remove(Name mixin) {
            this.added.remove(mixin);
            this.removed.add(mixin);
        }

        public Set<Name> getAdded() {
            return this.added;
        }

        public Set<Name> getRemoved() {
            return this.removed;
        }

        public boolean isEmpty() {
            return this.added.isEmpty() && this.removed.isEmpty();
        }

        public String toString() {
            return "added: " + this.added + ", removed: " + this.removed;
        }
    }

    protected static class Insertions
    implements ChildReferences.ChildInsertions {
        private final List<ChildReference> inserted = new CopyOnWriteArrayList<ChildReference>();
        private final ChildReference before;

        protected Insertions(ChildReference before) {
            this.before = before;
        }

        protected Insertions(ChildReference before, ChildReference inserted) {
            this.before = before;
            this.inserted.add(inserted);
        }

        @Override
        public Iterable<ChildReference> inserted() {
            return this.inserted;
        }

        @Override
        public ChildReference insertedBefore() {
            return this.before;
        }

        public void add(ChildReference reference) {
            this.inserted.add(reference);
        }

        public boolean contains(ChildReference reference) {
            return this.inserted.contains(reference);
        }

        public boolean remove(ChildReference reference) {
            return this.inserted.remove(reference);
        }

        public ChildReference remove(NodeKey key) {
            for (ChildReference ref : this.inserted) {
                if (!ref.getKey().equals(key) || !this.remove(ref)) continue;
                return ref;
            }
            return null;
        }

        public String toString() {
            return this.inserted + " before " + this.before;
        }

        public int hashCode() {
            return this.before.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Insertions) {
                Insertions that = (Insertions)obj;
                return this.before.equals(that.before) && this.inserted.equals(that.inserted);
            }
            return false;
        }
    }

    @ThreadSafe
    protected static class InsertedChildReferences
    implements Iterable<Insertions> {
        private final ReadWriteLock lock = new ReentrantReadWriteLock();
        private final Set<NodeKey> inserted = new HashSet<NodeKey>();
        private final Map<Name, AtomicInteger> insertedNames = new HashMap<Name, AtomicInteger>();
        private final ConcurrentMap<NodeKey, Insertions> insertedBefore = new ConcurrentHashMap<NodeKey, Insertions>();

        protected InsertedChildReferences() {
        }

        public int size() {
            return this.inserted.size();
        }

        @Override
        public Iterator<Insertions> iterator() {
            return this.insertedBefore.values().iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChildReference inserted(NodeKey key) {
            Lock lock = this.lock.readLock();
            try {
                lock.lock();
                if (!this.inserted.contains(key)) {
                    ChildReference childReference = null;
                    return childReference;
                }
                for (Insertions insertions : this.insertedBefore.values()) {
                    for (ChildReference inserted : insertions.inserted()) {
                        if (!inserted.getKey().equals(key)) continue;
                        ChildReference childReference = inserted;
                        return childReference;
                    }
                }
                ChildReference childReference = null;
                return childReference;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Iterator<ChildReferences.ChildInsertions> insertions(Name name) {
            Lock lock = this.lock.readLock();
            try {
                lock.lock();
                if (!this.insertedNames.containsKey(name)) {
                    Iterator<ChildReferences.ChildInsertions> iterator = null;
                    return iterator;
                }
                LinkedList<Insertions> namedInsertions = new LinkedList<Insertions>();
                for (Insertions insertions : this.insertedBefore.values()) {
                    Insertions byName = null;
                    for (ChildReference inserted : insertions.inserted()) {
                        if (!inserted.getName().equals(name)) continue;
                        if (byName == null) {
                            byName = new Insertions(insertions.insertedBefore(), inserted);
                            continue;
                        }
                        byName.add(inserted);
                    }
                    if (byName == null) continue;
                    namedInsertions.add(byName);
                }
                Iterator<ChildReferences.ChildInsertions> iterator = namedInsertions.iterator();
                return iterator;
            }
            finally {
                lock.unlock();
            }
        }

        public ChildReferences.ChildInsertions insertionsBefore(NodeKey key) {
            return (ChildReferences.ChildInsertions)this.insertedBefore.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insertBefore(ChildReference before, ChildReference inserted) {
            Lock lock = this.lock.writeLock();
            try {
                lock.lock();
                inserted = inserted.with(1);
                Insertions insertions = (Insertions)this.insertedBefore.get(before.getKey());
                if (insertions == null) {
                    insertions = new Insertions(before, inserted);
                    this.insertedBefore.put(before.getKey(), insertions);
                } else {
                    insertions.add(inserted);
                }
                AtomicInteger count = this.insertedNames.get(inserted.getName());
                if (count == null) {
                    this.insertedNames.put(inserted.getName(), new AtomicInteger(1));
                } else {
                    count.incrementAndGet();
                }
                boolean added = this.inserted.add(inserted.getKey());
                assert (added);
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(NodeKey key) {
            Lock lock = this.lock.writeLock();
            try {
                lock.lock();
                ChildReference removed = null;
                if (this.inserted.remove(key)) {
                    Name name;
                    AtomicInteger count;
                    for (Insertions insertions : this.insertedBefore.values()) {
                        removed = insertions.remove(key);
                        if (removed == null) continue;
                        this.insertedBefore.remove(insertions.insertedBefore(), new Insertions(insertions.insertedBefore()));
                        break;
                    }
                    if (removed != null && (count = this.insertedNames.get(name = removed.getName())) != null && count.decrementAndGet() == 0) {
                        this.insertedNames.remove(name);
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(ChildReference inserted) {
            Lock lock = this.lock.writeLock();
            try {
                lock.lock();
                if (this.inserted.remove(inserted.getKey())) {
                    AtomicInteger count = this.insertedNames.get(inserted.getName());
                    if (count != null && count.decrementAndGet() == 0) {
                        this.insertedNames.remove(inserted.getName());
                    }
                    for (Insertions insertions : this.insertedBefore.values()) {
                        if (!insertions.remove(inserted)) continue;
                        this.insertedBefore.remove(insertions.insertedBefore(), new Insertions(insertions.insertedBefore()));
                    }
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        public String toString() {
            return this.toString(new StringBuilder()).toString();
        }

        public StringBuilder toString(StringBuilder sb) {
            int number = this.size();
            sb.append(number).append(' ').append(Inflector.getInstance().pluralize((Object)"insertion", number)).append(": ");
            Iterator<Insertions> iter = this.iterator();
            if (iter.hasNext()) {
                sb.append(iter.next());
                while (iter.hasNext()) {
                    sb.append(", ");
                    sb.append(iter.next());
                }
            }
            return sb;
        }
    }

    @ThreadSafe
    protected static class FederatedSegmentChanges {
        private final ConcurrentHashMap<String, String> additions = new ConcurrentHashMap();
        private final Set<String> removals = Collections.synchronizedSet(new HashSet());

        protected FederatedSegmentChanges() {
        }

        protected void addSegment(String externalNodeKey, String name) {
            this.additions.putIfAbsent(externalNodeKey, name);
        }

        protected void removeSegment(String externalNodeKey) {
            this.removals.add(externalNodeKey);
        }

        protected Map<String, String> getAdditions() {
            return Collections.unmodifiableMap(this.additions);
        }

        protected Set<String> getRemovals() {
            return Collections.unmodifiableSet(this.removals);
        }
    }

    @ThreadSafe
    protected static class ChangedChildren
    implements ChildReferences.Changes {
        private final AtomicReference<Set<NodeKey>> removals = new AtomicReference();
        private final AtomicReference<InsertedChildReferences> insertions = new AtomicReference();
        private final AtomicReference<Map<NodeKey, Name>> newNames = new AtomicReference();

        protected ChangedChildren() {
        }

        @Override
        public boolean isEmpty() {
            return this.insertionCount() == 0 && this.removalCount() == 0 && this.renameCount() == 0;
        }

        @Override
        public int insertionCount() {
            InsertedChildReferences insertions = this.insertions.get();
            return insertions == null ? 0 : insertions.size();
        }

        @Override
        public int removalCount() {
            Set<NodeKey> removals = this.removals.get();
            return removals == null ? 0 : removals.size();
        }

        @Override
        public int renameCount() {
            Map<NodeKey, Name> newNames = this.newNames.get();
            return newNames == null ? 0 : newNames.size();
        }

        @Override
        public ChildReference inserted(NodeKey key) {
            InsertedChildReferences insertions = this.insertions.get();
            return insertions == null ? null : insertions.inserted(key);
        }

        @Override
        public Iterator<ChildReferences.ChildInsertions> insertions(Name name) {
            InsertedChildReferences insertions = this.insertions.get();
            return insertions == null ? null : insertions.insertions(name);
        }

        @Override
        public ChildReferences.ChildInsertions insertionsBefore(ChildReference key) {
            InsertedChildReferences insertions = this.insertions.get();
            return insertions == null ? null : insertions.insertionsBefore(key.getKey());
        }

        public void insertBefore(ChildReference before, ChildReference inserted) {
            if (before == inserted) {
                return;
            }
            InsertedChildReferences insertions = this.insertions.get();
            if (insertions == null && !this.insertions.compareAndSet(null, insertions = new InsertedChildReferences())) {
                insertions = this.insertions.get();
            }
            insertions.insertBefore(before, inserted);
        }

        @Override
        public boolean isRemoved(ChildReference ref) {
            Set<NodeKey> removals = this.removals.get();
            return removals != null && removals.contains(ref.getKey());
        }

        @Override
        public boolean isRenamed(ChildReference ref) {
            Map<NodeKey, Name> renames = this.newNames.get();
            return renames != null && renames.containsKey(ref.getKey());
        }

        @Override
        public boolean isRenamed(Name newName) {
            Map<NodeKey, Name> renames = this.newNames.get();
            return renames != null && renames.containsValue(newName);
        }

        public boolean remove(NodeKey key) {
            InsertedChildReferences insertions = this.insertions.get();
            if (insertions != null && insertions.remove(key)) {
                Set<NodeKey> removals = this.removals.get();
                assert (removals == null || !removals.contains(key));
                return true;
            }
            Object removals = this.removals.get();
            if (removals == null && !this.removals.compareAndSet(null, (Set<NodeKey>)(removals = new ConcurrentHashSet()))) {
                removals = this.removals.get();
            }
            removals.add((NodeKey)key);
            return true;
        }

        @Override
        public Name renamed(NodeKey key) {
            Map<NodeKey, Name> newNames = this.newNames.get();
            return newNames == null ? null : newNames.get(key);
        }

        public void renameTo(NodeKey key, Name newName) {
            Map<NodeKey, Name> newNames = this.newNames.get();
            if (newNames == null && !this.newNames.compareAndSet(null, newNames = new ConcurrentHashMap<NodeKey, Name>())) {
                newNames = this.newNames.get();
            }
            newNames.put(key, newName);
        }

        public String toString() {
            return this.getString(new StringBuilder()).toString();
        }

        public StringBuilder getString(StringBuilder sb) {
            InsertedChildReferences insertions = this.insertions.get();
            Set<NodeKey> removals = this.removals.get();
            if (insertions != null) {
                insertions.toString(sb);
                if (removals != null && !removals.isEmpty()) {
                    sb.append("; ");
                }
            }
            if (removals != null) {
                sb.append("removals: " + removals);
            }
            return sb;
        }

        public Map<NodeKey, Name> getNewNames() {
            Map<NodeKey, Name> newNames = this.newNames.get();
            return newNames == null ? Collections.emptyMap() : newNames;
        }

        public Set<NodeKey> getRemovals() {
            Set<NodeKey> removals = this.removals.get();
            return removals == null ? Collections.emptySet() : new HashSet<NodeKey>(removals);
        }

        public Map<NodeKey, Insertions> getInsertionsByBeforeKey() {
            InsertedChildReferences insertedRefs = this.insertions.get();
            if (insertedRefs == null || insertedRefs.size() == 0) {
                return Collections.emptyMap();
            }
            HashMap<NodeKey, Insertions> result = new HashMap<NodeKey, Insertions>();
            for (Insertions insertions : insertedRefs) {
                result.put(insertions.insertedBefore().getKey(), insertions);
            }
            return result;
        }
    }

    @ThreadSafe
    protected static class ChangedAdditionalParents {
        private final Set<NodeKey> removals = new ConcurrentHashSet();
        private final Set<NodeKey> additions = new CopyOnWriteArraySet<NodeKey>();

        protected ChangedAdditionalParents() {
        }

        public boolean isEmpty() {
            return this.additionCount() == 0 && this.removalCount() == 0;
        }

        public int additionCount() {
            return this.additions.size();
        }

        public int removalCount() {
            return this.removals.size();
        }

        public boolean remove(NodeKey key) {
            return this.additions.remove(key) || this.removals.add(key);
        }

        public boolean add(NodeKey key) {
            return this.removals.remove(key) || this.additions.add(key);
        }

        public Set<NodeKey> getAdditions() {
            return this.additions;
        }

        public Set<NodeKey> getRemovals() {
            return this.removals;
        }
    }

    private class NodeChanges
    implements MutableCachedNode.NodeChanges {
        private NodeChanges() {
        }

        @Override
        public Set<Name> changedPropertyNames() {
            HashSet<Name> result = new HashSet<Name>();
            result.addAll(SessionNode.this.changedProperties().keySet());
            return result;
        }

        @Override
        public Set<Name> removedPropertyNames() {
            return new HashSet<Name>(SessionNode.this.removedProperties());
        }

        @Override
        public Set<Name> addedMixins() {
            HashSet<Name> result = new HashSet<Name>();
            MixinChanges mixinChanges = SessionNode.this.mixinChanges(false);
            if (mixinChanges != null) {
                result.addAll(mixinChanges.getAdded());
            }
            return result;
        }

        @Override
        public Set<Name> removedMixins() {
            HashSet<Name> result = new HashSet<Name>();
            MixinChanges mixinChanges = SessionNode.this.mixinChanges(false);
            if (mixinChanges != null) {
                result.addAll(mixinChanges.getRemoved());
            }
            return result;
        }

        @Override
        public LinkedHashMap<NodeKey, Name> appendedChildren() {
            LinkedHashMap<NodeKey, Name> result = new LinkedHashMap<NodeKey, Name>();
            MutableChildReferences appendedChildReferences = SessionNode.this.appended(false);
            if (appendedChildReferences != null) {
                for (ChildReference appendedChildReference : appendedChildReferences) {
                    result.put(appendedChildReference.getKey(), appendedChildReference.getName());
                }
            }
            return result;
        }

        @Override
        public Set<NodeKey> removedChildren() {
            HashSet<NodeKey> result = new HashSet<NodeKey>();
            result.addAll(SessionNode.this.changedChildren().getRemovals());
            return result;
        }

        @Override
        public Map<NodeKey, Name> renamedChildren() {
            HashMap<NodeKey, Name> result = new HashMap<NodeKey, Name>();
            result.putAll(SessionNode.this.changedChildren().getNewNames());
            return result;
        }

        @Override
        public Map<NodeKey, LinkedHashMap<NodeKey, Name>> childrenInsertedBefore() {
            HashMap<NodeKey, LinkedHashMap<NodeKey, Name>> result = new HashMap<NodeKey, LinkedHashMap<NodeKey, Name>>();
            Map<NodeKey, Insertions> insertionsByBeforeKey = SessionNode.this.changedChildren().getInsertionsByBeforeKey();
            for (NodeKey beforeNodeKey : insertionsByBeforeKey.keySet()) {
                Insertions insertionsBefore = insertionsByBeforeKey.get(beforeNodeKey);
                if (insertionsBefore == null) continue;
                LinkedHashMap<NodeKey, Name> insertionsBeforeMap = new LinkedHashMap<NodeKey, Name>();
                for (ChildReference childReference : insertionsBefore.inserted()) {
                    insertionsBeforeMap.put(childReference.getKey(), childReference.getName());
                }
                result.put(beforeNodeKey, insertionsBeforeMap);
            }
            return result;
        }

        @Override
        public Set<NodeKey> addedParents() {
            HashSet<NodeKey> result = new HashSet<NodeKey>();
            if (SessionNode.this.additionalParents() != null) {
                result.addAll(SessionNode.this.additionalParents().getAdditions());
            }
            return result;
        }

        @Override
        public Set<NodeKey> removedParents() {
            HashSet<NodeKey> result = new HashSet<NodeKey>();
            if (SessionNode.this.additionalParents() != null) {
                result.addAll(SessionNode.this.additionalParents().getRemovals());
            }
            return result;
        }

        @Override
        public NodeKey newPrimaryParent() {
            return SessionNode.this.newParent();
        }

        @Override
        public Set<NodeKey> addedWeakReferrers() {
            HashSet<NodeKey> result = new HashSet<NodeKey>();
            ReferrerChanges referrerChanges = SessionNode.this.referrerChanges(false);
            if (referrerChanges != null) {
                result.addAll(referrerChanges.getAddedReferrers(CachedNode.ReferenceType.WEAK));
            }
            return result;
        }

        @Override
        public Set<NodeKey> removedWeakReferrers() {
            HashSet<NodeKey> result = new HashSet<NodeKey>();
            ReferrerChanges referrerChanges = SessionNode.this.referrerChanges(false);
            if (referrerChanges != null) {
                result.addAll(referrerChanges.getRemovedReferrers(CachedNode.ReferenceType.WEAK));
            }
            return result;
        }

        @Override
        public Set<NodeKey> addedStrongReferrers() {
            HashSet<NodeKey> result = new HashSet<NodeKey>();
            ReferrerChanges referrerChanges = SessionNode.this.referrerChanges(false);
            if (referrerChanges != null) {
                result.addAll(referrerChanges.getAddedReferrers(CachedNode.ReferenceType.STRONG));
            }
            return result;
        }

        @Override
        public Set<NodeKey> removedStrongReferrers() {
            HashSet<NodeKey> result = new HashSet<NodeKey>();
            ReferrerChanges referrerChanges = SessionNode.this.referrerChanges(false);
            if (referrerChanges != null) {
                result.addAll(referrerChanges.getRemovedReferrers(CachedNode.ReferenceType.STRONG));
            }
            return result;
        }
    }

    public static enum LockChange {
        LOCK_FOR_SESSION,
        LOCK_FOR_NON_SESSION,
        UNLOCK;

    }
}

