/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.NotifyingFuture;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="api.AsyncAPITest")
public class AsyncAPITest
extends SingleCacheManagerTest {
    private Cache<String, String> c;
    private long startTime;

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createLocalCacheManager(false);
        this.c = cm.getCache();
        return cm;
    }

    public void testAsyncMethods() throws Exception {
        NotifyingFuture f = this.c.getAsync((Object)"k");
        assert (f != null);
        assert (!f.isCancelled());
        Assert.assertNull(f.get());
        assert (f.isDone());
        assert (this.c.get((Object)"k") == null);
        f = this.c.putAsync((Object)"k", (Object)"v");
        assert (f != null);
        assert (!f.isCancelled());
        Assert.assertEquals(f.get(), null);
        assert (f.isDone());
        assert (((String)this.c.get((Object)"k")).equals("v"));
        f = this.c.putAsync((Object)"k", (Object)"v2");
        assert (f != null);
        assert (!f.isCancelled());
        assert (((String)f.get()).equals("v"));
        assert (f.isDone());
        assert (((String)this.c.get((Object)"k")).equals("v2"));
        NotifyingFuture f2 = this.c.putAllAsync(Collections.singletonMap("k", "v3"));
        assert (f2 != null);
        assert (!f2.isCancelled());
        assert (f2.get() == null);
        assert (f2.isDone());
        assert (((String)this.c.get((Object)"k")).equals("v3"));
        f = this.c.putIfAbsentAsync((Object)"k", (Object)"v4");
        assert (f != null);
        assert (!f.isCancelled());
        assert (((String)f.get()).equals("v3"));
        assert (f.isDone());
        assert (((String)this.c.get((Object)"k")).equals("v3"));
        f = this.c.removeAsync((Object)"k");
        assert (f != null);
        assert (!f.isCancelled());
        assert (((String)f.get()).equals("v3"));
        assert (f.isDone());
        assert (this.c.get((Object)"k") == null);
        f = this.c.putIfAbsentAsync((Object)"k", (Object)"v4");
        assert (f != null);
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (f.isDone());
        assert (((String)this.c.get((Object)"k")).equals("v4"));
        f = this.c.getAsync((Object)"k");
        assert (f != null);
        assert (!f.isCancelled());
        assert (((String)f.get()).equals("v4"));
        assert (f.isDone());
        assert (((String)this.c.get((Object)"k")).equals("v4"));
        NotifyingFuture f3 = this.c.removeAsync((Object)"k", (Object)"v_nonexistent");
        assert (f3 != null);
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(false));
        assert (f3.isDone());
        assert (((String)this.c.get((Object)"k")).equals("v4"));
        f3 = this.c.removeAsync((Object)"k", (Object)"v4");
        assert (f3 != null);
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(true));
        assert (f3.isDone());
        assert (this.c.get((Object)"k") == null);
        f = this.c.replaceAsync((Object)"k", (Object)"v5");
        assert (f != null);
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (f.isDone());
        assert (this.c.get((Object)"k") == null);
        this.c.put((Object)"k", (Object)"v");
        f = this.c.replaceAsync((Object)"k", (Object)"v5");
        assert (f != null);
        assert (!f.isCancelled());
        assert (((String)f.get()).equals("v"));
        assert (f.isDone());
        assert (((String)this.c.get((Object)"k")).equals("v5"));
        f3 = this.c.replaceAsync((Object)"k", (Object)"v_nonexistent", (Object)"v6");
        assert (f3 != null);
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(false));
        assert (f3.isDone());
        assert (((String)this.c.get((Object)"k")).equals("v5"));
        f3 = this.c.replaceAsync((Object)"k", (Object)"v5", (Object)"v6");
        assert (f3 != null);
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(true));
        assert (f3.isDone());
        assert (((String)this.c.get((Object)"k")).equals("v6"));
    }

    public void testAsyncMethodWithLifespanAndMaxIdle() throws Exception {
        NotifyingFuture f = this.c.putAsync((Object)"k", (Object)"v", 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        assert (f != null);
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (f.isDone());
        this.verifyEviction("k", "v", 1000L, true);
        f = this.c.putAsync((Object)"k", (Object)"v", 3000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        assert (f != null);
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (f.isDone());
        this.verifyEviction("k", "v", 1000L, false);
        f = this.c.putAsync((Object)"k", (Object)"v", 3000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        assert (f != null);
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (f.isDone());
        this.verifyEviction("k", "v", 3000L, true);
        NotifyingFuture f2 = this.c.putAllAsync(Collections.singletonMap("k", "v3"), 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        assert (f2 != null);
        assert (!f2.isCancelled());
        assert (f2.get() == null);
        assert (f2.isDone());
        this.verifyEviction("k", "v3", 1000L, true);
        f2 = this.c.putAllAsync(Collections.singletonMap("k", "v4"), 3000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        assert (f2 != null);
        assert (!f2.isCancelled());
        assert (f2.get() == null);
        assert (f2.isDone());
        this.verifyEviction("k", "v4", 1000L, false);
        f2 = this.c.putAllAsync(Collections.singletonMap("k", "v5"), 3000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        assert (f2 != null);
        assert (!f2.isCancelled());
        assert (f2.get() == null);
        assert (f2.isDone());
        this.verifyEviction("k", "v5", 3000L, true);
        f = this.c.putAsync((Object)"k", (Object)"v3");
        Assert.assertNull(f.get());
        f = this.c.putIfAbsentAsync((Object)"k", (Object)"v4", 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        assert (f != null);
        assert (!f.isCancelled());
        Assert.assertEquals((Object)"v3", f.get());
        assert (f.isDone());
        assert (((String)this.c.get((Object)"k")).equals("v3"));
        assert (!((String)this.c.get((Object)"k")).equals("v4"));
        Thread.sleep(300L);
        assert (((String)this.c.get((Object)"k")).equals("v3"));
        f = this.c.removeAsync((Object)"k");
        assert (((String)f.get()).equals("v3"));
        assert (this.c.get((Object)"k") == null);
        f = this.c.putIfAbsentAsync((Object)"k", (Object)"v", 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        assert (f != null);
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (f.isDone());
        this.verifyEviction("k", "v", 1000L, true);
        f = this.c.putIfAbsentAsync((Object)"k", (Object)"v", 3000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        assert (f != null);
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (f.isDone());
        this.verifyEviction("k", "v", 1000L, false);
        f = this.c.putIfAbsentAsync((Object)"k", (Object)"v", 3000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        assert (f != null);
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (f.isDone());
        this.verifyEviction("k", "v", 3000L, true);
        f = this.c.replaceAsync((Object)"k", (Object)"v5", 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        assert (f != null);
        assert (!f.isCancelled());
        assert (f.get() == null);
        assert (f.isDone());
        assert (this.c.get((Object)"k") == null);
        this.c.put((Object)"k", (Object)"v");
        f = this.c.replaceAsync((Object)"k", (Object)"v5", 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        assert (f != null);
        assert (!f.isCancelled());
        assert (((String)f.get()).equals("v"));
        assert (f.isDone());
        this.verifyEviction("k", "v5", 1000L, true);
        this.c.put((Object)"k", (Object)"v");
        f = this.c.replaceAsync((Object)"k", (Object)"v5", 5000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        assert (f != null);
        assert (!f.isCancelled());
        assert (((String)f.get()).equals("v"));
        assert (f.isDone());
        this.verifyEviction("k", "v5", 1000L, false);
        this.c.put((Object)"k", (Object)"v");
        f = this.c.replaceAsync((Object)"k", (Object)"v5", 3000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        assert (f != null);
        assert (!f.isCancelled());
        assert (((String)f.get()).equals("v"));
        assert (f.isDone());
        this.verifyEviction("k", "v5", 3000L, true);
        this.c.put((Object)"k", (Object)"v5");
        NotifyingFuture f3 = this.c.replaceAsync((Object)"k", (Object)"v_nonexistent", (Object)"v6", 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        assert (f3 != null);
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(false));
        assert (f3.isDone());
        Thread.sleep(300L);
        assert (((String)this.c.get((Object)"k")).equals("v5"));
        f3 = this.c.replaceAsync((Object)"k", (Object)"v5", (Object)"v6", 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        assert (f3 != null);
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(true));
        assert (f3.isDone());
        this.verifyEviction("k", "v6", 1000L, true);
        this.c.put((Object)"k", (Object)"v5");
        f3 = this.c.replaceAsync((Object)"k", (Object)"v5", (Object)"v6", 5000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        assert (f3 != null);
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(true));
        assert (f3.isDone());
        this.verifyEviction("k", "v6", 1000L, false);
        this.c.put((Object)"k", (Object)"v5");
        f3 = this.c.replaceAsync((Object)"k", (Object)"v5", (Object)"v6", 3000L, TimeUnit.MILLISECONDS, 1000L, TimeUnit.MILLISECONDS);
        this.markStartTime();
        assert (f3 != null);
        assert (!f3.isCancelled());
        assert (((Boolean)f3.get()).equals(true));
        assert (f3.isDone());
        this.verifyEviction("k", "v6", 3000L, true);
    }

    private void markStartTime() {
        this.startTime = Util.currentMillisFromNanotime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyEviction(final String key, String expectedValue, long expectedLifetime, final boolean touchKey) {
        if (this.startTime == -1L) {
            throw new IllegalStateException("markStartTime() must be called before verifyEviction(..)");
        }
        long pollInterval = 50L;
        try {
            Assert.assertEquals((Object)expectedValue, (Object)this.c.get((Object)key));
            this.eventually(new AbstractInfinispanTest.Condition(){

                @Override
                public boolean isSatisfied() {
                    if (touchKey) {
                        return !AsyncAPITest.this.c.containsKey((Object)key);
                    }
                    return !AsyncAPITest.this.c.keySet().contains(key);
                }
            }, 3L * expectedLifetime, (int)(3L * expectedLifetime / 50L) + 1);
            long waitTime = Util.currentMillisFromNanotime() - this.startTime;
            Assert.assertNull((Object)this.c.get((Object)key));
            long lowerBound = expectedLifetime - expectedLifetime / 4L;
            long upperBound = expectedLifetime * 3L;
            Assert.assertTrue((String)("Wait time (" + waitTime + ") not within expected bounds [" + lowerBound + ", " + upperBound + "]"), (lowerBound <= waitTime && waitTime <= upperBound ? 1 : 0) != 0);
        }
        finally {
            this.startTime = -1L;
        }
    }
}

