/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api;

import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public abstract class BaseDistClearTest
extends MultipleCacheManagersTest {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected AdvancedCache<Integer, String> c0;
    protected AdvancedCache<Integer, String> c1;
    protected AdvancedCache<Integer, String> c2;
    private final ConfigurationBuilder builder;

    protected BaseDistClearTest(boolean transactional, boolean optimistic, boolean supportsConcurrentUpdates) {
        this.builder = BaseDistClearTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, transactional, transactional);
        this.builder.clustering().hash().numSegments(3).numOwners(2).stateTransfer().fetchInMemoryState(true).locking().lockAcquisitionTimeout(1000L).supportsConcurrentUpdates(supportsConcurrentUpdates);
        if (transactional) {
            this.builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).syncCommitPhase(true).syncRollbackPhase(true).lockingMode(optimistic ? LockingMode.OPTIMISTIC : LockingMode.PESSIMISTIC);
        }
    }

    @Override
    protected void createCacheManagers() throws Throwable {
        this.createCluster(this.builder, 3);
        this.waitForClusterToForm();
        this.c0 = this.advancedCache(0);
        this.c1 = this.advancedCache(1);
        this.c2 = this.advancedCache(2);
    }

    public void testClear() throws Exception {
        int numKeys = 5;
        this.log.infof("Putting %d keys into cache ..", (Object)5);
        for (int i = 0; i < 5; ++i) {
            String value = "val_" + i;
            this.c0.put((Object)i, (Object)value);
            Assert.assertEquals((Object)value, (Object)this.c0.get((Object)i));
            Assert.assertEquals((Object)value, (Object)this.c1.get((Object)i));
            Assert.assertEquals((Object)value, (Object)this.c2.get((Object)i));
        }
        this.log.info((Object)"Finished putting keys");
        DataContainer dc0 = this.c0.getDataContainer();
        DataContainer dc1 = this.c1.getDataContainer();
        DataContainer dc2 = this.c2.getDataContainer();
        Assert.assertTrue((dc0.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((dc1.size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((dc2.size() > 0 ? 1 : 0) != 0);
        this.log.info((Object)"Clearing cache ..");
        this.c0.clear();
        this.log.info((Object)"Finished clearing cache");
        Assert.assertEquals((long)0L, (long)dc0.size());
        Assert.assertEquals((long)0L, (long)dc1.size());
        Assert.assertEquals((long)0L, (long)dc2.size());
    }
}

