/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="config.TransactionalCacheConfigTest")
public class TransactionalCacheConfigTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        return TestCacheManagerFactory.createCacheManager(this.getDefaultStandaloneConfig(true));
    }

    public void test() {
        Configuration c = TestCacheManagerFactory.getDefaultConfiguration(false);
        assert (!c.isTransactionalCache());
        c.fluent().transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        assert (c.isTransactionalCache());
        c.fluent().transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        assert (!c.isTransactionalCache());
    }

    public void testTransactionModeOverride() {
        Configuration c = new Configuration();
        c.fluent().transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        Assert.assertEquals((Object)this.cacheManager.getCache().getConfiguration().getTransactionMode(), (Object)TransactionMode.TRANSACTIONAL);
        this.cacheManager.defineConfiguration("nonTx", c);
        Assert.assertEquals((Object)this.cacheManager.getCache("nonTx").getConfiguration().getTransactionMode(), (Object)TransactionMode.NON_TRANSACTIONAL);
    }

    public void testDefaults() {
        Configuration c = new Configuration();
        assert (!c.isTransactionalCache());
        this.assertTmLookupSet(c, false);
        c = TestCacheManagerFactory.getDefaultConfiguration(false);
        assert (!c.isTransactionalCache());
        this.assertTmLookupSet(c, false);
        c = TestCacheManagerFactory.getDefaultConfiguration(true);
        assert (c.isTransactionalCache());
        this.assertTmLookupSet(c, true);
        c = TestCacheManagerFactory.getDefaultConfiguration(false, Configuration.CacheMode.DIST_SYNC);
        assert (!c.isTransactionalCache());
        this.assertTmLookupSet(c, false);
        c = TestCacheManagerFactory.getDefaultConfiguration(true, Configuration.CacheMode.DIST_SYNC);
        assert (c.isTransactionalCache());
        this.assertTmLookupSet(c, true);
    }

    public void testTransactionalityInduced() {
        Configuration c = new Configuration();
        assert (!c.isTransactionalCache());
        c.setTransactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        assert (c.isTransactionalCache());
        c = new Configuration();
        assert (!c.isTransactionalCache());
        c.setTransactionManagerLookupClass(DummyTransactionManagerLookup.class.getName());
        assert (c.isTransactionalCache());
        c = new Configuration();
        assert (!c.isTransactionalCache());
        c.fluent().transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        assert (c.isTransactionalCache());
        c = new Configuration();
        assert (!c.isTransactionalCache());
        c.fluent().transaction().transactionManagerLookupClass(DummyTransactionManagerLookup.class);
        assert (c.isTransactionalCache());
        c = new Configuration();
        assert (!c.isTransactionalCache());
        c.fluent().invocationBatching();
        assert (c.isTransactionalCache());
        c = new Configuration();
        assert (!c.isTransactionalCache());
        c.setInvocationBatchingEnabled(true);
        assert (c.isTransactionalCache());
    }

    public void testInvocationBatchingAndInducedTm() {
        Configuration c = new Configuration();
        c.setInvocationBatchingEnabled(true);
        assert (c.isTransactionalCache());
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(c)){

            @Override
            public void call() {
                assert (this.cm.getCache().getAdvancedCache().getTransactionManager() != null);
            }
        });
    }

    public void testOverride() {
        final Configuration c = new Configuration();
        c.fluent().transaction().transactionMode(TransactionMode.TRANSACTIONAL).transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager()){

            @Override
            public void call() {
                this.cm.defineConfiguration("transactional", c);
                Cache cache = this.cm.getCache("transactional");
                assert (cache.getConfiguration().isTransactionalCache());
            }
        });
    }

    public void testBatchingAndTransactionalCache() {
        final Configuration c = new Configuration();
        c.fluent().invocationBatching();
        assert (c.isInvocationBatchingEnabled());
        assert (c.isTransactionalCache());
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager()){

            @Override
            public void call() {
                assert (!this.cm.getCache().getConfiguration().isTransactionalCache());
                this.cm.defineConfiguration("a", c);
                Cache a = this.cm.getCache("a");
                assert (a.getConfiguration().isInvocationBatchingEnabled());
                assert (a.getConfiguration().isTransactionalCache());
            }
        });
    }

    public void testBatchingAndTransactionalCache2() {
        final Configuration c = new Configuration();
        c.setInvocationBatchingEnabled(true);
        assert (c.isInvocationBatchingEnabled());
        assert (c.isTransactionalCache());
        TestingUtil.withCacheManager(new CacheManagerCallable(TestCacheManagerFactory.createCacheManager(new ConfigurationBuilder())){

            @Override
            public void call() {
                assert (!this.cm.getCache().getConfiguration().isTransactionalCache());
                this.cm.defineConfiguration("a", c);
                Cache a = this.cm.getCache("a");
                assert (a.getConfiguration().isInvocationBatchingEnabled());
                assert (a.getConfiguration().isTransactionalCache());
            }
        });
    }

    private void assertTmLookupSet(Configuration c, boolean b) {
        assert (b == (c.getTransactionManagerLookup() != null || c.getTransactionManagerLookupClass() != null));
    }
}

