/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.Future;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="container.versioning.TransactionalLocalWriteSkewTest")
public class TransactionalLocalWriteSkewTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).transactionMode(TransactionMode.TRANSACTIONAL).lockingMode(LockingMode.OPTIMISTIC).syncCommitPhase(true).locking().lockAcquisitionTimeout(50L).isolationLevel(IsolationLevel.REPEATABLE_READ).writeSkewCheck(true).versioning().enable().scheme(VersioningScheme.SIMPLE);
        return TestCacheManagerFactory.createCacheManager(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSharedCounter() throws Exception {
        int counterMaxValue = 1000;
        Cache c1 = this.cacheManager.getCache("cache");
        c1.put((Object)"counter", (Object)0);
        Assert.assertEquals((Object)0, (Object)c1.get((Object)"counter"));
        ConcurrentSkipListSet<Integer> uniqueValuesIncremented = new ConcurrentSkipListSet<Integer>();
        Future<Object> ict1 = this.fork((Runnable)new IncrementCounterTask((Cache<String, Integer>)c1, uniqueValuesIncremented, 1000), null);
        Future<Object> ict2 = this.fork((Runnable)new IncrementCounterTask((Cache<String, Integer>)c1, uniqueValuesIncremented, 1000), null);
        try {
            ict1.get();
            ict2.get();
            Assert.assertTrue(((Integer)c1.get((Object)"counter") >= 1000 ? 1 : 0) != 0);
        }
        finally {
            ict1.cancel(true);
            ict2.cancel(true);
        }
    }

    private class IncrementCounterTask
    implements Runnable {
        private Cache<String, Integer> cache;
        private ConcurrentSkipListSet<Integer> uniqueValuesSet;
        private TransactionManager transactionManager;
        private int lastValue;
        private int counterMaxValue;

        public IncrementCounterTask(Cache<String, Integer> cache, ConcurrentSkipListSet<Integer> uniqueValuesSet, int counterMaxValue) {
            this.cache = cache;
            this.transactionManager = cache.getAdvancedCache().getTransactionManager();
            this.uniqueValuesSet = uniqueValuesSet;
            this.lastValue = 0;
            this.counterMaxValue = counterMaxValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int failuresCounter = 0;
            while (this.lastValue < this.counterMaxValue && !Thread.interrupted()) {
                boolean success = false;
                try {
                    this.transactionManager.begin();
                    Integer value = (Integer)this.cache.get((Object)"counter");
                    value = value + 1;
                    this.lastValue = value;
                    this.cache.put((Object)"counter", (Object)value);
                    this.transactionManager.commit();
                    success = true;
                    boolean unique = this.uniqueValuesSet.add(value);
                    Assert.assertTrue((String)("Duplicate value found (value=" + this.lastValue + ")"), (boolean)unique);
                }
                catch (Exception e) {
                    Assert.assertTrue((String)"Too many failures incrementing the counter", (++failuresCounter < 10 * this.counterMaxValue ? 1 : 0) != 0);
                }
                finally {
                    if (success) continue;
                    try {
                        if (this.transactionManager.getStatus() == 6) continue;
                        this.transactionManager.rollback();
                    }
                    catch (Throwable t) {
                        TransactionalLocalWriteSkewTest.this.log.trace((Object)"Exception during rollback", t);
                    }
                }
            }
        }
    }
}

