/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.distexec.DistributedExecutionCompletionService;
import org.infinispan.distexec.DistributedExecutorService;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.util.concurrent.NotifyingFuture;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distexec.DistributedExecutionCompletionTest")
public class DistributedExecutionCompletionTest
extends BaseDistFunctionalTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        super.createCacheManagers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicInvocation() throws Exception {
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        try {
            DistributedExecutionCompletionService decs = new DistributedExecutionCompletionService((DistributedExecutorService)des);
            decs.submit((Callable)new SimpleCallable());
            NotifyingFuture future = decs.take();
            Integer r = (Integer)future.get();
            AssertJUnit.assertEquals((int)1, (int)r);
        }
        finally {
            des.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicDistributedCallableWitkKeys() throws Exception {
        this.c1.put((Object)"key1", (Object)"Manik");
        this.c1.put((Object)"key2", (Object)"Mircea");
        this.c1.put((Object)"key3", (Object)"Galder");
        this.c1.put((Object)"key4", (Object)"Sanne");
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        DistributedExecutionCompletionService decs = new DistributedExecutionCompletionService((DistributedExecutorService)des);
        try {
            decs.submit((Callable)((Object)new SimpleDistributedCallable(true)), (Object[])new String[]{"key1", "key2"});
            NotifyingFuture future = decs.take();
            Boolean r = (Boolean)future.get();
            assert (r.booleanValue());
        }
        finally {
            des.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedCallableEverywhereWithKeys() throws Exception {
        this.c1.put((Object)"key1", (Object)"Manik");
        this.c1.put((Object)"key2", (Object)"Mircea");
        this.c1.put((Object)"key3", (Object)"Galder");
        this.c1.put((Object)"key4", (Object)"Sanne");
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        DistributedExecutionCompletionService decs = new DistributedExecutionCompletionService((DistributedExecutorService)des);
        try {
            decs.submitEverywhere((Callable)((Object)new SimpleDistributedCallable(true)), (Object[])new String[]{"key1", "key2"});
            NotifyingFuture f = null;
            int counter = 0;
            while ((f = decs.poll(1L, TimeUnit.SECONDS)) != null) {
                assert (((Boolean)f.get()).booleanValue());
                ++counter;
            }
            AssertJUnit.assertTrue((String)"Counter greater than 0", (counter > 0 ? 1 : 0) != 0);
        }
        finally {
            des.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistributedCallableEverywhere() throws Exception {
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        DistributedExecutionCompletionService decs = new DistributedExecutionCompletionService((DistributedExecutorService)des);
        try {
            decs.submitEverywhere((Callable)((Object)new SimpleDistributedCallable(false)));
            NotifyingFuture f = null;
            int counter = 0;
            while ((f = decs.poll(1L, TimeUnit.SECONDS)) != null) {
                assert (((Boolean)f.get()).booleanValue());
                ++counter;
            }
            AssertJUnit.assertTrue((String)"Counter greater than 0", (counter > 0 ? 1 : 0) != 0);
        }
        finally {
            des.shutdownNow();
        }
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testBasicInvocationWithNullExecutor() throws Exception {
        DistributedExecutorService des = null;
        DistributedExecutionCompletionService decs = new DistributedExecutionCompletionService(des);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={NullPointerException.class})
    public void testBasicInvocationWithNullTask() throws Exception {
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        try {
            DistributedExecutionCompletionService decs = new DistributedExecutionCompletionService((DistributedExecutorService)des);
            decs.submit(null);
        }
        finally {
            des.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicInvocationWithBlockingQueue() throws Exception {
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        try {
            ArrayBlockingQueue queue = new ArrayBlockingQueue(10);
            DistributedExecutionCompletionService decs = new DistributedExecutionCompletionService((DistributedExecutorService)des, queue);
            decs.submit((Callable)new SimpleCallable());
            NotifyingFuture future = decs.take();
            Integer r = (Integer)future.get();
            AssertJUnit.assertEquals((Object)1, (Object)r);
        }
        finally {
            des.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicInvocationWithRunnable() throws Exception {
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        try {
            DistributedExecutionCompletionService decs = new DistributedExecutionCompletionService((DistributedExecutorService)des);
            Integer result = 5;
            decs.submit((Runnable)new SimpleRunnable(), (Object)result);
            NotifyingFuture future = decs.take();
            Integer r = (Integer)future.get();
            AssertJUnit.assertEquals((Object)result, (Object)r);
        }
        finally {
            des.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={NullPointerException.class})
    public void testBasicInvocationWithNullRunnable() throws Exception {
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        try {
            DistributedExecutionCompletionService decs = new DistributedExecutionCompletionService((DistributedExecutorService)des);
            Integer result = 5;
            decs.submit(null, (Object)result);
        }
        finally {
            des.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicPollInvocationWithSleepingCallable() throws Exception {
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        DistributedExecutionCompletionService decs = new DistributedExecutionCompletionService((DistributedExecutorService)des);
        try {
            decs.submit((Callable)new SimpleCallable(true, 5000L));
            NotifyingFuture callable = decs.poll();
            AssertJUnit.assertNull((Object)callable);
        }
        finally {
            des.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicTakeInvocationWithSleepingCallable() throws Exception {
        long sleepTime = 2000L;
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        DistributedExecutionCompletionService decs = new DistributedExecutionCompletionService((DistributedExecutorService)des);
        try {
            decs.submit((Callable)new SimpleCallable(true, sleepTime));
            long start = System.currentTimeMillis();
            NotifyingFuture callable = decs.take();
            long end = System.currentTimeMillis();
            assert (end - start >= sleepTime);
            AssertJUnit.assertEquals((Object)1, (Object)callable.get());
        }
        finally {
            des.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicPollInvocation() throws Exception {
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        DistributedExecutionCompletionService decs = new DistributedExecutionCompletionService((DistributedExecutorService)des);
        try {
            decs.submit((Callable)new SimpleCallable());
            NotifyingFuture callable = decs.poll(1000L, TimeUnit.MILLISECONDS);
            AssertJUnit.assertEquals((Object)1, (Object)callable.get());
        }
        finally {
            des.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicPollInvocationWithTimeout() throws Exception {
        DefaultExecutorService des = new DefaultExecutorService(this.c1);
        DistributedExecutionCompletionService decs = new DistributedExecutionCompletionService((DistributedExecutorService)des);
        try {
            decs.submit((Callable)new SimpleCallable(true, 5000L));
            NotifyingFuture callable = decs.poll(10L, TimeUnit.MILLISECONDS);
            AssertJUnit.assertNull((Object)callable);
        }
        finally {
            des.shutdownNow();
        }
    }

    static class SimpleRunnable
    implements Runnable,
    Serializable {
        SimpleRunnable() {
        }

        @Override
        public void run() {
            System.out.println("This is a runnable!");
        }
    }

    static class SimpleCallable
    implements Callable<Integer>,
    Serializable {
        private static final long serialVersionUID = -8589149500259272402L;
        private boolean shouldSleep = false;
        private long sleepTime;

        public SimpleCallable() {
        }

        public SimpleCallable(boolean shouldSleep, long sleepTime) {
            this.shouldSleep = shouldSleep;
            this.sleepTime = sleepTime;
        }

        @Override
        public Integer call() throws Exception {
            if (this.shouldSleep) {
                Thread.sleep(this.sleepTime);
            }
            return 1;
        }
    }

    static class SimpleDistributedCallable
    implements DistributedCallable<String, String, Boolean>,
    Serializable {
        private static final long serialVersionUID = 623845442163221832L;
        private boolean invokedProperly = false;
        private final boolean hasKeys;

        public SimpleDistributedCallable(boolean hasKeys) {
            this.hasKeys = hasKeys;
        }

        public Boolean call() throws Exception {
            return this.invokedProperly;
        }

        public void setEnvironment(Cache<String, String> cache, Set<String> inputKeys) {
            boolean keysProperlySet = this.hasKeys ? inputKeys != null && !inputKeys.isEmpty() : inputKeys != null && inputKeys.isEmpty();
            this.invokedProperly = cache != null && keysProperlySet;
        }

        public boolean validlyInvoked() {
            return this.invokedProperly;
        }
    }
}

