/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MortalCacheEntry;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.DistributionTestHelper;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TransportFlags;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.concurrent.IsolationLevel;

public abstract class BaseDistFunctionalTest
extends MultipleCacheManagersTest {
    protected String cacheName;
    protected int INIT_CLUSTER_SIZE = 4;
    protected Cache<Object, String> c1 = null;
    protected Cache<Object, String> c2 = null;
    protected Cache<Object, String> c3 = null;
    protected Cache<Object, String> c4 = null;
    protected ConfigurationBuilder configuration;
    protected List<Cache<Object, String>> caches;
    protected List<Address> cacheAddresses;
    protected boolean sync = true;
    protected boolean tx = false;
    protected boolean testRetVals = true;
    protected boolean l1CacheEnabled = true;
    protected boolean l1OnRehash = false;
    protected int l1Threshold = 5;
    protected boolean performRehashing = false;
    protected boolean batchingEnabled = false;
    protected int numOwners = 2;
    protected int lockTimeout = 45;
    protected boolean groupsEnabled = false;
    protected List<Grouper<?>> groupers;
    protected LockingMode lockingMode;
    protected boolean supportConcurrentWrites = true;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.cacheName = "dist";
        this.configuration = this.buildConfiguration();
        this.caches = this.createClusteredCaches(this.INIT_CLUSTER_SIZE, this.cacheName, this.configuration, new TransportFlags().withFD(false));
        if (this.INIT_CLUSTER_SIZE > 0) {
            this.c1 = this.caches.get(0);
        }
        if (this.INIT_CLUSTER_SIZE > 1) {
            this.c2 = this.caches.get(1);
        }
        if (this.INIT_CLUSTER_SIZE > 2) {
            this.c3 = this.caches.get(2);
        }
        if (this.INIT_CLUSTER_SIZE > 3) {
            this.c4 = this.caches.get(3);
        }
        this.cacheAddresses = new ArrayList<Address>(this.INIT_CLUSTER_SIZE);
        for (Cache<Object, String> cache : this.caches) {
            EmbeddedCacheManager cacheManager = cache.getCacheManager();
            this.cacheAddresses.add(cacheManager.getAddress());
        }
    }

    protected ConfigurationBuilder buildConfiguration() {
        ConfigurationBuilder configuration = BaseDistFunctionalTest.getDefaultClusteredCacheConfig(this.sync ? CacheMode.DIST_SYNC : CacheMode.DIST_ASYNC, this.tx);
        configuration.clustering().stateTransfer().fetchInMemoryState(this.performRehashing);
        if (this.lockingMode != null) {
            configuration.transaction().lockingMode(this.lockingMode);
        }
        configuration.clustering().hash().numOwners(this.numOwners);
        if (!this.testRetVals) {
            configuration.unsafe().unreliableReturnValues(true);
            configuration.locking().isolationLevel(IsolationLevel.REPEATABLE_READ);
        }
        if (this.tx) {
            configuration.invocationBatching().enable();
        }
        if (this.sync) {
            configuration.clustering().sync().replTimeout(60L, TimeUnit.SECONDS);
        }
        configuration.locking().lockAcquisitionTimeout((long)this.lockTimeout, TimeUnit.SECONDS);
        configuration.clustering().l1().enabled(this.l1CacheEnabled);
        if (this.groupsEnabled) {
            configuration.clustering().hash().groups().enabled(true);
            configuration.clustering().hash().groups().withGroupers(this.groupers);
        }
        if (this.l1CacheEnabled) {
            configuration.clustering().l1().onRehash(this.l1OnRehash).invalidationThreshold(this.l1Threshold);
        }
        configuration.locking().supportsConcurrentUpdates(this.supportConcurrentWrites);
        return configuration;
    }

    protected void initAndTest() {
        for (Cache<Object, String> c : this.caches) {
            assert (c.isEmpty());
        }
        this.c1.put((Object)"k1", (Object)"value");
        this.asyncWait("k1", PutKeyValueCommand.class, new Cache[0]);
        this.assertOnAllCachesAndOwnership("k1", "value");
    }

    protected Address addressOf(Cache<?, ?> cache) {
        return DistributionTestHelper.addressOf(cache);
    }

    protected Cache<Object, String> getFirstNonOwner(String key) {
        return this.getNonOwners(key)[0];
    }

    protected Cache<Object, String> getFirstOwner(String key) {
        return this.getOwners(key)[0];
    }

    protected Cache<Object, String> getSecondNonOwner(String key) {
        return this.getNonOwners(key)[1];
    }

    protected void assertOnAllCachesAndOwnership(Object key, String value) {
        this.assertOwnershipAndNonOwnership(key, this.l1CacheEnabled);
        this.assertOnAllCaches(key, value);
    }

    protected void assertRemovedOnAllCaches(Object key) {
        this.assertOnAllCaches(key, null);
    }

    protected void assertOnAllCaches(Object key, String value) {
        for (Cache<Object, String> c : this.caches) {
            Object realVal = c.get(key);
            if (value == null) {
                assert (realVal == null) : "Expecting [" + key + "] to equal [" + value + "] on cache [" + this.addressOf(c) + "] but was [" + realVal + "]. Owners are " + Arrays.toString(this.getOwners(key));
                continue;
            }
            assert (value.equals(realVal)) : "Expecting [" + key + "] to equal [" + value + "] on cache [" + this.addressOf(c) + "] but was [" + realVal + "]";
        }
        TestingUtil.sleepThread(1000L);
    }

    protected void assertOwnershipAndNonOwnership(Object key, boolean allowL1) {
        for (Cache<Object, String> c : this.caches) {
            DataContainer dc = c.getAdvancedCache().getDataContainer();
            InternalCacheEntry ice = dc.get(key);
            if (this.isOwner(c, key)) {
                assert (ice != null) : "Fail on owner cache " + this.addressOf(c) + ": dc.get(" + key + ") returned null!";
                assert (ice instanceof ImmortalCacheEntry) : "Fail on owner cache " + this.addressOf(c) + ": dc.get(" + key + ") returned " + this.safeType(ice);
                continue;
            }
            if (allowL1) {
                assert (ice == null || ice instanceof MortalCacheEntry) : "Fail on non-owner cache " + this.addressOf(c) + ": dc.get(" + key + ") returned " + this.safeType(ice);
                continue;
            }
            assert (ice == null) : "Fail on non-owner cache " + this.addressOf(c) + ": dc.get(" + key + ") returned " + ice + "!";
        }
    }

    protected String safeType(Object o) {
        return DistributionTestHelper.safeType(o);
    }

    protected void assertIsInL1(Cache<?, ?> cache, Object key) {
        DistributionTestHelper.assertIsInL1(cache, key);
    }

    protected void assertIsNotInL1(Cache<?, ?> cache, Object key) {
        DistributionTestHelper.assertIsNotInL1(cache, key);
    }

    protected void assertIsInContainerImmortal(Cache<?, ?> cache, Object key) {
        DistributionTestHelper.assertIsInContainerImmortal(cache, key);
    }

    protected void assertIsInL1OrNull(Cache<?, ?> cache, Object key) {
        DistributionTestHelper.assertIsInL1OrNull(cache, key);
    }

    protected boolean isOwner(Cache<?, ?> c, Object key) {
        return DistributionTestHelper.isOwner(c, key);
    }

    protected boolean isFirstOwner(Cache<?, ?> c, Object key) {
        return DistributionTestHelper.isFirstOwner(c, key);
    }

    protected Cache<Object, String>[] getOwners(Object key) {
        return this.getOwners(key, 2);
    }

    protected Cache<Object, String>[] getOwners(Object key, int expectedNumberOwners) {
        Cache[] owners = new Cache[expectedNumberOwners];
        int i = 0;
        for (Cache<Object, String> c : this.caches) {
            if (!this.isOwner(c, key)) continue;
            owners[i++] = c;
        }
        for (Cache c : owners) {
            assert (c != null) : "Have not found enough owners for key [" + key + "]";
        }
        return owners;
    }

    protected Cache<Object, String>[] getNonOwnersExcludingSelf(Object key, Address self) {
        Cache<Object, String>[] nonOwners = this.getNonOwners(key);
        boolean selfInArray = false;
        for (Cache<Object, String> c : nonOwners) {
            if (!this.addressOf(c).equals(self)) continue;
            selfInArray = true;
            break;
        }
        if (selfInArray) {
            Cache[] nonOwnersExclSelf = new Cache[nonOwners.length - 1];
            int i = 0;
            for (Cache<Object, String> c : nonOwners) {
                if (this.addressOf(c).equals(self)) continue;
                nonOwnersExclSelf[i++] = c;
            }
            return nonOwnersExclSelf;
        }
        return nonOwners;
    }

    protected Cache<Object, String>[] getNonOwners(Object key) {
        return this.getNonOwners(key, 2);
    }

    protected Cache<Object, String>[] getNonOwners(Object key, int expectedNumberNonOwners) {
        Cache[] nonOwners = new Cache[expectedNumberNonOwners];
        int i = 0;
        for (Cache<Object, String> c : this.caches) {
            if (this.isOwner(c, key)) continue;
            nonOwners[i++] = c;
        }
        return nonOwners;
    }

    protected List<Address> residentAddresses(Object key) {
        DistributionManager dm = (DistributionManager)this.c1.getAdvancedCache().getComponentRegistry().getComponent(DistributionManager.class);
        return dm.locate(key);
    }

    protected DistributionManager getDistributionManager(Cache<?, ?> c) {
        return (DistributionManager)c.getAdvancedCache().getComponentRegistry().getComponent(DistributionManager.class);
    }

    protected ConsistentHash getConsistentHash(Cache<?, ?> c) {
        return this.getDistributionManager(c).getConsistentHash();
    }

    protected void asyncWait(Object key, Class<? extends VisitableCommand> command, Cache<?, ?> ... caches) {
    }

    protected TransactionManager getTransactionManager(Cache<?, ?> cache) {
        return TestingUtil.getTransactionManager(cache);
    }
}

