/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution;

import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.distribution.BaseDistFunctionalTest;
import org.infinispan.distribution.MagicKey;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.locks.LockManager;
import org.testng.annotations.Test;

@Test(groups={"functional"}, enabled=false, testName="distribution.DistSyncTxFuncTest")
public class DistSyncTxFuncTest
extends BaseDistFunctionalTest {
    public DistSyncTxFuncTest() {
        this.sync = true;
        this.tx = true;
        this.testRetVals = true;
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected void asyncTxWait(Object ... keys) {
    }

    protected void init(MagicKey k1, MagicKey k2) {
        this.c2.put((Object)k1, (Object)"value1");
        this.asyncWait(k1, PutKeyValueCommand.class, this.c1, this.c3, this.c4);
        this.c2.put((Object)k2, (Object)"value2");
        this.asyncWait(k2, PutKeyValueCommand.class, this.c1, this.c3, this.c4);
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsInContainerImmortal(this.c2, k2);
        this.assertIsInContainerImmortal(this.c3, k2);
        this.assertIsNotInL1(this.c4, k1);
        this.assertIsNotInL1(this.c4, k2);
        this.assertIsNotInL1(this.c1, k2);
        this.assertIsNotInL1(this.c3, k1);
    }

    public void testTransactionsSpanningKeysCommit() throws Exception {
        MagicKey k1 = new MagicKey("k1", this.c1);
        MagicKey k2 = new MagicKey("k2", this.c2);
        this.init(k1, k2);
        TransactionManager tm4 = this.getTransactionManager(this.c4);
        this.asserLocked(this.c3, false, k1);
        tm4.begin();
        this.c4.put((Object)k1, (Object)"new_value1");
        this.c4.put((Object)k2, (Object)"new_value2");
        tm4.commit();
        this.asyncTxWait("new_value1", "new_value2");
        this.asserLocked(this.c3, false, k1);
        this.asserLocked(this.c3, false, k2);
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsInContainerImmortal(this.c2, k2);
        this.assertIsInContainerImmortal(this.c3, k2);
        this.assertIsInL1(this.c4, k1);
        this.assertIsInL1(this.c4, k2);
        this.assertIsNotInL1(this.c1, k2);
        this.assertIsNotInL1(this.c3, k1);
        this.asserLocked(this.c4, false, k1, k2);
        this.asserLocked(this.c3, false, k1);
        this.asserLocked(this.c3, false, k2);
        this.asserLocked(this.c1, false, k1, k2);
        this.asserLocked(this.c2, false, k1, k2);
        this.checkOwnership(k1, k2, "new_value1", "new_value2");
    }

    void asserLocked(Cache c, boolean isLocked, Object ... keys) {
        LockManager lm = TestingUtil.extractComponent(c, LockManager.class);
        for (Object key : keys) {
            assert (isLocked == lm.isLocked(key)) : " expecting key '" + key + "' to be " + (isLocked ? " locked " : "not locked + \n Lock owner is:" + lm.getOwner(key));
        }
    }

    protected void checkOwnership(MagicKey k1, MagicKey k2, String v1, String v2) {
        this.assertOnAllCachesAndOwnership(k1, v1);
        this.assertOnAllCachesAndOwnership(k2, v2);
        this.assertIsInL1(this.c4, k1);
        this.assertIsInL1(this.c4, k2);
        this.assertIsInL1(this.c1, k2);
        this.assertIsInL1(this.c3, k1);
    }

    public void testTransactionsSpanningKeysRollback() throws Exception {
        MagicKey k1 = new MagicKey("k1", this.c1);
        MagicKey k2 = new MagicKey("k2", this.c2);
        this.init(k1, k2);
        TransactionManager tm4 = this.getTransactionManager(this.c4);
        tm4.begin();
        this.c4.put((Object)k1, (Object)"new_value1");
        this.c4.put((Object)k2, (Object)"new_value2");
        tm4.rollback();
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsInContainerImmortal(this.c2, k2);
        this.assertIsInContainerImmortal(this.c3, k2);
        this.assertIsNotInL1(this.c4, k1);
        this.assertIsNotInL1(this.c4, k2);
        this.assertIsNotInL1(this.c1, k2);
        this.assertIsNotInL1(this.c3, k1);
        this.checkOwnership(k1, k2, "value1", "value2");
    }

    public void testPutFromNonOwner() throws Exception {
        MagicKey k1 = new MagicKey("k1", this.c1);
        MagicKey k2 = new MagicKey("k2", this.c2);
        this.init(k1, k2);
        TransactionManager tm4 = this.getTransactionManager(this.c4);
        tm4.begin();
        Object ret = this.c4.put((Object)k1, (Object)"new_value");
        if (this.testRetVals) assert ("value1".equals(ret));
        ret = this.c4.put((Object)k2, (Object)"new_value");
        if (this.testRetVals) assert ("value2".equals(ret));
        tm4.rollback();
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsInContainerImmortal(this.c2, k2);
        this.assertIsInContainerImmortal(this.c3, k2);
        this.assertIsNotInL1(this.c4, k1);
        this.assertIsNotInL1(this.c4, k2);
        this.assertIsNotInL1(this.c1, k2);
        this.assertIsNotInL1(this.c3, k1);
        this.checkOwnership(k1, k2, "value1", "value2");
    }

    public void testPutIfAbsentFromNonOwner() throws Exception {
        MagicKey k1 = new MagicKey("k1", this.c1);
        MagicKey k2 = new MagicKey("k2", this.c2);
        this.init(k1, k2);
        TransactionManager tm4 = this.getTransactionManager(this.c4);
        LockManager lockManager4 = TestingUtil.extractComponent(this.c4, LockManager.class);
        tm4.begin();
        Object ret = this.c4.putIfAbsent((Object)k1, (Object)"new_value");
        if (this.testRetVals) assert ("value1".equals(ret)) : "Was expecting value1 but was " + ret;
        ret = this.c4.putIfAbsent((Object)k2, (Object)"new_value");
        if (this.testRetVals) assert ("value2".equals(ret)) : "Was expecting value2 but was " + ret;
        assert (((String)this.c4.get((Object)k1)).equals("value1"));
        assert (((String)this.c4.get((Object)k2)).equals("value2"));
        assert (lockManager4.isLocked((Object)k1));
        assert (lockManager4.isLocked((Object)k2));
        tm4.rollback();
        assert (!lockManager4.isLocked((Object)k1));
        assert (!lockManager4.isLocked((Object)k2));
        assert (((String)this.c2.get((Object)k1)).equals("value1"));
        assert (((String)this.c2.get((Object)k2)).equals("value2"));
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsInContainerImmortal(this.c2, k2);
        this.assertIsInContainerImmortal(this.c3, k2);
        this.assertIsNotInL1(this.c4, k1);
        this.assertIsNotInL1(this.c4, k2);
        this.assertIsNotInL1(this.c1, k2);
        this.assertIsNotInL1(this.c3, k1);
        this.checkOwnership(k1, k2, "value1", "value2");
    }

    public void testRemoveFromNonOwner() throws Exception {
        MagicKey k1 = new MagicKey("k1", this.c1);
        MagicKey k2 = new MagicKey("k2", this.c2);
        this.init(k1, k2);
        this.asserLocked(this.c1, false, k1, k2);
        this.asserLocked(this.c2, false, k1, k2);
        this.asserLocked(this.c3, false, k1, k2);
        this.asserLocked(this.c4, false, k1, k2);
        this.log.info((Object)"***** Here it starts!");
        TransactionManager tm4 = this.getTransactionManager(this.c4);
        tm4.begin();
        Object ret = this.c4.remove((Object)k1);
        if (this.testRetVals) assert ("value1".equals(ret));
        ret = this.c4.remove((Object)k2);
        if (this.testRetVals) assert ("value2".equals(ret));
        assert (!this.c4.containsKey((Object)k1));
        assert (!this.c4.containsKey((Object)k2));
        tm4.rollback();
        this.log.info((Object)"----- Here it ends!");
        this.asserLocked(this.c1, false, k1, k2);
        this.asserLocked(this.c2, false, k1, k2);
        this.asserLocked(this.c3, false, k1, k2);
        this.asserLocked(this.c4, false, k1);
        this.asserLocked(this.c4, false, k2);
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsInContainerImmortal(this.c2, k2);
        this.assertIsInContainerImmortal(this.c3, k2);
        this.asserLocked(this.c1, false, k1, k2);
        this.asserLocked(this.c2, false, k1, k2);
        this.asserLocked(this.c3, false, k1, k2);
        this.asserLocked(this.c4, false, k1, k2);
        this.assertIsNotInL1(this.c4, k1);
        this.assertIsNotInL1(this.c4, k2);
        this.assertIsNotInL1(this.c1, k2);
        this.assertIsNotInL1(this.c3, k1);
        this.asserLocked(this.c1, false, k1, k2);
        this.asserLocked(this.c2, false, k1, k2);
        this.asserLocked(this.c3, false, k1, k2);
        this.asserLocked(this.c4, false, k1, k2);
        this.checkOwnership(k1, k2, "value1", "value2");
    }

    public void testConditionalRemoveFromNonOwner() throws Exception {
        MagicKey k1 = new MagicKey("k1", this.c1);
        MagicKey k2 = new MagicKey("k2", this.c2);
        this.init(k1, k2);
        TransactionManager tm4 = this.getTransactionManager(this.c4);
        tm4.begin();
        boolean ret = this.c4.remove((Object)k1, (Object)"valueX");
        if (this.testRetVals) assert (!ret);
        ret = this.c4.remove((Object)k2, (Object)"valueX");
        if (this.testRetVals) assert (!ret);
        assert (this.c4.containsKey((Object)k1));
        assert (this.c4.containsKey((Object)k2));
        ret = this.c4.remove((Object)k1, (Object)"value1");
        if (this.testRetVals) assert (ret);
        ret = this.c4.remove((Object)k2, (Object)"value2");
        if (this.testRetVals) assert (ret);
        assert (!this.c4.containsKey((Object)k1));
        assert (!this.c4.containsKey((Object)k2));
        tm4.rollback();
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsInContainerImmortal(this.c2, k2);
        this.assertIsInContainerImmortal(this.c3, k2);
        this.assertIsNotInL1(this.c4, k1);
        this.assertIsNotInL1(this.c4, k2);
        this.assertIsNotInL1(this.c1, k2);
        this.assertIsNotInL1(this.c3, k1);
        this.checkOwnership(k1, k2, "value1", "value2");
    }

    public void testReplaceFromNonOwner() throws Exception {
        MagicKey k1 = new MagicKey("k1", this.c1);
        MagicKey k2 = new MagicKey("k2", this.c2);
        this.init(k1, k2);
        TransactionManager tm4 = this.getTransactionManager(this.c4);
        tm4.begin();
        Object ret = this.c4.replace((Object)k1, (Object)"new_value");
        if (this.testRetVals) assert ("value1".equals(ret));
        ret = this.c4.replace((Object)k2, (Object)"new_value");
        if (this.testRetVals) assert ("value2".equals(ret));
        assert ("new_value".equals(this.c4.get((Object)k1)));
        assert ("new_value".equals(this.c4.get((Object)k2)));
        tm4.rollback();
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsInContainerImmortal(this.c2, k2);
        this.assertIsInContainerImmortal(this.c3, k2);
        this.assertIsNotInL1(this.c4, k1);
        this.assertIsNotInL1(this.c4, k2);
        this.assertIsNotInL1(this.c1, k2);
        this.assertIsNotInL1(this.c3, k1);
        this.checkOwnership(k1, k2, "value1", "value2");
    }

    public void testConditionalReplaceFromNonOwner() throws Exception {
        MagicKey k1 = new MagicKey("k1", this.c1);
        MagicKey k2 = new MagicKey("k2", this.c2);
        this.init(k1, k2);
        TransactionManager tm4 = this.getTransactionManager(this.c4);
        tm4.begin();
        boolean ret = this.c4.replace((Object)k1, (Object)"valueX", (Object)"new_value");
        if (this.testRetVals) assert (!ret);
        ret = this.c4.replace((Object)k2, (Object)"valueX", (Object)"new_value");
        if (this.testRetVals) assert (!ret);
        assert ("value1".equals(this.c4.get((Object)k1)));
        assert ("value2".equals(this.c4.get((Object)k2)));
        ret = this.c4.replace((Object)k1, (Object)"value1", (Object)"new_value");
        if (this.testRetVals) assert (ret);
        ret = this.c4.replace((Object)k2, (Object)"value2", (Object)"new_value");
        if (this.testRetVals) assert (ret);
        assert ("new_value".equals(this.c4.get((Object)k1)));
        assert ("new_value".equals(this.c4.get((Object)k2)));
        tm4.rollback();
        this.assertIsInContainerImmortal(this.c1, k1);
        this.assertIsInContainerImmortal(this.c2, k1);
        this.assertIsInContainerImmortal(this.c2, k2);
        this.assertIsInContainerImmortal(this.c3, k2);
        this.assertIsNotInL1(this.c4, k1);
        this.assertIsNotInL1(this.c4, k2);
        this.assertIsNotInL1(this.c1, k2);
        this.assertIsNotInL1(this.c3, k1);
        this.checkOwnership(k1, k2, "value1", "value2");
    }
}

