/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.distribution.ch.DefaultConsistentHash;
import org.infinispan.distribution.ch.IndexedJGroupsAddress;
import org.infinispan.distribution.ch.OwnershipStatistics;
import org.infinispan.distribution.ch.SyncConsistentHashFactory;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractInfinispanTest;
import org.jgroups.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="distribution.ch.SyncConsistentHashFactoryKeyDistributionTest", groups={"manual"}, enabled=false, description="See the results in vnodes_key_dist.txt")
public class SyncConsistentHashFactoryKeyDistributionTest
extends AbstractInfinispanTest {
    public static final int[] NUM_NODES = new int[]{2, 4, 8, 16, 32, 48, 64, 128, 256};
    public static final int[] NUM_SEGMENTS = new int[]{64, 256, 1024, 4096, 163841};
    public static final int NUM_OWNERS = 2;
    public static final int LOOPS = 2000;
    public static final double[] INTERVALS = new double[]{1.25};
    public static final double[] INTERVALS_PRIMARY = new double[]{1.5};
    public static final double[] PERCENTILES = new double[]{0.999};

    private DefaultConsistentHash createConsistentHash(int numSegments, int numOwners, int numNodes) {
        MurmurHash3 hash = new MurmurHash3();
        SyncConsistentHashFactory chf = new SyncConsistentHashFactory();
        DefaultConsistentHash ch = chf.create((Hash)hash, numOwners, numSegments, this.createAddresses(numNodes));
        return ch;
    }

    private List<Address> createAddresses(int numNodes) {
        ArrayList<Address> addresses = new ArrayList<Address>(numNodes);
        for (int i = 0; i < numNodes; ++i) {
            addresses.add((Address)new IndexedJGroupsAddress((org.jgroups.Address)UUID.randomUUID(), i));
        }
        return addresses;
    }

    public void testDistribution() {
        for (int nn : NUM_NODES) {
            TreeMap<String, Map<Integer, String>> metrics = new TreeMap<String, Map<Integer, String>>();
            for (int ns : NUM_SEGMENTS) {
                for (Map.Entry<String, String> entry : this.computeMetrics(ns, 2, nn).entrySet()) {
                    String metricName = entry.getKey();
                    String metricValue = entry.getValue();
                    HashMap<Integer, String> metric = (HashMap<Integer, String>)metrics.get(metricName);
                    if (metric == null) {
                        metric = new HashMap<Integer, String>();
                        metrics.put(metricName, metric);
                    }
                    metric.put(ns, metricValue);
                }
            }
            this.printMetrics(nn, metrics);
        }
    }

    private void printMetrics(int nn, Map<String, Map<Integer, String>> metrics) {
        System.out.printf("Distribution for %3d nodes\n===\n", nn);
        System.out.printf("%54s = ", "Segments");
        for (int i = 0; i < NUM_SEGMENTS.length; ++i) {
            System.out.printf("%7d", NUM_SEGMENTS[i]);
        }
        System.out.println();
        for (Map.Entry<String, Map<Integer, String>> entry : metrics.entrySet()) {
            String metricName = entry.getKey();
            Map<Integer, String> metricValues = entry.getValue();
            System.out.printf("%54s = ", metricName);
            for (int i = 0; i < NUM_SEGMENTS.length; ++i) {
                System.out.print(metricValues.get(NUM_SEGMENTS[i]));
            }
            System.out.println();
        }
        System.out.println();
    }

    private Map<String, String> computeMetrics(int numSegments, int numOwners, int numNodes) {
        HashMap<String, String> metrics = new HashMap<String, String>();
        long[] distribution = new long[2000 * numNodes];
        long[] distributionPrimary = new long[2000 * numNodes];
        int distIndex = 0;
        for (int i = 0; i < 2000; ++i) {
            DefaultConsistentHash ch = this.createConsistentHash(numSegments, numOwners, numNodes);
            OwnershipStatistics stats = new OwnershipStatistics(ch, ch.getMembers());
            for (Address node : ch.getMembers()) {
                distribution[distIndex] = stats.getOwned(node);
                distributionPrimary[distIndex] = stats.getPrimaryOwned(node);
                ++distIndex;
            }
        }
        Arrays.sort(distribution);
        Arrays.sort(distributionPrimary);
        this.addMetrics(metrics, "Any owner:", numSegments, numOwners, numNodes, distribution, INTERVALS);
        this.addMetrics(metrics, "Primary:", numSegments, 1, numNodes, distributionPrimary, INTERVALS_PRIMARY);
        return metrics;
    }

    private void addMetrics(Map<String, String> metrics, String prefix, int numSegments, int numOwners, int numNodes, long[] distribution, double[] intervals) {
        int i;
        int i2;
        double mean = 0.0;
        long sum = 0L;
        for (long x : distribution) {
            sum += x;
        }
        Assert.assertEquals((long)sum, (long)(2000L * (long)numOwners * (long)numSegments));
        mean = sum / (long)numNodes / 2000L;
        double variance = 0.0;
        for (long x : distribution) {
            variance += ((double)x - mean) * ((double)x - mean);
        }
        double stdDev = Math.sqrt(variance);
        long max = distribution[distribution.length - 1];
        this.addDoubleMetric(metrics, prefix + " max(num_keys(node)/mean)", (double)max / mean);
        double[] intervalConfidence = new double[intervals.length];
        int intervalIndex = 0;
        for (i2 = 0; i2 < distribution.length; ++i2) {
            long x = distribution[i2];
            if (!((double)x > intervals[intervalIndex] * mean)) continue;
            intervalConfidence[intervalIndex] = (double)i2 / (double)distribution.length;
            if (++intervalIndex >= intervals.length) break;
        }
        for (i2 = intervalIndex; i2 < intervals.length; ++i2) {
            intervalConfidence[i2] = 1.0;
        }
        for (i2 = 0; i2 < intervals.length; ++i2) {
            if (intervals[i2] < 1.0) {
                this.addPercentageMetric(metrics, String.format("%s P(num_keys(node) < %3.2f * mean)", prefix, intervals[i2]), intervalConfidence[i2]);
                continue;
            }
            this.addPercentageMetric(metrics, String.format("%s P(num_keys(node) > %3.2f * mean)", prefix, intervals[i2]), 1.0 - intervalConfidence[i2]);
        }
        double[] percentiles = new double[PERCENTILES.length];
        for (i = 0; i < PERCENTILES.length; ++i) {
            percentiles[i] = (double)distribution[(int)Math.ceil(PERCENTILES[i] * (double)(2000 * numNodes + 1))] / mean;
        }
        for (i = 0; i < PERCENTILES.length; ++i) {
            this.addDoubleMetric(metrics, String.format("%s P(num_keys(node) <= x * mean) = %5.2f%% => x", prefix, PERCENTILES[i] * 100.0), percentiles[i]);
        }
    }

    private void addDoubleMetric(Map<String, String> metrics, String name, double value) {
        metrics.put(name, String.format("%7.3f", value));
    }

    private void addPercentageMetric(Map<String, String> metrics, String name, double value) {
        metrics.put(name, String.format("%6.2f%%", value * 100.0));
    }
}

