/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.topologyaware;

import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.distribution.DistSyncFuncTest;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.test.fwk.TransportFlags;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="distribution.TopologyAwareChFunctionalTest")
public class TopologyAwareChFunctionalTest
extends DistSyncFuncTest {
    @Override
    protected EmbeddedCacheManager addClusterEnabledCacheManager(TransportFlags flags) {
        String machine;
        String rack;
        int index = this.cacheManagers.size();
        switch (index) {
            case 0: {
                rack = "r0";
                machine = "m0";
                break;
            }
            case 1: {
                rack = "r0";
                machine = "m1";
                break;
            }
            case 2: {
                rack = "r1";
                machine = "m0";
                break;
            }
            case 3: {
                rack = "r2";
                machine = "m0";
                break;
            }
            default: {
                throw new RuntimeException("Bad!");
            }
        }
        GlobalConfiguration gc = GlobalConfiguration.getClusteredDefault();
        gc.setRackId(rack);
        gc.setMachineId(machine);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(gc, new Configuration());
        this.cacheManagers.add(cm);
        return cm;
    }

    public void testHashesInitiated() {
        ConsistentHash hash = this.advancedCache(0, this.cacheName).getDistributionManager().getConsistentHash();
        this.containsAllHashes(hash);
        this.containsAllHashes(this.advancedCache(1, this.cacheName).getDistributionManager().getConsistentHash());
        this.containsAllHashes(this.advancedCache(2, this.cacheName).getDistributionManager().getConsistentHash());
        this.containsAllHashes(this.advancedCache(3, this.cacheName).getDistributionManager().getConsistentHash());
    }

    private void containsAllHashes(ConsistentHash ch) {
        assert (ch.getMembers().contains(this.address(0)));
        assert (ch.getMembers().contains(this.address(1)));
        assert (ch.getMembers().contains(this.address(2)));
        assert (ch.getMembers().contains(this.address(3)));
    }
}

