/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction;

import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStoreConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="eviction.ConcurrentPassivationActivationTest")
public class ConcurrentPassivationActivationTest
extends SingleCacheManagerTest {
    final CountDownLatch passivateWait = new CountDownLatch(1);
    final CountDownLatch activationWait = new CountDownLatch(1);

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.eviction().strategy(EvictionStrategy.LRU).maxEntries(1).jmxStatistics().enable().loaders().passivation(true).addLoader(DummyInMemoryCacheStoreConfigurationBuilder.class);
        return TestCacheManagerFactory.createCacheManager(builder);
    }

    public void testInMemoryEntryNotLostWithConcurrentActivePassive() throws Exception {
        ActivationManager activation = TestingUtil.extractComponent(this.cache, ActivationManager.class);
        PassivationManager passivation = TestingUtil.extractComponent(this.cache, PassivationManager.class);
        this.cache.addListener((Object)new SlowPassivator());
        AssertJUnit.assertEquals((long)0L, (long)activation.getActivationCount());
        AssertJUnit.assertEquals((long)0L, (long)passivation.getPassivationCount());
        this.cache.put((Object)1, (Object)"v1");
        AssertJUnit.assertEquals((long)0L, (long)activation.getActivationCount());
        AssertJUnit.assertEquals((long)0L, (long)passivation.getPassivationCount());
        ExecutorService exec = Executors.newFixedThreadPool(2);
        Future<Object> passivatorFuture = exec.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ConcurrentPassivationActivationTest.this.log.debug((Object)"Store another entry and force previous to be passivated");
                ConcurrentPassivationActivationTest.this.cache.put((Object)2, (Object)"v2");
                return null;
            }
        });
        Future<Object> activatorFuture = exec.submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ConcurrentPassivationActivationTest.this.log.debug((Object)"Retrieve entry and force activation");
                ConcurrentPassivationActivationTest.this.activationWait.await(60L, TimeUnit.SECONDS);
                AssertJUnit.assertEquals((Object)"v1", (Object)ConcurrentPassivationActivationTest.this.cache.get((Object)1));
                return null;
            }
        });
        activatorFuture.get(30L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((long)0L, (long)activation.getActivationCount());
        AssertJUnit.assertEquals((long)1L, (long)passivation.getPassivationCount());
        this.passivateWait.countDown();
        passivatorFuture.get(30L, TimeUnit.SECONDS);
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cache.get((Object)1));
        AssertJUnit.assertEquals((long)1L, (long)activation.getActivationCount());
        AssertJUnit.assertEquals((long)2L, (long)passivation.getPassivationCount());
    }

    @Listener
    public class SlowPassivator {
        @CacheEntryPassivated
        public void passivate(CacheEntryPassivatedEvent event) throws Exception {
            if (!event.isPre()) {
                ConcurrentPassivationActivationTest.this.log.debugf("Entry stored in cache store, wait before removing from memory", new Object[0]);
                ConcurrentPassivationActivationTest.this.activationWait.countDown();
                ConcurrentPassivationActivationTest.this.passivateWait.await(60L, TimeUnit.SECONDS);
            }
        }
    }
}

