/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction;

import java.util.concurrent.TimeUnit;
import org.infinispan.AdvancedCache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.BaseEvictionFunctionalTest;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="eviction.EvictionDuringBatchTest")
@CleanupAfterMethod
public class EvictionDuringBatchTest
extends SingleCacheManagerTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfgBuilder = new ConfigurationBuilder();
        cfgBuilder.eviction().strategy(EvictionStrategy.LRU).maxEntries(128).expiration().wakeUpInterval(100L).locking().useLockStriping(false).invocationBatching().enable(true);
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager(cfgBuilder);
        this.cache = cm.getCache();
        this.cache.addListener((Object)new BaseEvictionFunctionalTest.EvictionListener());
        return cm;
    }

    public void testEvictionDuringBatchOperations() throws Exception {
        AdvancedCache advancedCache = this.cache.getAdvancedCache();
        for (int i = 0; i < 512; ++i) {
            advancedCache.startBatch();
            this.cache.put((Object)("key-" + (i + 1)), (Object)("value-" + (i + 1)), 1L, TimeUnit.MINUTES);
            advancedCache.endBatch(true);
        }
        Thread.sleep(1000L);
        int cacheSize = this.cache.size();
        Assert.assertTrue((String)"no data in cache! all state lost?", (cacheSize != 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("cache size too big: " + cacheSize), (cacheSize < 512 ? 1 : 0) != 0);
    }

    public void testEvictInBatch() throws Exception {
        this.cache().put((Object)"myKey", (Object)"myValue");
        this.cache().getAdvancedCache().startBatch();
        this.cache().evict((Object)"myKey");
        this.cache().getAdvancedCache().endBatch(true);
        Assert.assertFalse((boolean)this.cache().containsKey((Object)"myKey"));
    }
}

