/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lock.singlelock;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.config.Configuration;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.mocks.ControlledCommandFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="lock.singlelock.NoPrepareRpcForPessimisticTransactionsTest")
public class NoPrepareRpcForPessimisticTransactionsTest
extends MultipleCacheManagersTest {
    private Object k1;
    private ControlledCommandFactory commandFactory;

    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration c = NoPrepareRpcForPessimisticTransactionsTest.getDefaultClusteredConfig(Configuration.CacheMode.DIST_SYNC, true);
        c.fluent().transaction().lockingMode(LockingMode.PESSIMISTIC);
        c.fluent().hash().numOwners(Integer.valueOf(1));
        c.fluent().l1().disable();
        this.createCluster(c, 2);
        this.waitForClusterToForm();
        this.k1 = this.getKeyForCache(1);
        this.commandFactory = ControlledCommandFactory.registerControlledCommandFactory(this.cache(1), CommitCommand.class);
    }

    @BeforeMethod
    void clearStats() {
        this.commandFactory.remoteCommandsReceived.set(0);
    }

    public void testSingleGetOnPut() throws Exception {
        Operation o = new Operation(){

            @Override
            public void execute() {
                NoPrepareRpcForPessimisticTransactionsTest.this.cache(0).put(NoPrepareRpcForPessimisticTransactionsTest.this.k1, (Object)"v0");
            }
        };
        this.runtTest(o);
    }

    public void testSingleGetOnRemove() throws Exception {
        Operation o = new Operation(){

            @Override
            public void execute() {
                NoPrepareRpcForPessimisticTransactionsTest.this.cache(0).remove(NoPrepareRpcForPessimisticTransactionsTest.this.k1);
            }
        };
        this.runtTest(o);
    }

    private void runtTest(Operation o) throws NotSupportedException, SystemException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        this.log.trace((Object)"Here is where the fun starts..");
        this.tm(0).begin();
        o.execute();
        this.assertKeyLockedCorrectly(this.k1);
        Assert.assertEquals((int)this.commandFactory.remoteCommandsReceived.get(), (int)2, (String)"2 = cluster get + lock");
        this.tm(0).commit();
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return ((NoPrepareRpcForPessimisticTransactionsTest)NoPrepareRpcForPessimisticTransactionsTest.this).commandFactory.remoteCommandsReceived.get() == 4;
            }
        });
    }

    private static interface Operation {
        public void execute();
    }
}

