/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.replication;

import java.io.Serializable;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheException;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.marshall.NotSerializableException;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.tm.DummyTransactionManager;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="replication.ReplicationExceptionTest")
public class ReplicationExceptionTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration configuration = ReplicationExceptionTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC, true).fluent().locking().isolationLevel(IsolationLevel.REPEATABLE_READ).lockAcquisitionTimeout(Long.valueOf(60000L)).transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).build();
        this.createClusteredCaches(2, "syncReplCache", configuration);
        this.waitForClusterToForm("syncReplCache");
        Configuration noTx = ReplicationExceptionTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC, false).fluent().locking().isolationLevel(IsolationLevel.REPEATABLE_READ).lockAcquisitionTimeout(Long.valueOf(60000L)).build();
        this.defineConfigurationOnAllManagers("syncReplCacheNoTx", noTx);
        Configuration replAsync = ReplicationExceptionTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_ASYNC, true);
        this.defineConfigurationOnAllManagers("asyncReplCache", replAsync);
        Configuration replAsyncNoTx = ReplicationExceptionTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_ASYNC, false);
        this.defineConfigurationOnAllManagers("asyncReplCacheNoTx", replAsyncNoTx);
        Configuration replQueue = ReplicationExceptionTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_ASYNC, true).fluent().clustering().async().useReplQueue(Boolean.valueOf(true)).transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).build();
        this.defineConfigurationOnAllManagers("replQueueCache", replQueue);
        Configuration asyncMarshall = ReplicationExceptionTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_ASYNC, true).fluent().clustering().async().asyncMarshalling(Boolean.valueOf(true)).transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup()).build();
        this.defineConfigurationOnAllManagers("asyncMarshallCache", asyncMarshall);
    }

    private TransactionManager beginTransaction() throws SystemException, NotSupportedException {
        AdvancedCache cache1 = this.cache(0, "syncReplCache").getAdvancedCache();
        TransactionManager mgr = TestingUtil.getTransactionManager((Cache)cache1);
        mgr.begin();
        return mgr;
    }

    public void testNonSerializableRepl() throws Exception {
        this.doNonSerializableReplTest("syncReplCacheNoTx");
    }

    public void testNonSerializableAsyncRepl() throws Exception {
        this.doNonSerializableReplTest("asyncReplCacheNoTx");
    }

    public void testNonSerializableReplQueue() throws Exception {
        this.doNonSerializableReplTest("replQueueCache");
    }

    public void testNonSerializableAsyncMarshalling() throws Exception {
        this.doNonSerializableReplTest("asyncMarshallCache");
    }

    private void doNonSerializableReplTest(String cacheName) {
        AdvancedCache cache1 = this.cache(0, cacheName).getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, cacheName).getAdvancedCache();
        try {
            cache1.put((Object)"test", (Object)new ContainerData());
            AssertJUnit.assertNotNull((String)"NonSerializableData should not be null on cache2", (Object)cache2.get((Object)"test"));
        }
        catch (RuntimeException runtime) {
            Throwable t = runtime.getCause();
            if (runtime instanceof NotSerializableException || t instanceof NotSerializableException || t.getCause() instanceof NotSerializableException) {
                System.out.println("received NotSerializableException - as expected");
            }
            throw runtime;
        }
    }

    public void testNonSerializableReplWithTx() throws Exception {
        AdvancedCache cache1 = this.cache(0, "syncReplCache").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "syncReplCache").getAdvancedCache();
        try {
            TransactionManager tm = this.beginTransaction();
            cache1.put((Object)"test", (Object)new ContainerData());
            tm.commit();
            AssertJUnit.assertNotNull((String)"NonSerializableData should not be null on cache2", (Object)cache2.get((Object)"test"));
        }
        catch (RollbackException rollback) {
            System.out.println("received RollbackException - as expected");
        }
        catch (Exception e) {
            AssertJUnit.fail((String)e.toString());
        }
    }

    @Test(groups={"functional"}, expectedExceptions={CacheException.class})
    public void testSyncReplTimeout() {
        AdvancedCache cache1 = this.cache(0, "syncReplCache").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "syncReplCache").getAdvancedCache();
        cache2.addInterceptor(new CommandInterceptor(){

            protected Object handleDefault(InvocationContext ctx, VisitableCommand cmd) throws Throwable {
                Thread.sleep(100L);
                return super.handleDefault(ctx, cmd);
            }
        }, 0);
        cache1.getCacheConfiguration().clustering().sync().replTimeout(10L);
        cache2.getCacheConfiguration().clustering().sync().replTimeout(10L);
        TestingUtil.blockUntilViewsReceived(10000L, new Cache[]{cache1, cache2});
        cache1.put((Object)"k", (Object)"v");
    }

    @Test(groups={"functional"}, expectedExceptions={CacheException.class})
    public void testLockAcquisitionTimeout() throws Exception {
        AdvancedCache cache1 = this.cache(0, "syncReplCache").getAdvancedCache();
        AdvancedCache cache2 = this.cache(1, "syncReplCache").getAdvancedCache();
        cache1.getConfiguration().setLockAcquisitionTimeout(10L);
        cache2.getConfiguration().setLockAcquisitionTimeout(10L);
        TestingUtil.blockUntilViewsReceived(10000L, new Cache[]{cache1, cache2});
        DummyTransactionManager tm = (DummyTransactionManager)TestingUtil.getTransactionManager((Cache)cache2);
        tm.begin();
        cache2.put((Object)"block", (Object)"block");
        assert (tm.getTransaction().runPrepare());
        tm.suspend();
        cache1.put((Object)"block", (Object)"v");
    }

    public static class ContainerData
    implements Serializable {
        int i = 99;
        NonSerializabeData non_serializable_data = new NonSerializabeData();
        private static final long serialVersionUID = -8322197791060897247L;
    }

    static class NonSerializabeData {
        int i;

        NonSerializabeData() {
        }
    }
}

