/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="statetransfer.StateTransferReplicationQueueTest")
public class StateTransferReplicationQueueTest
extends MultipleCacheManagersTest {
    public static final String A_B_NAME = "a_b_name";
    public static final String A_C_NAME = "a_c_name";
    public static final String A_B_AGE = "a_b_age";
    public static final String A_C_AGE = "a_c_age";
    public static final String JOE = "JOE";
    public static final String BOB = "BOB";
    public static final Integer TWENTY = 20;
    public static final Integer FORTY = 40;
    private final String cacheName = "nbst-replqueue";
    Configuration config;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.config = StateTransferReplicationQueueTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_ASYNC, true);
        this.config.setUseReplQueue(true);
        this.config.setReplQueueInterval(100L, TimeUnit.MILLISECONDS);
        this.config.setReplQueueMaxElements(100);
        this.config.setUseAsyncMarshalling(false);
        this.config.setFetchInMemoryState(true);
        this.config.setUseLockStriping(false);
    }

    protected EmbeddedCacheManager createCacheManager() {
        EmbeddedCacheManager cm = this.addClusterEnabledCacheManager();
        GlobalConfiguration gc = cm.getGlobalConfiguration();
        Properties p = new Properties();
        p.setProperty("maxThreads", "25");
        gc.setAsyncTransportExecutorProperties(p);
        cm.defineConfiguration("nbst-replqueue", this.config.clone());
        return cm;
    }

    protected void writeInitialData(Cache<Object, Object> c) {
        c.put((Object)A_B_NAME, (Object)JOE);
        c.put((Object)A_B_AGE, (Object)TWENTY);
        c.put((Object)A_C_NAME, (Object)BOB);
        c.put((Object)A_C_AGE, (Object)FORTY);
    }

    protected void verifyInitialData(Cache<Object, Object> c) {
        assert (JOE.equals(c.get((Object)A_B_NAME))) : "Incorrect value for key a_b_name";
        assert (TWENTY.equals(c.get((Object)A_B_AGE))) : "Incorrect value for key a_b_age";
        assert (BOB.equals(c.get((Object)A_C_NAME))) : "Incorrect value for key a_c_name";
        assert (FORTY.equals(c.get((Object)A_C_AGE))) : "Incorrect value for key a_c_age";
    }

    public void testStateTransferWithNodeRestartedAndBusy(Method m) throws Exception {
        this.log.info((Object)(m.getName() + " start"));
        this.thirdWritingCacheTest(false);
        this.log.info((Object)(m.getName() + "end"));
    }

    private void thirdWritingCacheTest(boolean tx) throws InterruptedException {
        Cache cache1 = this.createCacheManager().getCache("nbst-replqueue");
        EmbeddedCacheManager manager3 = this.createCacheManager();
        Cache cache3 = manager3.getCache("nbst-replqueue");
        this.writeInitialData((Cache<Object, Object>)cache1);
        WritingThread writerThread = new WritingThread((Cache<Object, Object>)cache1, tx);
        writerThread.start();
        manager3.stop();
        TestingUtil.blockUntilViewsReceived(60000L, false, cache1);
        cache3 = this.createCacheManager().getCache("nbst-replqueue");
        TestingUtil.blockUntilViewsReceived(60000L, cache1, cache3);
        writerThread.stopThread();
        writerThread.join(60000L);
        this.verifyInitialData((Cache<Object, Object>)cache3);
        int count = writerThread.result();
        TestingUtil.sleepThread(5000L);
        for (int c = 0; c < count; ++c) {
            Object o = cache3.get((Object)("test" + c));
            assert (o == null);
        }
    }

    public static class PojoValue
    implements Externalizable {
        Log log = LogFactory.getLog(PojoValue.class);
        static AtomicBoolean holdUp = new AtomicBoolean();
        volatile int value;

        public PojoValue() {
        }

        public PojoValue(int value) {
            this.value = value;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            String threadName = Thread.currentThread().getName();
            if (!holdUp.get() && threadName.contains("STREAMING_STATE_TRANSFER-sender")) {
                this.log.debug((Object)"In streaming...");
                holdUp.compareAndSet(false, true);
                this.log.debug((Object)"Holding up...");
                TestingUtil.sleepThread(2000L);
            }
            out.writeInt(this.value);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.value = in.readInt();
        }

        public int hashCode() {
            return this.value + 31;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PojoValue pojo = (PojoValue)o;
            return this.value == pojo.value;
        }
    }

    private static class WritingThread
    extends Thread {
        private final Cache<Object, Object> cache;
        private final boolean tx;
        private volatile boolean stop;
        private volatile int result;
        private TransactionManager tm;

        WritingThread(Cache<Object, Object> cache, boolean tx) {
            super("WriterThread");
            this.cache = cache;
            this.tx = tx;
            if (tx) {
                this.tm = TestingUtil.getTransactionManager(cache);
            }
            this.setDaemon(true);
        }

        public int result() {
            return this.result;
        }

        @Override
        public void run() {
            int c = 0;
            while (!this.stop) {
                try {
                    if (this.tx) {
                        this.tm.begin();
                    }
                    this.cache.put((Object)("test" + c), (Object)new PojoValue(c));
                    this.cache.remove((Object)("test" + c));
                    if (this.tx) {
                        this.tm.commit();
                    }
                    if (++c % 1000 != 0) continue;
                    TestingUtil.sleepThread(1L);
                }
                catch (Exception e) {
                    this.stopThread();
                }
            }
            this.result = c;
        }

        public void stopThread() {
            this.stop = true;
        }
    }
}

