/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.List;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LoaderConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.interceptors.CacheStoreInterceptor;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.NoTxLeakInCacheStoreInterceptorTest")
public class NoTxLeakInCacheStoreInterceptorTest
extends MultipleCacheManagersTest {
    private final String testCacheName = "testCache" + this.getClass().getSimpleName();

    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cb = new ConfigurationBuilder();
        cb.clustering().invocationBatching().enable().versioning().enable().scheme(VersioningScheme.SIMPLE).transaction().lockingMode(LockingMode.PESSIMISTIC);
        cb.loaders().passivation(false).preload(true).shared(true);
        LoaderConfigurationBuilder lb = cb.loaders().addCacheLoader().cacheLoader((CacheLoader)new DummyInMemoryCacheStore());
        lb.addProperty("storeName", this.getClass().getSimpleName());
        EmbeddedCacheManager cm1 = TestCacheManagerFactory.createClusteredCacheManager();
        EmbeddedCacheManager cm2 = TestCacheManagerFactory.createClusteredCacheManager();
        this.registerCacheManager(new CacheContainer[]{cm1, cm2});
        this.defineConfigurationOnAllManagers(this.testCacheName, cb);
        this.waitForClusterToForm(this.testCacheName);
    }

    public void test() throws Exception {
        Cache cache = this.cache(0, this.testCacheName);
        cache.put((Object)"k1", (Object)"v1");
        for (int i = 0; i < this.getCacheManagers().size(); ++i) {
            CacheStoreInterceptor cacheStoreInterceptor = this.getCacheStoreInterceptor(i);
            this.assertTxFieldsEmpty(cacheStoreInterceptor, i);
        }
    }

    private void assertTxFieldsEmpty(CacheStoreInterceptor cacheStoreInterceptor, int cacheManagerIndex) throws Exception {
        Map preparingTxs = cacheStoreInterceptor.getPreparingTxs();
        this.log.debug((Object)("cm" + cacheManagerIndex + ": preparingTxs: " + preparingTxs));
        Map txStores = cacheStoreInterceptor.getTxStores();
        this.log.debug((Object)("cm" + cacheManagerIndex + ": txStores: " + txStores));
        Assert.assertTrue((boolean)preparingTxs.isEmpty());
        Assert.assertTrue((boolean)txStores.isEmpty());
    }

    private CacheStoreInterceptor getCacheStoreInterceptor(int cacheManagerIndex) {
        InterceptorChain interceptorChain = (InterceptorChain)TestingUtil.extractComponentRegistry(this.cache(cacheManagerIndex, this.testCacheName)).getComponent(InterceptorChain.class);
        List interceptors = interceptorChain.getInterceptorsWhichExtend(CacheStoreInterceptor.class);
        if (interceptors.isEmpty()) {
            throw new IllegalStateException("no CacheStoreInterceptor found");
        }
        return (CacheStoreInterceptor)interceptors.get(0);
    }
}

