/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="tx.TransactionCleanupWithAsync2ndPhaseTest")
public class TransactionCleanupWithAsync2ndPhaseTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration dcc = this.getConfiguration();
        this.createCluster(dcc, 2);
        this.waitForClusterToForm();
    }

    protected Configuration getConfiguration() {
        Configuration dcc = TransactionCleanupWithAsync2ndPhaseTest.getDefaultClusteredConfig(Configuration.CacheMode.REPL_SYNC, true);
        dcc.fluent().transaction().syncCommitPhase(Boolean.valueOf(false)).syncRollbackPhase(Boolean.valueOf(true));
        return dcc;
    }

    public void transactionCleanupTest1() throws Throwable {
        this.runtTest(1, false);
    }

    public void transactionCleanupTest2() throws Throwable {
        this.runtTest(0, false);
    }

    public void transactionCleanupTest3() throws Throwable {
        this.runtTest(1, true);
    }

    public void transactionCleanupTest4() throws Throwable {
        this.runtTest(0, true);
    }

    private void runtTest(int initiatorIndex, boolean rollback) throws Throwable {
        this.tm(initiatorIndex).begin();
        this.cache(initiatorIndex).put((Object)"k", (Object)"v");
        if (rollback) {
            this.tm(initiatorIndex).rollback();
        } else {
            this.tm(initiatorIndex).commit();
        }
        this.assertNotLocked("k");
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return TestingUtil.getTransactionTable((Cache<Object, Object>)TransactionCleanupWithAsync2ndPhaseTest.this.cache(0)).getRemoteTxCount() == 0 && TestingUtil.getTransactionTable((Cache<Object, Object>)TransactionCleanupWithAsync2ndPhaseTest.this.cache(0)).getLocalTxCount() == 0 && TestingUtil.getTransactionTable((Cache<Object, Object>)TransactionCleanupWithAsync2ndPhaseTest.this.cache(1)).getRemoteTxCount() == 0 && TestingUtil.getTransactionTable((Cache<Object, Object>)TransactionCleanupWithAsync2ndPhaseTest.this.cache(1)).getLocalTxCount() == 0;
            }
        });
    }
}

