/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import javax.transaction.Transaction;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.manager.CacheContainer;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.tx.recovery.RecoveryDummyTransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="TransactionCleanupWithRecoveryTest")
public class TransactionCleanupWithRecoveryTest
extends MultipleCacheManagersTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        Configuration cfg = new Configuration().fluent().clustering().mode(Configuration.CacheMode.REPL_SYNC).locking().concurrencyLevel(Integer.valueOf(10000)).isolationLevel(IsolationLevel.REPEATABLE_READ).lockAcquisitionTimeout(Long.valueOf(100L)).useLockStriping(Boolean.valueOf(false)).writeSkewCheck(Boolean.valueOf(false)).transaction().lockingMode(LockingMode.PESSIMISTIC).recovery().transactionManagerLookup((TransactionManagerLookup)new RecoveryDummyTransactionManagerLookup()).build();
        this.registerCacheManager(new CacheContainer[]{TestCacheManagerFactory.createClusteredCacheManager(cfg), TestCacheManagerFactory.createClusteredCacheManager(cfg)});
    }

    public void testCleanup() throws Exception {
        this.cache(0).put((Object)1, (Object)"v1");
        this.assertNoTx();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithSilentFailure() throws Exception {
        Cache c0 = this.cache(0);
        Cache c1 = this.cache(1);
        c0.put((Object)1, (Object)"v1");
        this.assertNoTx();
        this.tm(1).begin();
        c1.put((Object)1, (Object)"v2");
        Transaction suspendedTx = this.tm(1).suspend();
        try {
            AdvancedCache silentC0 = c0.getAdvancedCache().withFlags(new Flag[]{Flag.FAIL_SILENTLY, Flag.ZERO_LOCK_ACQUISITION_TIMEOUT});
            this.tm(0).begin();
            assert (!silentC0.getAdvancedCache().lock((Object[])new Integer[]{1}));
            assert ("v1".equals(silentC0.get((Object)1)));
            this.tm(0).rollback();
        }
        finally {
            this.tm(1).resume(suspendedTx);
            this.tm(1).commit();
        }
        this.assertNoTx();
    }

    private void assertNoTx() {
        final TransactionTable tt0 = TestingUtil.getTransactionTable(this.cache(0));
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                int localTxCount = tt0.getLocalTxCount();
                int remoteTxCount = tt0.getRemoteTxCount();
                return localTxCount == 0 && remoteTxCount == 0;
            }
        });
        final TransactionTable tt1 = TestingUtil.getTransactionTable(this.cache(1));
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                int localTxCount = tt1.getLocalTxCount();
                int remoteTxCount = tt1.getRemoteTxCount();
                return localTxCount == 0 && remoteTxCount == 0;
            }
        });
    }
}

