/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx;

import java.util.HashMap;
import java.util.concurrent.Callable;
import org.infinispan.Cache;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.lookup.DummyTransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.tm.DummyTransaction;
import org.infinispan.transaction.tm.DummyTransactionManager;
import org.infinispan.util.mocks.ControlledCommandFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@CleanupAfterMethod
@Test(groups={"functional"}, testName="tx.TxCleanupServiceTest", invocationCount=10)
public class TxCleanupServiceTest
extends MultipleCacheManagersTest {
    private static final int TX_COUNT = 1;
    private ConfigurationBuilder dcc;

    @Override
    protected void createCacheManagers() throws Throwable {
        this.dcc = TxCleanupServiceTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
        this.dcc.transaction().transactionManagerLookup((TransactionManagerLookup)new DummyTransactionManagerLookup());
        this.dcc.clustering().hash().numOwners(1).stateTransfer().fetchInMemoryState(true);
        this.createCluster(this.dcc, 2);
        this.waitForClusterToForm();
    }

    public void testTransactionStateNotLost() throws Throwable {
        final ControlledCommandFactory ccf = ControlledCommandFactory.registerControlledCommandFactory(this.cache(1), CommitCommand.class);
        ccf.gate.close();
        final HashMap keys2Tx = new HashMap(1);
        int viewId = this.advancedCache(0).getRpcManager().getTransport().getViewId();
        this.log.tracef("ViewId before %s", (Object)viewId);
        this.fork(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                for (int i = 0; i < 1; ++i) {
                    Object k = TxCleanupServiceTest.this.getKeyForCache(1);
                    TxCleanupServiceTest.this.tm(0).begin();
                    TxCleanupServiceTest.this.cache(0).put(k, k);
                    DummyTransaction transaction = ((DummyTransactionManager)TxCleanupServiceTest.this.tm(0)).getTransaction();
                    keys2Tx.put(k, transaction);
                    TxCleanupServiceTest.this.tm(0).commit();
                }
                return null;
            }
        });
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return ccf.blockTypeCommandsReceived.get() == 1;
            }
        });
        this.log.tracef("Viewid middle %s", (Object)viewId);
        this.addClusterEnabledCacheManager(this.dcc);
        this.waitForClusterToForm();
        viewId = this.advancedCache(0).getRpcManager().getTransport().getViewId();
        this.log.tracef("Viewid after before %s", (Object)viewId);
        final HashMap migratedTx = new HashMap(1);
        for (Object key : keys2Tx.keySet()) {
            if (!this.keyMapsToNode(key, 2)) continue;
            migratedTx.put(key, keys2Tx.get(key));
        }
        this.log.tracef("Number of migrated tx is %s", (Object)migratedTx.size());
        if (migratedTx.size() == 0) {
            return;
        }
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return TestingUtil.getTransactionTable((Cache<Object, Object>)TxCleanupServiceTest.this.cache(2)).getRemoteTxCount() == migratedTx.size();
            }
        });
        this.log.trace((Object)"Releasing the gate");
        ccf.gate.open();
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                return TestingUtil.getTransactionTable((Cache<Object, Object>)TxCleanupServiceTest.this.cache(2)).getRemoteTxCount() == 0;
            }
        });
        this.eventually(new AbstractInfinispanTest.Condition(){

            @Override
            public boolean isSatisfied() throws Exception {
                boolean allZero = true;
                for (int i = 0; i < 3; ++i) {
                    TransactionTable tt = TestingUtil.getTransactionTable((Cache<Object, Object>)TxCleanupServiceTest.this.cache(i));
                    int local = tt.getLocalTxCount();
                    int remote = tt.getRemoteTxCount();
                    TxCleanupServiceTest.this.log.tracef("For cache %i , localTxCount=%s, remoteTxCount=%s", (Object)i, (Object)local, (Object)remote);
                    TxCleanupServiceTest.this.log.tracef(String.format("For cache %s , localTxCount=%s, remoteTxCount=%s", i, local, remote), new Object[0]);
                    allZero = allZero && local == 0;
                    allZero = allZero && remote == 0;
                }
                return allZero;
            }
        });
        for (Object key : keys2Tx.keySet()) {
            this.assertNotLocked(key);
            Assert.assertEquals(key, (Object)this.cache(0).get(key));
        }
    }

    private boolean keyMapsToNode(Object key, int nodeIndex) {
        Address owner = this.owner(key);
        return owner.equals(this.address(nodeIndex));
    }

    private Address owner(Object key) {
        return this.advancedCache(0).getDistributionManager().getConsistentHash().locatePrimaryOwner(key);
    }
}

