/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tx.dld;

import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.PerCacheExecutorThread;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.concurrent.locks.DeadlockDetectingLockManager;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class BaseDldPessimisticLockingTest
extends MultipleCacheManagersTest {
    protected PerCacheExecutorThread ex0;
    protected PerCacheExecutorThread ex1;
    protected DeadlockDetectingLockManager lm0;
    protected DeadlockDetectingLockManager lm1;

    @BeforeMethod(alwaysRun=true)
    public void beforeMethod() {
        this.ex0 = new PerCacheExecutorThread(this.cache(0), 0);
        this.ex1 = new PerCacheExecutorThread(this.cache(1), 1);
        this.lm0 = (DeadlockDetectingLockManager)TestingUtil.extractLockManager(this.cache(0));
        this.lm0.setExposeJmxStats(true);
        this.lm1 = (DeadlockDetectingLockManager)TestingUtil.extractLockManager(this.cache(1));
        this.lm1.setExposeJmxStats(true);
    }

    @AfterMethod(alwaysRun=true)
    public void afterMethod() {
        this.ex0.stopThread();
        this.ex1.stopThread();
    }

    protected void testSymmetricDld(Object k0, Object k1) throws SystemException {
        long start = System.currentTimeMillis();
        this.log.trace((Object)"Here is where the test starts");
        this.ex0.execute(PerCacheExecutorThread.Operations.BEGIN_TX);
        this.ex1.execute(PerCacheExecutorThread.Operations.BEGIN_TX);
        this.ex0.setKeyValue(k0, "v0_0");
        Assert.assertEquals((Object)this.ex0.execute(PerCacheExecutorThread.Operations.PUT_KEY_VALUE), (Object)((Object)PerCacheExecutorThread.OperationsResult.PUT_KEY_VALUE_OK));
        this.ex1.setKeyValue(k1, "v1_1");
        Assert.assertEquals((Object)this.ex1.execute(PerCacheExecutorThread.Operations.PUT_KEY_VALUE), (Object)((Object)PerCacheExecutorThread.OperationsResult.PUT_KEY_VALUE_OK));
        this.assertKeyLockedCorrectly(k0);
        this.assertKeyLockedCorrectly(k1);
        this.log.trace((Object)"After first set of puts");
        this.ex0.clearResponse();
        this.ex1.clearResponse();
        this.log.info((Object)"Here is where DLD happens");
        this.ex1.setKeyValue(k0, "v0_1");
        this.ex1.executeNoResponse(PerCacheExecutorThread.Operations.PUT_KEY_VALUE);
        this.ex0.setKeyValue(k1, "v1_0");
        this.ex0.executeNoResponse(PerCacheExecutorThread.Operations.PUT_KEY_VALUE);
        this.ex0.waitForResponse();
        this.ex1.waitForResponse();
        Object resp0 = this.ex0.lastResponse();
        boolean b1 = resp0 instanceof Exception;
        Object resp1 = this.ex1.lastResponse();
        boolean b2 = resp1 instanceof Exception;
        assert (this.xor(b1, b2)) : "Both are " + (b1 || b2);
        assert (this.xor(this.ex0.getOngoingTransaction().getStatus() == 1, this.ex1.getOngoingTransaction().getStatus() == 1));
        this.log.trace((Object)"About to commit transactions");
        Object txOutcome1 = this.ex0.execute(PerCacheExecutorThread.Operations.COMMIT_TX);
        Object txOutcome2 = this.ex1.execute(PerCacheExecutorThread.Operations.COMMIT_TX);
        System.out.println("txOutcome2 = " + txOutcome1);
        System.out.println("txOutcome2 = " + txOutcome2);
        assert (this.xor(txOutcome1 == PerCacheExecutorThread.OperationsResult.COMMIT_TX_OK, txOutcome2 == PerCacheExecutorThread.OperationsResult.COMMIT_TX_OK));
        assert (this.xor(txOutcome1 instanceof RollbackException, txOutcome2 instanceof RollbackException));
        this.log.tracef("k0 is %s, \n k1 is %s", k0, k1);
        assert (this.cache(0).get(k0) != null);
        assert (this.cache(0).get(k1) != null);
        assert (this.cache(1).get(k0) != null);
        assert (this.cache(1).get(k1) != null);
        long totalDeadlocks = this.lm0.getTotalNumberOfDetectedDeadlocks() + this.lm1.getTotalNumberOfDetectedDeadlocks();
        assert (totalDeadlocks == 1L) : "Expected 1 but received " + totalDeadlocks;
        System.out.println("Test took " + (System.currentTimeMillis() - start) + " millis.");
    }
}

