/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.logging.log4j;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.FileAppender;
import org.apache.log4j.LogManager;

public class CompressedFileAppender
extends FileAppender {
    GZIPOutputStream gzos;

    protected OutputStreamWriter createWriter(OutputStream os) {
        try {
            this.gzos = new GZIPOutputStream(os, this.bufferSize);
            this.gzos.flush();
            return super.createWriter((OutputStream)this.gzos);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create gzipped output stream");
        }
    }

    protected void reset() {
        if (this.gzos != null) {
            this.closeCompressor();
            this.gzos = null;
        }
        super.reset();
    }

    private void closeCompressor() {
        try {
            this.gzos.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to finish gzipped output stream");
        }
    }

    static {
        Thread shutdownThread = new Thread(new Runnable(){

            @Override
            public void run() {
                LogManager.shutdown();
            }
        }, "Log4j shutdown thread");
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }
}

