/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.logging.log4j;

import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;

public class ThreadNameFilter
extends Filter {
    private Level threshold = Level.DEBUG;
    private Pattern includePattern;

    public Level getThreshold() {
        return this.threshold;
    }

    public void setThreshold(Level threshold) {
        this.threshold = threshold;
    }

    public String getInclude() {
        return this.includePattern != null ? this.includePattern.pattern() : null;
    }

    public void setInclude(String include) {
        this.includePattern = Pattern.compile(include);
    }

    public int decide(LoggingEvent event) {
        if (event.getLevel().isGreaterOrEqual((Priority)this.threshold)) {
            return 0;
        }
        if (this.includePattern == null || this.includePattern.matcher(event.getThreadName()).find()) {
            return 0;
        }
        return -1;
    }
}

