/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.xsite.AbstractTwoSitesTest;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.BackupReceiverRepository;
import org.infinispan.xsite.BackupReceiverRepositoryImpl;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"xsite"}, testName="xsite.RollbackNoPrepareOptimisticTest")
public class RollbackNoPrepareOptimisticTest
extends AbstractTwoSitesTest {
    public RollbackNoPrepareOptimisticTest() {
        this.use2Pc = true;
    }

    public void testRollbackNoCommit() throws Throwable {
        String key = this.key("LON");
        String val = this.val("LON");
        ComponentRegistry cr = this.backup("LON").getAdvancedCache().getComponentRegistry();
        GlobalComponentRegistry gcr = cr.getGlobalComponentRegistry();
        BackupReceiverRepositoryImpl brr = (BackupReceiverRepositoryImpl)gcr.getComponent(BackupReceiverRepository.class);
        BackupReceiver backupCacheManager = brr.getBackupCacheManager("LON", "___defaultcache");
        BackupReceiverWrapper brWrapper = new BackupReceiverWrapper(backupCacheManager);
        brr.replace("LON", "___defaultcache", (BackupReceiver)brWrapper);
        AssertJUnit.assertNull((Object)brWrapper.received);
        this.cache("LON", 0).put((Object)key, (Object)val);
        AssertJUnit.assertNotNull((Object)brWrapper.received);
        AssertJUnit.assertEquals((Object)this.backup("LON").get((Object)key), (Object)val);
        brWrapper.received = null;
        TransactionManager tmLon0 = this.cache("LON", 0).getAdvancedCache().getTransactionManager();
        AssertJUnit.assertNull((Object)brWrapper.received);
        tmLon0.begin();
        this.cache("LON", 0).put((Object)key, (Object)val);
        this.log.trace((Object)"Before rollback!");
        tmLon0.rollback();
        AssertJUnit.assertNull((Object)brWrapper.received);
    }

    @Override
    protected ConfigurationBuilder getNycActiveConfig() {
        return RollbackNoPrepareOptimisticTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
    }

    @Override
    protected ConfigurationBuilder getLonActiveConfig() {
        return RollbackNoPrepareOptimisticTest.getDefaultClusteredCacheConfig(CacheMode.DIST_SYNC, true);
    }

    public class BackupReceiverWrapper
    implements BackupReceiver {
        final BackupReceiver br;
        volatile VisitableCommand received;

        public BackupReceiverWrapper(BackupReceiver br) {
            this.br = br;
        }

        public Cache getCache() {
            return this.br.getCache();
        }

        public Object handleRemoteCommand(VisitableCommand command) throws Throwable {
            this.received = command;
            return this.br.handleRemoteCommand(command);
        }
    }
}

