/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.TakeOfflineConfiguration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="xsite.XSiteFileParsing2Test")
public class XSiteFileParsing2Test
extends SingleCacheManagerTest {
    public static final String FILE_NAME = "configs/xsite/xsite-test2.xml";

    @Override
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager embeddedCacheManager = TestCacheManagerFactory.fromXml(FILE_NAME);
        return embeddedCacheManager;
    }

    public void testDefaultCache() {
        Configuration dcc = this.cacheManager.getDefaultCacheConfiguration();
        AssertJUnit.assertEquals((int)dcc.sites().allBackups().size(), (int)3);
        AssertJUnit.assertEquals((int)dcc.sites().enabledBackups().size(), (int)2);
        this.testDefault(dcc);
    }

    public void testInheritor() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("inheritor");
        this.testDefault(dcc);
    }

    public void testNoBackupFor() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("noBackupFor");
        AssertJUnit.assertEquals((int)1, (int)dcc.sites().allBackups().size());
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(new BackupConfiguration("NYC", BackupConfiguration.BackupStrategy.SYNC, 12003L, BackupFailurePolicy.WARN, null, false, new TakeOfflineConfiguration(0, 0L), true)));
        AssertJUnit.assertNull((Object)dcc.sites().backupFor().remoteSite());
        AssertJUnit.assertNull((Object)dcc.sites().backupFor().remoteCache());
    }

    public void testNoBackupFor2() {
        Configuration dcc = this.cacheManager.getCacheConfiguration("noBackupFor2");
        AssertJUnit.assertEquals((int)0, (int)dcc.sites().allBackups().size());
        AssertJUnit.assertNull((Object)dcc.sites().backupFor().remoteSite());
        AssertJUnit.assertNull((Object)dcc.sites().backupFor().remoteCache());
    }

    private void testDefault(Configuration dcc) {
        BackupConfiguration nyc = new BackupConfiguration("NYC", BackupConfiguration.BackupStrategy.SYNC, 12003L, BackupFailurePolicy.IGNORE, null, false, new TakeOfflineConfiguration(0, 0L), true);
        BackupConfiguration sfo = new BackupConfiguration("SFO", BackupConfiguration.BackupStrategy.ASYNC, 10000L, BackupFailurePolicy.WARN, null, false, new TakeOfflineConfiguration(0, 0L), true);
        BackupConfiguration lon = new BackupConfiguration("LON", BackupConfiguration.BackupStrategy.SYNC, 10000L, BackupFailurePolicy.WARN, null, false, new TakeOfflineConfiguration(0, 0L), false);
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(nyc));
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(sfo));
        AssertJUnit.assertTrue((boolean)dcc.sites().allBackups().contains(lon));
        AssertJUnit.assertTrue((boolean)dcc.sites().enabledBackups().contains(nyc));
        AssertJUnit.assertTrue((boolean)dcc.sites().enabledBackups().contains(sfo));
        AssertJUnit.assertTrue((!dcc.sites().enabledBackups().contains(lon) ? 1 : 0) != 0);
        AssertJUnit.assertEquals((String)"someCache", (String)dcc.sites().backupFor().remoteCache());
        AssertJUnit.assertEquals((String)"SFO", (String)dcc.sites().backupFor().remoteSite());
    }
}

