/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.offline;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.xsite.XSiteBackup;

public class DelegatingTransport
implements Transport {
    private final Transport actual;
    volatile boolean fail;

    public DelegatingTransport(Transport actual) {
        this.actual = actual;
    }

    public BackupResponse backupRemotely(final Collection<XSiteBackup> backups, ReplicableCommand rpcCommand) throws Exception {
        return new BackupResponse(){
            final long creationTime = System.currentTimeMillis();

            public void waitForBackupToFinish() throws Exception {
            }

            public Map<String, Throwable> getFailedBackups() {
                if (DelegatingTransport.this.fail) {
                    HashMap<String, Throwable> result = new HashMap<String, Throwable>();
                    for (XSiteBackup xSiteBackup : backups) {
                        result.put(xSiteBackup.getSiteName(), new TimeoutException());
                    }
                    return result;
                }
                return Collections.emptyMap();
            }

            public Set<String> getCommunicationErrors() {
                if (DelegatingTransport.this.fail) {
                    return Collections.singleton("NYC");
                }
                return Collections.emptySet();
            }

            public long getSendTimeMillis() {
                return this.creationTime;
            }
        };
    }

    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, boolean usePriorityQueue, ResponseFilter responseFilter) throws Exception {
        return this.actual.invokeRemotely(recipients, rpcCommand, mode, timeout, usePriorityQueue, responseFilter);
    }

    public boolean isCoordinator() {
        return this.actual.isCoordinator();
    }

    public Address getCoordinator() {
        return this.actual.getCoordinator();
    }

    public Address getAddress() {
        return this.actual.getAddress();
    }

    public List<Address> getPhysicalAddresses() {
        return this.actual.getPhysicalAddresses();
    }

    public List<Address> getMembers() {
        return this.actual.getMembers();
    }

    public boolean isMulticastCapable() {
        return this.actual.isMulticastCapable();
    }

    public void start() {
        this.actual.start();
    }

    public void stop() {
        this.actual.stop();
    }

    public int getViewId() {
        return this.actual.getViewId();
    }

    public Log getLog() {
        return this.actual.getLog();
    }
}

