/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.jcr.Item;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.IoUtil;
import org.modeshape.common.util.StringUtil;
import org.modeshape.web.jcr.RepositoryManager;
import org.modeshape.web.jcr.webdav.ContentMapper;
import org.modeshape.web.jcr.webdav.ModeShapeWebdavServlet;
import org.modeshape.web.jcr.webdav.RequestResolver;
import org.modeshape.web.jcr.webdav.ResolvedRequest;
import org.modeshape.web.jcr.webdav.WebdavI18n;
import org.modeshape.webdav.ITransaction;
import org.modeshape.webdav.IWebdavStore;
import org.modeshape.webdav.StoredObject;
import org.modeshape.webdav.exceptions.ObjectNotFoundException;
import org.modeshape.webdav.exceptions.WebdavException;

public class ModeShapeWebdavStore
implements IWebdavStore {
    private static final String DS_STORE_SUFFIX = ".DS_Store";
    private static final ThreadLocal<HttpServletRequest> THREAD_LOCAL_REQUEST = new ThreadLocal();
    private static final Map<String, byte[]> OSX_DOUBLE_DATA = Collections.synchronizedMap(new WeakHashMap());
    private static final String CREATED_PROP_NAME = "jcr:created";
    private final RequestResolver requestResolver;
    private final ContentMapper contentMapper;
    private final Logger logger = Logger.getLogger(this.getClass());

    public ModeShapeWebdavStore(RequestResolver requestResolver, ContentMapper contentMapper) {
        this.requestResolver = requestResolver;
        this.contentMapper = contentMapper;
    }

    static void setRequest(HttpServletRequest request) {
        THREAD_LOCAL_REQUEST.set(request);
    }

    public ITransaction begin(Principal principal) {
        return new JcrSessionTransaction(principal);
    }

    public void commit(ITransaction transaction) {
        CheckArg.isNotNull((Object)transaction, (String)"transaction");
        assert (transaction instanceof JcrSessionTransaction);
        ((JcrSessionTransaction)transaction).commit();
    }

    public void rollback(ITransaction transaction) {
    }

    public void checkAuthentication(ITransaction transaction) {
    }

    public void destroy() {
    }

    public void createFolder(ITransaction transaction, String folderUri) {
        folderUri = this.removeTrailingSlash(folderUri);
        int ind = folderUri.lastIndexOf(47);
        String parentUri = folderUri.substring(0, ind + 1);
        String resourceName = folderUri.substring(ind + 1);
        try {
            this.logger.debug("WebDAV create folder at: " + parentUri, new Object[0]);
            ResolvedRequest resolvedParent = this.resolveRequest(parentUri);
            this.logger.debug("WebDAV create folder at: " + resolvedParent, new Object[0]);
            if (resolvedParent.getPath() == null) {
                if (resolvedParent.getRepositoryName() == null) {
                    throw new WebdavException(WebdavI18n.cannotCreateRepository.text(new Object[]{resourceName}));
                }
                if (resolvedParent.getWorkspaceName() != null) {
                    resolvedParent = resolvedParent.withPath("/");
                } else {
                    I18n msg = WebdavI18n.cannotCreateWorkspaceInRepository;
                    throw new WebdavException(msg.text(new Object[]{resourceName, resolvedParent.getRepositoryName()}));
                }
            }
            Node parentNode = this.nodeFor(transaction, resolvedParent);
            this.contentMapper.createFolder(parentNode, resourceName);
        }
        catch (RepositoryException re) {
            throw this.translate(re);
        }
    }

    public void createResource(ITransaction transaction, String resourceUri) {
        if ((resourceUri = this.removeTrailingSlash(resourceUri)).endsWith(DS_STORE_SUFFIX)) {
            return;
        }
        int ind = resourceUri.lastIndexOf(47);
        String parentUri = resourceUri.substring(0, ind + 1);
        String resourceName = resourceUri.substring(ind + 1);
        if (resourceName.startsWith("._")) {
            OSX_DOUBLE_DATA.put(resourceUri, null);
            return;
        }
        try {
            ResolvedRequest resolvedParent = this.resolveRequest(parentUri);
            if (resolvedParent.getPath() == null) {
                if (resolvedParent.getRepositoryName() == null) {
                    throw new WebdavException(WebdavI18n.cannotCreateRepository.text(new Object[]{resourceName}));
                }
                if (resolvedParent.getWorkspaceName() != null) {
                    resolvedParent = resolvedParent.withPath("/");
                } else {
                    I18n msg = WebdavI18n.cannotCreateWorkspaceInRepository;
                    throw new WebdavException(msg.text(new Object[]{resourceName, resolvedParent.getRepositoryName()}));
                }
            }
            Node parentNode = this.nodeFor(transaction, resolvedParent);
            this.contentMapper.createFile(parentNode, resourceName);
        }
        catch (RepositoryException re) {
            throw this.translate(re);
        }
    }

    private String removeTrailingSlash(String uri) {
        if (!StringUtil.isBlank((String)uri) && uri.length() > 1 && uri.endsWith("/")) {
            return uri.substring(0, uri.length() - 1);
        }
        return uri;
    }

    public String[] getChildrenNames(ITransaction transaction, String folderUri) {
        try {
            this.logger.trace("WebDAV getChildrenNames(txn,\"" + folderUri + "\")", new Object[0]);
            ResolvedRequest resolved = this.resolveRequest(folderUri);
            this.logger.trace("WebDAV -> resolves to: " + resolved, new Object[0]);
            if (resolved.getPath() == null) {
                return this.childrenFor(transaction, resolved);
            }
            Node node = this.nodeFor(transaction, resolved);
            this.logger.trace("WebDAV -> node: " + node, new Object[0]);
            if (!this.isFolder(node)) {
                return null;
            }
            List<String> children = ModeShapeWebdavStore.namesOfChildren(node);
            this.logger.trace("WebDAV -> children: " + children, new Object[0]);
            return children.toArray(new String[children.size()]);
        }
        catch (RepositoryException re) {
            throw this.translate(re);
        }
    }

    protected static List<String> namesOfChildren(Node node) throws RepositoryException {
        LinkedList<String> children = new LinkedList<String>();
        NodeIterator iter = node.getNodes();
        while (iter.hasNext()) {
            Node child = iter.nextNode();
            String name = child.getIndex() == 1 ? child.getName() : child.getName() + "[" + child.getIndex() + "]";
            children.add(name);
        }
        return children;
    }

    public InputStream getResourceContent(ITransaction transaction, String resourceUri) {
        try {
            ResolvedRequest resolved = this.resolveRequest(resourceUri);
            if (resolved.getPath() == null) {
                return null;
            }
            Node node = this.nodeFor(transaction, resolved);
            if (!this.isFile(node)) {
                return null;
            }
            return this.contentMapper.getResourceContent(node);
        }
        catch (IOException ioe) {
            throw new WebdavException((Throwable)ioe);
        }
        catch (RepositoryException re) {
            throw this.translate(re);
        }
    }

    public long getResourceLength(ITransaction transaction, String resourceUri) {
        try {
            ResolvedRequest resolved = this.resolveRequest(resourceUri);
            if (resolved.getPath() == null) {
                return -1L;
            }
            Node node = this.nodeFor(transaction, resolved);
            return this.contentMapper.getResourceLength(node);
        }
        catch (IOException ioe) {
            throw new WebdavException((Throwable)ioe);
        }
        catch (RepositoryException re) {
            throw this.translate(re);
        }
    }

    public StoredObject getStoredObject(ITransaction transaction, String uri) {
        if (uri.length() == 0) {
            uri = "/";
        }
        StoredObject ob = new StoredObject();
        try {
            this.logger.trace("WebDAV getStoredObject at \"" + uri + "\"", new Object[0]);
            ResolvedRequest resolved = this.resolveRequest(uri);
            this.logger.debug("WebDAV getStoredObject at \"" + uri + "\" resolved to \"" + resolved + "\"", new Object[0]);
            String path = resolved.getPath();
            if (path == null) {
                if (this.repositoryAndWorkspaceExist(transaction, resolved)) {
                    ob.setFolder(true);
                    Date now = new Date();
                    ob.setCreationDate(now);
                    ob.setLastModified(now);
                    ob.setResourceLength(0L);
                    return ob;
                }
                return null;
            }
            int ind = path.lastIndexOf(47);
            String resourceName = path.substring(ind + 1);
            if (resourceName.startsWith("._")) {
                return null;
            }
            Node node = this.nodeFor(transaction, resolved);
            if (this.isFolder(node)) {
                ob.setFolder(true);
                Date createDate = null;
                createDate = node.hasProperty(CREATED_PROP_NAME) ? node.getProperty(CREATED_PROP_NAME).getDate().getTime() : new Date();
                ob.setCreationDate(createDate);
                ob.setLastModified(new Date());
                ob.setResourceLength(0L);
            } else if (this.isFile(node)) {
                ob.setFolder(false);
                Date createDate = null;
                createDate = node.hasProperty(CREATED_PROP_NAME) ? node.getProperty(CREATED_PROP_NAME).getDate().getTime() : new Date();
                ob.setCreationDate(createDate);
                ob.setLastModified(this.contentMapper.getLastModified(node));
                ob.setResourceLength(this.contentMapper.getResourceLength(node));
            } else {
                ob.setNullResource(true);
            }
        }
        catch (PathNotFoundException pnfe) {
            return null;
        }
        catch (IOException ioe) {
            throw new WebdavException((Throwable)ioe);
        }
        catch (RepositoryException re) {
            throw this.translate(re);
        }
        return ob;
    }

    public void removeObject(ITransaction transaction, String uri) {
        String resourceName = this.resourceNameFromResourcePath(uri);
        if (resourceName.startsWith("._")) {
            OSX_DOUBLE_DATA.put(uri, null);
            return;
        }
        try {
            ResolvedRequest resolved = this.resolveRequest(uri);
            if (resolved.getPath() != null) {
                Node node = this.nodeFor(transaction, resolved);
                node.remove();
            }
        }
        catch (PathNotFoundException pnfe) {
        }
        catch (RepositoryException re) {
            throw this.translate(re);
        }
    }

    protected String resourceNameFromResourcePath(String path) {
        int ind = path.lastIndexOf(47);
        return path.substring(ind + 1);
    }

    public long setResourceContent(ITransaction transaction, String resourceUri, InputStream content, String contentType, String characterEncoding) {
        if (this.shouldIgnoreResource(resourceUri)) {
            return 0L;
        }
        String resourceName = this.resourceNameFromResourcePath(resourceUri);
        if (resourceName.startsWith("._")) {
            try {
                OSX_DOUBLE_DATA.put(resourceUri, IoUtil.readBytes((InputStream)content));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return 0L;
        }
        try {
            ResolvedRequest resolved = this.resolveRequest(resourceUri);
            if (resolved.getPath() == null) {
                return -1L;
            }
            Node node = this.nodeFor(transaction, resolved);
            if (!this.isFile(node)) {
                return -1L;
            }
            return this.contentMapper.setContent(node, resourceName, content, contentType, characterEncoding);
        }
        catch (RepositoryException re) {
            throw this.translate(re);
        }
        catch (IOException ioe) {
            throw new WebdavException((Throwable)ioe);
        }
    }

    private boolean shouldIgnoreResource(String resourceUri) {
        return resourceUri.endsWith(DS_STORE_SUFFIX);
    }

    public Map<String, String> setCustomProperties(ITransaction transaction, String resourceUri, Map<String, Object> propertiesToSet, List<String> propertiesToRemove) {
        if (this.shouldIgnoreResource(resourceUri = this.removeTrailingSlash(resourceUri))) {
            this.logger().debug("Resource {0} ignored.", new Object[]{resourceUri});
            return null;
        }
        try {
            String jcrPropertyName;
            ResolvedRequest resolvedRequest = this.resolveRequest(resourceUri);
            if (resolvedRequest.getPath() == null) {
                throw new ObjectNotFoundException("The resource at path " + resourceUri + " does not represent a valid JCR node");
            }
            Node node = this.nodeFor(transaction, resolvedRequest);
            LinkedHashMap<String, String> response = new LinkedHashMap<String, String>();
            for (String propertyName : propertiesToSet.keySet()) {
                jcrPropertyName = this.jcrPropertyName(transaction, resolvedRequest, propertyName);
                Object value = propertiesToSet.get(propertyName);
                if (value instanceof Collection) {
                    Collection collection = (Collection)value;
                    String[] jcrValue = new String[collection.size()];
                    int i = 0;
                    for (Object collectionObject : collection) {
                        jcrValue[i++] = collectionObject.toString();
                    }
                    try {
                        node.setProperty(jcrPropertyName, jcrValue);
                        continue;
                    }
                    catch (RepositoryException e) {
                        response.put(propertyName, e.getMessage());
                        this.markForRollback(transaction, resolvedRequest);
                        return response;
                    }
                }
                try {
                    node.setProperty(jcrPropertyName, value.toString());
                }
                catch (RepositoryException e) {
                    response.put(propertyName, e.getMessage());
                    this.markForRollback(transaction, resolvedRequest);
                    return response;
                }
            }
            for (String propertyName : propertiesToRemove) {
                jcrPropertyName = this.jcrPropertyName(transaction, resolvedRequest, propertyName);
                try {
                    node.getProperty(jcrPropertyName).remove();
                }
                catch (RepositoryException e) {
                    response.put(propertyName, e.getMessage());
                    this.markForRollback(transaction, resolvedRequest);
                    return response;
                }
            }
            return response;
        }
        catch (RepositoryException e) {
            throw this.translate(e);
        }
    }

    private String jcrPropertyName(ITransaction transaction, ResolvedRequest resolvedRequest, String webdavPropertyName) throws RepositoryException {
        String[] parts = webdavPropertyName.split("\\:");
        if (parts.length == 0) {
            return webdavPropertyName;
        }
        ArrayList<String> parsedParts = new ArrayList<String>();
        for (String part : parts) {
            if (StringUtil.isBlank((String)part) || part.equalsIgnoreCase(":")) continue;
            parsedParts.add(part);
        }
        if (parsedParts.isEmpty()) {
            return webdavPropertyName;
        }
        String localName = (String)parsedParts.remove(parsedParts.size() - 1);
        Session session = this.sessionFor(transaction, resolvedRequest);
        List<String> namespacePrefixes = Arrays.asList(session.getNamespacePrefixes());
        for (int i = parsedParts.size() - 1; i >= 0; --i) {
            String prefix = (String)parsedParts.get(i);
            if (!namespacePrefixes.contains(prefix)) continue;
            return prefix + ":" + localName;
        }
        return localName;
    }

    public Map<String, Object> getCustomProperties(ITransaction transaction, String resourceUri) {
        if (this.shouldIgnoreResource(resourceUri = this.removeTrailingSlash(resourceUri))) {
            return Collections.emptyMap();
        }
        try {
            ResolvedRequest resolvedRequest = this.resolveRequest(resourceUri);
            if (resolvedRequest.getPath() == null) {
                return Collections.emptyMap();
            }
            Node node = this.nodeFor(transaction, resolvedRequest);
            LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
            PropertyIterator propertyIterator = node.getProperties();
            while (propertyIterator.hasNext()) {
                Property property = propertyIterator.nextProperty();
                if (property.isMultiple()) {
                    this.logger().warn((I18nResource)WebdavI18n.warnMultiValuedProperty, new Object[]{property.getPath()});
                    continue;
                }
                String webDavPropertyName = this.webdavPropertyName(property.getName());
                response.put(webDavPropertyName, property.getString());
            }
            return response;
        }
        catch (RepositoryException e) {
            throw this.translate(e);
        }
    }

    private String webdavPropertyName(String jcrPropertyName) {
        String namespaceUri = "D";
        String propertyName = jcrPropertyName;
        if (jcrPropertyName.startsWith("{") && jcrPropertyName.lastIndexOf("}") > 0) {
            int closingBracketIdx = jcrPropertyName.lastIndexOf("}");
            namespaceUri = jcrPropertyName.substring(1, closingBracketIdx);
            propertyName = jcrPropertyName.substring(closingBracketIdx + 1);
        }
        return namespaceUri + ":" + propertyName;
    }

    public Map<String, String> getCustomNamespaces(ITransaction transaction, String resourceUri) {
        resourceUri = this.removeTrailingSlash(resourceUri);
        try {
            ResolvedRequest resolvedRequest = this.resolveRequest(resourceUri);
            if (resolvedRequest.getPath() == null) {
                return Collections.emptyMap();
            }
            return ((JcrSessionTransaction)transaction).namespacesFor(resolvedRequest);
        }
        catch (RepositoryException e) {
            throw this.translate(e);
        }
    }

    private boolean isFile(Node node) throws RepositoryException {
        return this.contentMapper.isFile(node);
    }

    private boolean isFolder(Node node) throws RepositoryException {
        return this.contentMapper.isFolder(node);
    }

    private ResolvedRequest resolveRequest(String uri) throws WebdavException {
        HttpServletRequest request = THREAD_LOCAL_REQUEST.get();
        return this.requestResolver.resolve(request, uri);
    }

    private Node nodeFor(ITransaction transaction, ResolvedRequest request) throws RepositoryException {
        return ((JcrSessionTransaction)transaction).nodeFor(request);
    }

    private boolean repositoryAndWorkspaceExist(ITransaction transaction, ResolvedRequest request) throws RepositoryException {
        return ((JcrSessionTransaction)transaction).repositoryAndWorkspaceExist(request);
    }

    private String[] childrenFor(ITransaction transaction, ResolvedRequest request) throws RepositoryException {
        return ((JcrSessionTransaction)transaction).childrenFor(request);
    }

    private void markForRollback(ITransaction transaction, ResolvedRequest request) {
        ((JcrSessionTransaction)transaction).markForRollback(request);
    }

    private Session sessionFor(ITransaction transaction, ResolvedRequest request) throws RepositoryException {
        return ((JcrSessionTransaction)transaction).session(request);
    }

    protected final Logger logger() {
        return this.logger;
    }

    protected WebdavException translate(RepositoryException exception) {
        return ModeShapeWebdavServlet.translateError(exception);
    }

    protected static final class SessionKey {
        protected final String repositoryName;
        protected final String workspaceName;

        protected SessionKey(String repositoryName, String workspaceName) {
            this.repositoryName = repositoryName;
            this.workspaceName = workspaceName;
            assert (this.repositoryName != null);
            assert (this.workspaceName != null);
        }

        public int hashCode() {
            return this.repositoryName.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof SessionKey) {
                SessionKey that = (SessionKey)obj;
                return this.repositoryName.equals(that.repositoryName) && this.workspaceName.equals(that.workspaceName);
            }
            return false;
        }

        public String toString() {
            return this.repositoryName + "/" + this.workspaceName;
        }
    }

    class JcrSessionTransaction
    implements ITransaction {
        private final Map<SessionKey, Session> sessions = new HashMap<SessionKey, Session>();
        private final Set<SessionKey> sessionsMarkedForRollback = new HashSet<SessionKey>();
        private final Principal principal;

        JcrSessionTransaction(Principal principal) {
            this.principal = principal;
        }

        protected boolean owns(Session session) {
            return this.sessions.containsValue(session);
        }

        Session session(ResolvedRequest request) throws RepositoryException {
            String repositoryName = request.getRepositoryName();
            String workspaceName = request.getWorkspaceName();
            assert (repositoryName != null);
            assert (workspaceName != null);
            SessionKey key = new SessionKey(repositoryName, workspaceName);
            Session result = this.sessions.get(key);
            if (result == null) {
                try {
                    result = RepositoryManager.getSession((HttpServletRequest)request.getRequest(), (String)repositoryName, (String)workspaceName);
                }
                catch (RepositoryException e) {
                    ModeShapeWebdavStore.this.logger().warn((I18nResource)WebdavI18n.cannotGetRepositorySession, new Object[]{repositoryName, e.getMessage()});
                    throw ModeShapeWebdavStore.this.translate(e);
                }
                this.sessions.put(key, result);
            }
            return result;
        }

        Node nodeFor(ResolvedRequest request) throws RepositoryException {
            Session session = this.session(request);
            Item item = session.getItem(request.getPath());
            if (item instanceof Property) {
                throw new WebdavException(WebdavI18n.errorPropertyPath.text(new Object[]{item.getPath()}));
            }
            return (Node)item;
        }

        void markForRollback(ResolvedRequest request) {
            this.sessionsMarkedForRollback.add(new SessionKey(request.getRepositoryName(), request.getWorkspaceName()));
        }

        Map<String, String> namespacesFor(ResolvedRequest request) throws RepositoryException {
            Session session = this.session(request);
            HashMap<String, String> namespaces = new HashMap<String, String>();
            for (String namespacePrefix : session.getNamespacePrefixes()) {
                String namespaceURI = session.getNamespaceURI(namespacePrefix);
                if (StringUtil.isBlank((String)namespacePrefix) || StringUtil.isBlank((String)namespaceURI) || namespacePrefix.equalsIgnoreCase("xmlns")) continue;
                namespaces.put(namespaceURI, namespacePrefix);
            }
            return namespaces;
        }

        boolean repositoryAndWorkspaceExist(ResolvedRequest request) throws RepositoryException {
            assert (request != null);
            if (request.getRepositoryName() != null) {
                if (request.getWorkspaceName() != null) {
                    try {
                        this.session(request);
                        return true;
                    }
                    catch (NoSuchWorkspaceException e) {
                        return false;
                    }
                }
                return RepositoryManager.getJcrRepositoryNames().contains(request.getRepositoryName());
            }
            return true;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        String[] childrenFor(ResolvedRequest request) throws RepositoryException {
            Iterator<Map.Entry<SessionKey, Session>> i$;
            String repositoryName;
            assert (request != null);
            Object var2_2 = null;
            if (request.getRepositoryName() != null) {
                if (request.getWorkspaceName() != null) {
                    try {
                        Session session = this.session(request);
                        List<String> list = ModeShapeWebdavStore.namesOfChildren(session.getRootNode());
                    }
                    catch (NoSuchWorkspaceException e) {
                        return null;
                    }
                }
                repositoryName = request.getRepositoryName();
                i$ = this.sessions.entrySet().iterator();
            } else {
                void var2_5;
                Set set = RepositoryManager.getJcrRepositoryNames();
                if (var2_5 == null) {
                    return null;
                }
                String[] stringArray = var2_5.toArray(new String[var2_5.size()]);
                return stringArray;
            }
            while (i$.hasNext()) {
                Map.Entry<SessionKey, Session> entry = i$.next();
                SessionKey key = entry.getKey();
                if (!repositoryName.equals(key.repositoryName)) continue;
                Session session = entry.getValue();
                try {
                    return session.getWorkspace().getAccessibleWorkspaceNames();
                }
                catch (RepositoryException e) {
                }
            }
            Session session = null;
            try {
                session = RepositoryManager.getSession((HttpServletRequest)request.getRequest(), (String)repositoryName, null);
                String[] stringArray = session.getWorkspace().getAccessibleWorkspaceNames();
                return stringArray;
            }
            catch (RepositoryException repositoryException) {
                ModeShapeWebdavStore.this.logger().warn((I18nResource)WebdavI18n.cannotGetRepositorySession, new Object[]{repositoryName, repositoryException.getMessage()});
                throw ModeShapeWebdavStore.this.translate(repositoryException);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        void commit() {
            try {
                for (Map.Entry<SessionKey, Session> entry : this.sessions.entrySet()) {
                    if (this.sessionsMarkedForRollback.contains(entry.getKey())) continue;
                    entry.getValue().save();
                }
            }
            catch (RepositoryException re) {
                try {
                    throw new WebdavException((Throwable)re);
                }
                catch (Throwable throwable) {
                    for (Session session : this.sessions.values()) {
                        try {
                            session.logout();
                        }
                        catch (Throwable t) {}
                    }
                    this.sessions.clear();
                    this.sessionsMarkedForRollback.clear();
                    throw throwable;
                }
            }
            for (Session session : this.sessions.values()) {
                try {
                    session.logout();
                }
                catch (Throwable throwable) {}
            }
            this.sessions.clear();
            this.sessionsMarkedForRollback.clear();
        }
    }
}

